/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;

public class SwingUtilities {
    public static void runOnEventDispatchThread(Runnable r) throws InvocationTargetException {
        if (javax.swing.SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                javax.swing.SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interrupted) {
                interrupted.printStackTrace();
            }
        }
    }

    public static Window getAncestorWindow(Component component) {
        Container parent = component.getParent();
        while (parent != null && !(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    protected SwingUtilities() {
    }
}

