/*
 * Decompiled with CFR 0.152.
 */
package RDP_Util.server;

import RDP_Util.main;
import RDP_Util.server.Config;
import RDP_Util.utilities.InetAdrUtility;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ConfigGUI
extends JFrame {
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxDefaultAdr;
    private JCheckBox jCheckBoxManualAdr;
    private JCheckBox jCheckBoxMultihomedEnabled;
    private JCheckBox jCheckBoxSSLEnabled;
    private JComboBox jComboBoxLocalAdrs;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JPasswordField jPasswordField;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldUsername;

    public ConfigGUI() {
        this.initComponents();
        Config.loadConfiguration();
        this.jComboBoxLocalAdrs.setSelectedItem(Config.server_address);
        this.jTextFieldPort.setText(String.valueOf(Config.server_port));
        this.jTextFieldUsername.setText(Config.username);
        this.jPasswordField.setText(Config.password);
        this.jCheckBoxSSLEnabled.setSelected(Config.ssl_enabled);
        this.jCheckBoxMultihomedEnabled.setSelected(Config.multihomed_enabled);
        this.jCheckBoxDefaultAdr.setSelected(Config.default_address);
        if (this.jCheckBoxMultihomedEnabled.isSelected()) {
            this.jCheckBoxMultihomedEnabledActionPerformed(null);
        } else {
            this.jCheckBoxManualAdrActionPerformed(null);
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel2 = new JPanel();
        this.jComboBoxLocalAdrs = new JComboBox<String>(InetAdrUtility.getLocalIPAdresses());
        this.jLabel1 = new JLabel();
        this.jCheckBoxMultihomedEnabled = new JCheckBox();
        this.jCheckBoxManualAdr = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jCheckBoxDefaultAdr = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jCheckBoxSSLEnabled = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Server configuration");
        this.setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigGUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Server configuration"));
        this.jComboBoxLocalAdrs.setMaximumSize(new Dimension(28, 20));
        this.jComboBoxLocalAdrs.setMinimumSize(new Dimension(28, 20));
        this.jLabel1.setText("Address:");
        this.jCheckBoxMultihomedEnabled.setText("Auto detect (Multihomed server)");
        this.jCheckBoxMultihomedEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigGUI.this.jCheckBoxMultihomedEnabledActionPerformed(evt);
            }
        });
        this.jCheckBoxManualAdr.setSelected(true);
        this.jCheckBoxManualAdr.setText("Manual");
        this.jCheckBoxManualAdr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigGUI.this.jCheckBoxManualAdrActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Port:");
        this.jTextFieldPort.setText("6666");
        this.jTextFieldPort.setMaximumSize(new Dimension(28, 20));
        this.jTextFieldPort.setMinimumSize(new Dimension(28, 20));
        this.jTextFieldPort.setPreferredSize(new Dimension(28, 20));
        this.jCheckBoxDefaultAdr.setText("Default");
        this.jLabel3.setText("Username:");
        this.jTextFieldUsername.setText("admin");
        this.jTextFieldUsername.setMaximumSize(new Dimension(28, Integer.MAX_VALUE));
        this.jLabel4.setText("Password:");
        this.jPasswordField.setText("admin");
        this.jPasswordField.setMaximumSize(new Dimension(28, Integer.MAX_VALUE));
        this.jCheckBoxSSLEnabled.setText("SSL");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxManualAdr).addGap(18, 18, 18).addComponent(this.jCheckBoxDefaultAdr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.jCheckBoxMultihomedEnabled).addGap(18, 18, 18).addComponent(this.jCheckBoxSSLEnabled)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldUsername, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPasswordField, -2, 148, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jComboBoxLocalAdrs, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPort, -1, 88, Short.MAX_VALUE)))))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxManualAdr).addComponent(this.jCheckBoxSSLEnabled).addComponent(this.jCheckBoxMultihomedEnabled).addComponent(this.jCheckBoxDefaultAdr)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jTextFieldPort, -2, -1, -2).addComponent(this.jComboBoxLocalAdrs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jPasswordField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextFieldUsername, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap(53, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 490) / 2, (screenSize.height - 209) / 2, 490, 209);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Config.server_address = this.jComboBoxLocalAdrs.getSelectedItem().toString();
        Config.server_port = Integer.valueOf(this.jTextFieldPort.getText());
        Config.username = this.jTextFieldUsername.getText();
        Config.password = String.copyValueOf(this.jPasswordField.getPassword());
        Config.multihomed_enabled = this.jCheckBoxMultihomedEnabled.isSelected();
        Config.ssl_enabled = this.jCheckBoxSSLEnabled.isSelected();
        Config.default_address = this.jCheckBoxDefaultAdr.isSelected();
        Config.storeConfiguration();
        this.dispose();
    }

    private void jCheckBoxManualAdrActionPerformed(ActionEvent evt) {
        this.jCheckBoxDefaultAdr.setEnabled(this.jCheckBoxManualAdr.isSelected());
        this.jComboBoxLocalAdrs.setEnabled(this.jCheckBoxManualAdr.isSelected());
        this.jCheckBoxMultihomedEnabled.setSelected(!this.jCheckBoxManualAdr.isSelected());
    }

    private void jCheckBoxMultihomedEnabledActionPerformed(ActionEvent evt) {
        this.jCheckBoxManualAdr.setSelected(!this.jCheckBoxMultihomedEnabled.isSelected());
        this.jCheckBoxDefaultAdr.setSelected(false);
        this.jCheckBoxDefaultAdr.setEnabled(!this.jCheckBoxMultihomedEnabled.isSelected());
        this.jComboBoxLocalAdrs.setEnabled(!this.jCheckBoxMultihomedEnabled.isSelected());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ConfigGUI().setVisible(true);
            }
        });
    }
}

