/*
 * Decompiled with CFR 0.152.
 */
package RDP_Util.viewer.rmi;

import RDP_Util.HostProperties;
import RDP_Util.main;
import RDP_Util.server.rmi.ServerInterface;
import RDP_Util.utilities.FileUtility;
import RDP_Util.utilities.InetAdrUtility;
import RDP_Util.utilities.ZipUtility;
import RDP_Util.viewer.Config;
import RDP_Util.viewer.Recorder;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.swing.JOptionPane;

public class Viewer
extends Thread {
    private int index = -1;
    private Recorder recorder;
    private Registry registry;
    private ServerInterface rmiServer;
    private String server = "127.0.0.1";
    private int port = 6666;
    private String username = "admin";
    private String password = "admin";
    private boolean ssl_enabled = false;
    private boolean connected = false;
    private ArrayList<Object> Objects;

    public Viewer() {
        Config.loadConfiguration();
        this.server = Config.server_address;
        this.port = Config.server_port;
        this.username = Config.username;
        this.password = Config.password;
        this.ssl_enabled = Config.ssl_enabled;
        if (this.ssl_enabled) {
            FileUtility.checkFile(main.KEY_STORE, "keystore");
            FileUtility.checkFile(main.TRUST_STORE, "truststore");
            main.setStoreProperties();
        } else {
            main.clearStoreProperties();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void Start() {
        this.connect();
        if (this.connected) {
            this.recorder = new Recorder(this);
            this.recorder.viewerGUI.Start();
        } else {
            this.Stop();
        }
    }

    public void Stop() {
        if (this.recorder != null) {
            this.recorder.Stop();
            this.recorder.interrupt();
        }
        this.disconnect();
        this.interrupt();
    }

    public int connect() {
        this.connected = false;
        try {
            this.registry = this.ssl_enabled ? LocateRegistry.getRegistry(this.server, this.port, new SslRMIClientSocketFactory()) : LocateRegistry.getRegistry(this.server, this.port);
            this.rmiServer = (ServerInterface)this.registry.lookup("ServerImpl");
            this.index = this.rmiServer.startViewer(InetAdrUtility.getLocalAdr(), this.username, this.password);
            if (this.index == -1) {
                JOptionPane.showMessageDialog(null, "Wrong username or password !!", "Error !!", 0);
                return -1;
            }
            this.displayStatus();
            this.Objects = new ArrayList();
            this.Objects.add(HostProperties.getLocalProperties());
            this.connected = true;
            return this.index;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error !!", 0);
            return -1;
        }
    }

    public void disconnect() {
        this.connected = false;
        try {
            if (this.rmiServer != null) {
                this.rmiServer.stopViewer(this.index);
                UnicastRemoteObject.unexportObject(this.rmiServer, true);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        this.rmiServer = null;
        this.registry = null;
    }

    public void updateData(Object object) {
        try {
            byte[] data = this.recorder.viewerData.isDataCompressionEnabled() ? ZipUtility.compressObject(object, this.recorder.viewerData.getCompressionLevel()) : ZipUtility.objecttoByteArray(object);
            this.recorder.connectionInfos.incSentData(data.length);
            this.updateData(data);
        }
        catch (IOException e) {
            e.getStackTrace();
        }
    }

    public void updateData(byte[] data) {
        try {
            this.rmiServer.updateData(data, this.index);
        }
        catch (Exception re) {
            re.getStackTrace();
        }
    }

    public void AddObject(Object object) {
        this.Objects.add(object);
    }

    public void updateOptions() {
        try {
            this.rmiServer.updateOptions(this.recorder.getViewerData(), this.index);
        }
        catch (Exception re) {
            re.getStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData() {
        ArrayList<Object> SendObjects;
        ArrayList<Object> arrayList = this.Objects;
        synchronized (arrayList) {
            if (this.recorder.viewerData.isClipboardTransferEnabled() && !this.recorder.clipbrdUtility.isEmpty()) {
                this.Objects.add(this.recorder.clipbrdUtility.getContent());
            }
            SendObjects = this.Objects;
            this.Objects = new ArrayList();
        }
        this.updateData(SendObjects);
    }

    public void recieveData() {
        Object object = null;
        try {
            byte[] data = this.rmiServer.updateData(this.index);
            object = ZipUtility.byteArraytoObject(data);
            this.recorder.connectionInfos.incReceivedData(data.length);
            this.recorder.updateAllData((ArrayList)object);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public byte[] ReceiveFile(String filename) {
        try {
            byte[] data = this.rmiServer.ReceiveFile(filename, this.index);
            this.recorder.connectionInfos.incReceivedData(data.length);
            return data;
        }
        catch (RemoteException re) {
            re.getStackTrace();
            return null;
        }
    }

    public void SendFile(byte[] buffer, String filename) {
        try {
            this.rmiServer.SendFile(buffer, filename, this.index);
            this.recorder.connectionInfos.incSentData(buffer.length);
        }
        catch (RemoteException re) {
            re.getStackTrace();
        }
    }

    public void displayStatus() {
        boolean auth = this.username.length() != 0 || this.password.length() != 0;
        System.out.println("Viewer connected to " + this.rmiServer + "\n\tauthentication: " + (auth ? "enabled" : "desabled") + "\n\tencryption: " + (this.ssl_enabled ? "enabled" : "desabled"));
    }
}

