/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ResultParser;

final class GeoResultParser
extends ResultParser {
    private GeoResultParser() {
    }

    public static GeoParsedResult parse(Result result) {
        double altitude;
        double longitude;
        double latitude;
        String rawText = result.getText();
        if (rawText == null || !rawText.startsWith("geo:") && !rawText.startsWith("GEO:")) {
            return null;
        }
        int queryStart = rawText.indexOf(63, 4);
        String geoURIWithoutQuery = queryStart < 0 ? rawText.substring(4) : rawText.substring(4, queryStart);
        int latitudeEnd = geoURIWithoutQuery.indexOf(44);
        if (latitudeEnd < 0) {
            return null;
        }
        int longitudeEnd = geoURIWithoutQuery.indexOf(44, latitudeEnd + 1);
        try {
            latitude = Double.parseDouble(geoURIWithoutQuery.substring(0, latitudeEnd));
            if (longitudeEnd < 0) {
                longitude = Double.parseDouble(geoURIWithoutQuery.substring(latitudeEnd + 1));
                altitude = 0.0;
            } else {
                longitude = Double.parseDouble(geoURIWithoutQuery.substring(latitudeEnd + 1, longitudeEnd));
                altitude = Double.parseDouble(geoURIWithoutQuery.substring(longitudeEnd + 1));
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new GeoParsedResult(rawText.startsWith("GEO:") ? "geo:" + rawText.substring(4) : rawText, latitude, longitude, altitude);
    }
}

