/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int codeWidth = 95;

    public ByteMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    public byte[] encode(String contents) {
        int digit;
        int i;
        if (contents.length() != 13) {
            throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + contents.length());
        }
        int firstDigit = Integer.parseInt(contents.substring(0, 1));
        int parities = EAN13Reader.FIRST_DIGIT_ENCODINGS[firstDigit];
        byte[] result = new byte[95];
        int pos = 0;
        pos += EAN13Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, 1);
        for (i = 1; i <= 6; ++i) {
            digit = Integer.parseInt(contents.substring(i, i + 1));
            if ((parities >> 6 - i & 1) == 1) {
                digit += 10;
            }
            pos += EAN13Writer.appendPattern(result, pos, UPCEANReader.L_AND_G_PATTERNS[digit], 0);
        }
        pos += EAN13Writer.appendPattern(result, pos, UPCEANReader.MIDDLE_PATTERN, 0);
        for (i = 7; i <= 12; ++i) {
            digit = Integer.parseInt(contents.substring(i, i + 1));
            pos += EAN13Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], 1);
        }
        pos += EAN13Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, 1);
        return result;
    }
}

