/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.DecoderResult;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int ALPHA = 0;
    private static final int LOWER = 1;
    private static final int MIXED = 2;
    private static final int PUNCT = 3;
    private static final int PUNCT_SHIFT = 4;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS = new char[]{';', '<', '>', '@', '[', '\\', '}', '_', '`', '~', '!', '\r', '\t', ',', ':', '\n', '-', '.', '$', '/', '\"', '|', '*', '(', ')', '?', '{', '}', '\''};
    private static final char[] MIXED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '&', '\r', '\t', ',', ':', '#', '-', '.', '$', '/', '+', '%', '*', '=', '^'};
    private static final String[] EXP900 = new String[]{"000000000000000000000000000000000000000000001", "000000000000000000000000000000000000000000900", "000000000000000000000000000000000000000810000", "000000000000000000000000000000000000729000000", "000000000000000000000000000000000656100000000", "000000000000000000000000000000590490000000000", "000000000000000000000000000531441000000000000", "000000000000000000000000478296900000000000000", "000000000000000000000430467210000000000000000", "000000000000000000387420489000000000000000000", "000000000000000348678440100000000000000000000", "000000000000313810596090000000000000000000000", "000000000282429536481000000000000000000000000", "000000254186582832900000000000000000000000000", "000228767924549610000000000000000000000000000", "205891132094649000000000000000000000000000000"};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] codewords) throws FormatException {
        StringBuffer result = new StringBuffer(100);
        int codeIndex = 1;
        int code = codewords[codeIndex++];
        while (codeIndex < codewords[0]) {
            switch (code) {
                case 900: {
                    codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result);
                    break;
                }
                case 901: {
                    codeIndex = DecodedBitStreamParser.byteCompaction(code, codewords, codeIndex, result);
                    break;
                }
                case 902: {
                    codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex, result);
                    break;
                }
                case 913: {
                    codeIndex = DecodedBitStreamParser.byteCompaction(code, codewords, codeIndex, result);
                    break;
                }
                case 924: {
                    codeIndex = DecodedBitStreamParser.byteCompaction(code, codewords, codeIndex, result);
                    break;
                }
                default: {
                    --codeIndex;
                    codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result);
                }
            }
            if (codeIndex < codewords.length) {
                code = codewords[codeIndex++];
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return new DecoderResult(null, result.toString(), null, null);
    }

    private static int textCompaction(int[] codewords, int codeIndex, StringBuffer result) {
        int[] textCompactionData = new int[codewords[0] << 1];
        int[] byteCompactionData = new int[codewords[0] << 1];
        int index = 0;
        boolean end = false;
        while (codeIndex < codewords[0] && !end) {
            int code;
            if ((code = codewords[codeIndex++]) < 900) {
                textCompactionData[index] = code / 30;
                textCompactionData[index + 1] = code % 30;
                index += 2;
                continue;
            }
            switch (code) {
                case 900: {
                    --codeIndex;
                    end = true;
                    break;
                }
                case 901: {
                    --codeIndex;
                    end = true;
                    break;
                }
                case 902: {
                    --codeIndex;
                    end = true;
                    break;
                }
                case 913: {
                    textCompactionData[index] = 913;
                    byteCompactionData[index] = code;
                    ++index;
                    break;
                }
                case 924: {
                    --codeIndex;
                    end = true;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(textCompactionData, byteCompactionData, index, result);
        return codeIndex;
    }

    private static void decodeTextCompaction(int[] textCompactionData, int[] byteCompactionData, int length, StringBuffer result) {
        int subMode = 0;
        int priorToShiftMode = 0;
        for (int i = 0; i < length; ++i) {
            int subModeCh = textCompactionData[i];
            int ch = 0;
            switch (subMode) {
                case 0: {
                    if (subModeCh < 26) {
                        ch = (char)(65 + subModeCh);
                        break;
                    }
                    if (subModeCh == 26) {
                        ch = 32;
                        break;
                    }
                    if (subModeCh == 27) {
                        subMode = 1;
                        break;
                    }
                    if (subModeCh == 28) {
                        subMode = 2;
                        break;
                    }
                    if (subModeCh == 29) {
                        priorToShiftMode = subMode;
                        subMode = 4;
                        break;
                    }
                    if (subModeCh != 913) break;
                    result.append((char)byteCompactionData[i]);
                    break;
                }
                case 1: {
                    if (subModeCh < 26) {
                        ch = (char)(97 + subModeCh);
                        break;
                    }
                    if (subModeCh == 26) {
                        ch = 32;
                        break;
                    }
                    if (subModeCh == 28) {
                        subMode = 0;
                        break;
                    }
                    if (subModeCh == 28) {
                        subMode = 2;
                        break;
                    }
                    if (subModeCh == 29) {
                        priorToShiftMode = subMode;
                        subMode = 4;
                        break;
                    }
                    if (subModeCh != 913) break;
                    result.append((char)byteCompactionData[i]);
                    break;
                }
                case 2: {
                    if (subModeCh < 25) {
                        ch = MIXED_CHARS[subModeCh];
                        break;
                    }
                    if (subModeCh == 25) {
                        subMode = 3;
                        break;
                    }
                    if (subModeCh == 26) {
                        ch = 32;
                        break;
                    }
                    if (subModeCh == 27) break;
                    if (subModeCh == 28) {
                        subMode = 0;
                        break;
                    }
                    if (subModeCh == 29) {
                        priorToShiftMode = subMode;
                        subMode = 4;
                        break;
                    }
                    if (subModeCh != 913) break;
                    result.append((char)byteCompactionData[i]);
                    break;
                }
                case 3: {
                    if (subModeCh < 29) {
                        ch = PUNCT_CHARS[subModeCh];
                        break;
                    }
                    if (subModeCh == 29) {
                        subMode = 0;
                        break;
                    }
                    if (subModeCh != 913) break;
                    result.append((char)byteCompactionData[i]);
                    break;
                }
                case 4: {
                    subMode = priorToShiftMode;
                    if (subModeCh < 29) {
                        ch = PUNCT_CHARS[subModeCh];
                        break;
                    }
                    if (subModeCh != 29) break;
                    subMode = 0;
                }
            }
            if (ch == 0) continue;
            result.append((char)ch);
        }
    }

    private static int byteCompaction(int mode, int[] codewords, int codeIndex, StringBuffer result) {
        block12: {
            block11: {
                if (mode != 901) break block11;
                int count = 0;
                long value = 0L;
                char[] decodedData = new char[6];
                int[] byteCompactedCodewords = new int[6];
                boolean end = false;
                while (codeIndex < codewords[0] && !end) {
                    int code;
                    if ((code = codewords[codeIndex++]) < 900) {
                        byteCompactedCodewords[count] = code;
                        ++count;
                        value *= 900L;
                        value += (long)code;
                    } else {
                        if (code == 900 || code == 901 || code == 902 || code == 924 || code == 928 || code == 923 || code == 922) {
                            // empty if block
                        }
                        --codeIndex;
                        end = true;
                    }
                    if (count % 5 != 0 || count <= 0) continue;
                    for (int j = 0; j < 6; ++j) {
                        decodedData[5 - j] = (char)(value % 256L);
                        value >>= 8;
                    }
                    result.append(decodedData);
                    count = 0;
                }
                for (int i = count / 5 * 5; i < count; ++i) {
                    result.append((char)byteCompactedCodewords[i]);
                }
                break block12;
            }
            if (mode != 924) break block12;
            int count = 0;
            long value = 0L;
            boolean end = false;
            while (codeIndex < codewords[0] && !end) {
                int code;
                if ((code = codewords[codeIndex++]) < 900) {
                    ++count;
                    value *= 900L;
                    value += (long)code;
                } else {
                    if (code == 900 || code == 901 || code == 902 || code == 924 || code == 928 || code == 923 || code == 922) {
                        // empty if block
                    }
                    --codeIndex;
                    end = true;
                }
                if (count % 5 != 0 || count <= 0) continue;
                char[] decodedData = new char[6];
                for (int j = 0; j < 6; ++j) {
                    decodedData[5 - j] = (char)(value % 256L);
                    value >>= 8;
                }
                result.append(decodedData);
            }
        }
        return codeIndex;
    }

    private static int numericCompaction(int[] codewords, int codeIndex, StringBuffer result) {
        int count = 0;
        boolean end = false;
        int[] numericCodewords = new int[15];
        while (codeIndex < codewords.length && !end) {
            int code;
            if ((code = codewords[codeIndex++]) < 900) {
                numericCodewords[count] = code;
                ++count;
            } else {
                if (code == 900 || code == 901 || code == 924 || code == 928 || code == 923 || code == 922) {
                    // empty if block
                }
                --codeIndex;
                end = true;
            }
            if (count % 15 != 0 && code != 902) continue;
            String s = DecodedBitStreamParser.decodeBase900toBase10(numericCodewords, count);
            result.append(s);
            count = 0;
        }
        return codeIndex;
    }

    private static String decodeBase900toBase10(int[] codewords, int count) {
        StringBuffer accum = null;
        for (int i = 0; i < count; ++i) {
            StringBuffer value = DecodedBitStreamParser.multiply(EXP900[count - i - 1], codewords[i]);
            accum = accum == null ? value : DecodedBitStreamParser.add(accum.toString(), value.toString());
        }
        String result = null;
        for (int i = 0; i < accum.length(); ++i) {
            if (accum.charAt(i) != '1') continue;
            result = accum.toString().substring(i + 1);
            break;
        }
        if (result == null) {
            result = accum.toString();
        }
        return result;
    }

    private static StringBuffer multiply(String value1, int value2) {
        int j;
        StringBuffer result = new StringBuffer(value1.length());
        for (int i = 0; i < value1.length(); ++i) {
            result.append('0');
        }
        int hundreds = value2 / 100;
        int tens = value2 / 10 % 10;
        int ones = value2 % 10;
        for (j = 0; j < ones; ++j) {
            result = DecodedBitStreamParser.add(result.toString(), value1);
        }
        for (j = 0; j < tens; ++j) {
            result = DecodedBitStreamParser.add(result.toString(), (value1 + '0').substring(1));
        }
        for (j = 0; j < hundreds; ++j) {
            result = DecodedBitStreamParser.add(result.toString(), (value1 + "00").substring(2));
        }
        return result;
    }

    private static StringBuffer add(String value1, String value2) {
        StringBuffer temp1 = new StringBuffer(5);
        StringBuffer temp2 = new StringBuffer(5);
        StringBuffer result = new StringBuffer(value1.length());
        for (int i = 0; i < value1.length(); ++i) {
            result.append('0');
        }
        int carry = 0;
        for (int i = value1.length() - 3; i > -1; i -= 3) {
            temp1.setLength(0);
            temp1.append(value1.charAt(i));
            temp1.append(value1.charAt(i + 1));
            temp1.append(value1.charAt(i + 2));
            temp2.setLength(0);
            temp2.append(value2.charAt(i));
            temp2.append(value2.charAt(i + 1));
            temp2.append(value2.charAt(i + 2));
            int intValue1 = Integer.parseInt(temp1.toString());
            int intValue2 = Integer.parseInt(temp2.toString());
            int sumval = (intValue1 + intValue2 + carry) % 1000;
            carry = (intValue1 + intValue2 + carry) / 1000;
            result.setCharAt(i + 2, (char)(sumval % 10 + 48));
            result.setCharAt(i + 1, (char)(sumval / 10 % 10 + 48));
            result.setCharAt(i, (char)(sumval / 100 + 48));
        }
        return result;
    }
}

