/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.detector.Detector;
import java.util.Hashtable;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected Decoder getDecoder() {
        return this.decoder;
    }

    public Result decode(BinaryBitmap image) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(image, null);
    }

    public Result decode(BinaryBitmap image, Hashtable hints) throws NotFoundException, ChecksumException, FormatException {
        ResultPoint[] points;
        DecoderResult decoderResult;
        if (hints != null && hints.containsKey(DecodeHintType.PURE_BARCODE)) {
            BitMatrix bits = QRCodeReader.extractPureBits(image.getBlackMatrix());
            decoderResult = this.decoder.decode(bits, hints);
            points = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(image.getBlackMatrix()).detect(hints);
            decoderResult = this.decoder.decode(detectorResult.getBits(), hints);
            points = detectorResult.getPoints();
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.QR_CODE);
        if (decoderResult.getByteSegments() != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        if (decoderResult.getECLevel() != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
        }
        return result;
    }

    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix image) throws NotFoundException {
        int dimension;
        int sampleDimension;
        int rowEndOfSymbol;
        int moduleEnd;
        int borderWidth;
        int height = image.getHeight();
        int width = image.getWidth();
        int minDimension = Math.min(height, width);
        for (borderWidth = 0; borderWidth < minDimension && !image.get(borderWidth, borderWidth); ++borderWidth) {
        }
        if (borderWidth == minDimension) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (moduleEnd = borderWidth; moduleEnd < minDimension && image.get(moduleEnd, moduleEnd); ++moduleEnd) {
        }
        if (moduleEnd == minDimension) {
            throw NotFoundException.getNotFoundInstance();
        }
        int moduleSize = moduleEnd - borderWidth;
        for (rowEndOfSymbol = width - 1; rowEndOfSymbol >= 0 && !image.get(rowEndOfSymbol, borderWidth); --rowEndOfSymbol) {
        }
        if (rowEndOfSymbol < 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((++rowEndOfSymbol - borderWidth) % moduleSize != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((sampleDimension = (borderWidth += moduleSize >> 1) + ((dimension = (rowEndOfSymbol - borderWidth) / moduleSize) - 1) * moduleSize) >= width || sampleDimension >= height) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bits = new BitMatrix(dimension);
        for (int i = 0; i < dimension; ++i) {
            int iOffset = borderWidth + i * moduleSize;
            for (int j = 0; j < dimension; ++j) {
                if (!image.get(borderWidth + j * moduleSize, iOffset)) continue;
                bits.set(j, i);
            }
        }
        return bits;
    }
}

