/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentLocation;

public class ZipRepository
implements Repository {
    private ZipContentLocation root;
    private MimeRegistry mimeRegistry;

    public ZipRepository() {
        this(new DefaultMimeRegistry());
    }

    public ZipRepository(MimeRegistry mimeRegistry) {
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.mimeRegistry = mimeRegistry;
        this.root = new ZipContentLocation(this, null, "");
    }

    public ZipRepository(InputStream in) throws IOException {
        this(in, new DefaultMimeRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipRepository(InputStream in, MimeRegistry mimeRegistry) throws IOException {
        this(mimeRegistry);
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry nextEntry = zipIn.getNextEntry();
            while (nextEntry != null) {
                String[] buildName = RepositoryUtilities.splitPath(nextEntry.getName(), "/");
                if (nextEntry.isDirectory()) {
                    this.root.updateDirectoryEntry(buildName, 0, nextEntry);
                } else {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    Deflater def = new Deflater(nextEntry.getMethod());
                    try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, def);){
                        IOUtils.getInstance().copyStreams((InputStream)zipIn, (OutputStream)dos);
                        dos.flush();
                    }
                    finally {
                        def.end();
                    }
                    this.root.updateEntry(buildName, 0, nextEntry, bos.toByteArray());
                }
                zipIn.closeEntry();
                nextEntry = zipIn.getNextEntry();
            }
        }
    }

    @Override
    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    @Override
    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void write(OutputStream outputStream) throws IOException, ContentIOException {
        RepositoryUtilities.writeAsZip(outputStream, this);
    }

    public void writeToZipStream(ZipOutputStream zipOutputStream, Repository repository) throws IOException, ContentIOException {
        RepositoryUtilities.writeToZipStream(zipOutputStream, repository);
    }
}

