/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ro.fortsoft.pf4j.PluginRepository;
import ro.fortsoft.pf4j.util.FileUtils;

public class DefaultPluginRepository
implements PluginRepository {
    private final File directory;
    private final FileFilter filter;

    public DefaultPluginRepository(File directory, FileFilter filter) {
        this.directory = directory;
        this.filter = filter;
    }

    @Override
    public List<File> getPluginArchives() {
        File[] files = this.directory.listFiles(this.filter);
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    @Override
    public boolean deletePluginArchive(String pluginPath) {
        File[] files = this.directory.listFiles(this.filter);
        if (files != null) {
            File pluginArchive = null;
            String dirName = pluginPath.substring(1);
            for (File archive : files) {
                String name = archive.getName().substring(0, archive.getName().lastIndexOf(46));
                if (!name.equals(dirName)) continue;
                pluginArchive = archive;
                break;
            }
            if (pluginArchive != null && pluginArchive.exists()) {
                return FileUtils.delete(pluginArchive);
            }
        }
        return false;
    }
}

