/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.CyclicDependencyException;
import ro.fortsoft.pf4j.PluginDependency;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.PluginNotFoundException;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.util.DirectedGraph;

public class DependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(DependencyResolver.class);
    private List<PluginWrapper> plugins;
    private DirectedGraph<String> dependenciesGraph;
    private DirectedGraph<String> dependentsGraph;
    private boolean resolved;

    public void resolve(List<PluginWrapper> plugins) {
        this.plugins = plugins;
        this.initGraph();
        this.resolved = true;
    }

    public List<String> getDependecies(String pluginsId) {
        if (!this.resolved) {
            return Collections.emptyList();
        }
        return this.dependenciesGraph.getNeighbors(pluginsId);
    }

    public List<String> getDependents(String pluginsId) {
        if (!this.resolved) {
            return Collections.emptyList();
        }
        return this.dependentsGraph.getNeighbors(pluginsId);
    }

    public List<PluginWrapper> getSortedPlugins() throws PluginException {
        if (!this.resolved) {
            return Collections.emptyList();
        }
        log.debug("Graph: {}", this.dependenciesGraph);
        List<String> pluginsId = this.dependenciesGraph.reverseTopologicalSort();
        if (pluginsId == null) {
            throw new CyclicDependencyException("Cyclic dependencies !!!" + this.dependenciesGraph.toString());
        }
        log.debug("Plugins order: {}", pluginsId);
        ArrayList<PluginWrapper> sortedPlugins = new ArrayList<PluginWrapper>();
        for (String pluginId : pluginsId) {
            sortedPlugins.add(this.getPlugin(pluginId));
        }
        return sortedPlugins;
    }

    private void initGraph() {
        this.dependenciesGraph = new DirectedGraph();
        this.dependentsGraph = new DirectedGraph();
        for (PluginWrapper pluginWrapper : this.plugins) {
            PluginDescriptor descriptor = pluginWrapper.getDescriptor();
            String pluginId = descriptor.getPluginId();
            List<PluginDependency> dependencies = descriptor.getDependencies();
            if (!dependencies.isEmpty()) {
                for (PluginDependency dependency : dependencies) {
                    this.dependenciesGraph.addEdge(pluginId, dependency.getPluginId());
                    this.dependentsGraph.addEdge(dependency.getPluginId(), pluginId);
                }
                continue;
            }
            this.dependenciesGraph.addVertex(pluginId);
            this.dependentsGraph.addVertex(pluginId);
        }
    }

    private PluginWrapper getPlugin(String pluginId) throws PluginNotFoundException {
        for (PluginWrapper pluginWrapper : this.plugins) {
            if (!pluginId.equals(pluginWrapper.getDescriptor().getPluginId())) continue;
            return pluginWrapper;
        }
        throw new PluginNotFoundException(pluginId);
    }
}

