/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginDependency;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginManager;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final String PLUGIN_PACKAGE_PREFIX = "ro.fortsoft.pf4j.";
    private PluginManager pluginManager;
    private PluginDescriptor pluginDescriptor;

    public PluginClassLoader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
        super(new URL[0], parent);
        this.pluginManager = pluginManager;
        this.pluginDescriptor = pluginDescriptor;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> clazz;
            log.trace("Received request to load class '{}'", (Object)className);
            if (className.startsWith(PLUGIN_PACKAGE_PREFIX)) {
                log.trace("Delegate the loading of class '{}' to parent", (Object)className);
                try {
                    return this.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if ((clazz = this.findLoadedClass(className)) != null) {
                log.trace("Found loaded class '{}'", (Object)className);
                return clazz;
            }
            try {
                clazz = this.findClass(className);
                log.trace("Found class '{}' in plugin classpath", (Object)className);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                log.trace("Search in dependencies for class '{}'", (Object)className);
                List<PluginDependency> dependencies = this.pluginDescriptor.getDependencies();
                for (PluginDependency dependency : dependencies) {
                    PluginClassLoader classLoader = this.pluginManager.getPluginClassLoader(dependency.getPluginId());
                    try {
                        return classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException e2) {
                    }
                }
                log.trace("Couldn't find class '{}' in plugin classpath. Delegating to parent", (Object)className);
                return super.loadClass(className);
            }
        }
    }

    @Override
    public URL getResource(String name) {
        log.trace("Trying to find resource '{}' in plugin classpath", (Object)name);
        URL url = this.findResource(name);
        if (url != null) {
            log.trace("Found resource '{}' in plugin classpath", (Object)name);
            return url;
        }
        log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent");
        return super.getResource(name);
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

