/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import com.github.zafarkhaja.semver.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.util.StringUtils;

public class PropertiesPluginDescriptorFinder
implements PluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(PropertiesPluginDescriptorFinder.class);
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "plugin.properties";
    private String propertiesFileName;

    public PropertiesPluginDescriptorFinder() {
        this(DEFAULT_PROPERTIES_FILE_NAME);
    }

    public PropertiesPluginDescriptorFinder(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    @Override
    public PluginDescriptor find(File pluginRepository) throws PluginException {
        Properties properties = this.readProperties(pluginRepository);
        PluginDescriptor pluginDescriptor = this.createPluginDescriptor(properties);
        this.validatePluginDescriptor(pluginDescriptor);
        return pluginDescriptor;
    }

    protected Properties readProperties(File pluginRepository) throws PluginException {
        File propertiesFile = new File(pluginRepository, this.propertiesFileName);
        log.debug("Lookup plugin descriptor in '{}'", (Object)propertiesFile);
        if (!propertiesFile.exists()) {
            throw new PluginException("Cannot find '" + propertiesFile + "' file");
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(propertiesFile);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        Properties properties = new Properties();
        try {
            properties.load(input);
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), e);
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                throw new PluginException(e.getMessage(), e);
            }
        }
        return properties;
    }

    protected PluginDescriptor createPluginDescriptor(Properties properties) {
        PluginDescriptor pluginDescriptor = this.createPluginDescriptorInstance();
        String id = properties.getProperty("plugin.id");
        pluginDescriptor.setPluginId(id);
        String clazz = properties.getProperty("plugin.class");
        pluginDescriptor.setPluginClass(clazz);
        String version = properties.getProperty("plugin.version");
        if (StringUtils.isNotEmpty(version)) {
            pluginDescriptor.setPluginVersion(Version.valueOf((String)version));
        }
        String provider = properties.getProperty("plugin.provider");
        pluginDescriptor.setProvider(provider);
        String dependencies = properties.getProperty("plugin.dependencies");
        pluginDescriptor.setDependencies(dependencies);
        return pluginDescriptor;
    }

    protected PluginDescriptor createPluginDescriptorInstance() {
        return new PluginDescriptor();
    }

    protected void validatePluginDescriptor(PluginDescriptor pluginDescriptor) throws PluginException {
        if (StringUtils.isEmpty(pluginDescriptor.getPluginId())) {
            throw new PluginException("plugin.id cannot be empty");
        }
        if (StringUtils.isEmpty(pluginDescriptor.getPluginClass())) {
            throw new PluginException("plugin.class cannot be empty");
        }
        if (pluginDescriptor.getVersion() == null) {
            throw new PluginException("plugin.version cannot be empty");
        }
    }
}

