/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unzip {
    private static final Logger log = LoggerFactory.getLogger(Unzip.class);
    private File destination;
    private File source;

    public Unzip() {
    }

    public Unzip(File source, File destination) {
        this.source = source;
        this.destination = destination;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void extract() throws IOException {
        log.debug("Extract content of '{}' to '{}'", (Object)this.source, (Object)this.destination);
        this.removeDirectory(this.destination);
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.source));
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            try {
                File file = new File(this.destination, zipEntry.getName());
                File dir = new File(file.getParent());
                dir.mkdirs();
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                byte[] buffer = new byte[1024];
                int length = 0;
                FileOutputStream fos = new FileOutputStream(file);
                while ((length = zipInputStream.read(buffer)) >= 0) {
                    fos.write(buffer, 0, length);
                }
                fos.close();
            }
            catch (FileNotFoundException e) {
                log.error("File '{}' not found", (Object)zipEntry.getName());
            }
        }
        zipInputStream.close();
    }

    private boolean removeDirectory(File directory) {
        File[] files;
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                this.removeDirectory(file);
                continue;
            }
            file.delete();
        }
        return directory.delete();
    }
}

