/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.station.AbstractResizeRequestHandler;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.Insets;
import java.awt.Rectangle;

public class ScreenResizeRequestHandler
extends AbstractResizeRequestHandler {
    private ScreenDockStation station;

    public ScreenResizeRequestHandler(ScreenDockStation station) {
        this.station = station;
    }

    public void handleResizeRequest(CControl control) {
        int n = this.station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            ScreenDockWindow window = this.station.getWindow(i);
            RequestDimension size = this.getAndClearResizeRequest(this.station.getDockable(i));
            if (size == null) continue;
            Insets insets = window.getDockableInsets();
            Rectangle bounds = window.getWindowBounds();
            int width = size.isWidthSet() ? size.getWidth() + insets.left + insets.right : bounds.width;
            int height = size.isHeightSet() ? size.getHeight() + insets.top + insets.bottom : bounds.height;
            window.setWindowBounds(new Rectangle(bounds.x + (bounds.width - width) / 2, bounds.y + (bounds.height - height) / 2, width, height));
        }
    }
}

