/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppboxing.anzeige.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.sportdata.setppboxing.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppboxing.anzeige.beans.ScoringObject;
import org.sportdata.setppboxing.anzeige.constants.MainConstants;
import org.sportdata.setppboxing.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppboxing.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppboxing.anzeige.utils.FehlerFenster;
import org.sportdata.setppboxing.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setppboxing.anzeige.utils.RefereeWindowRenderer;

public class RefereePointsWindow
extends JFrame {
    private static final long serialVersionUID = 3970362580306447158L;
    private JButton b;
    private JButton c;
    private JButton d;
    private JXTable e;
    private DefaultTableModel f;
    private Vector<String> g;
    private Vector<Vector<Object>> h;
    private JLabel i;
    private Thread j = null;
    boolean a = false;
    private JLabel k;

    public RefereePointsWindow() {
        this.setTitle("Scoring APP Checker");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 500) / 2, (screenSize.height - 350) / 2, 500, 350);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initTable();
        this.a();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RefereePointsWindow.this.close();
            }
        });
        this.setVisible(true);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.k = new JLabel();
        this.add((Component)this.k, "North");
        this.add((Component)new JScrollPane((Component)this.e), "Center");
        JPanel psouth = new JPanel();
        this.b = new JButton("Save scores");
        this.b.setIcon(new ImageIcon("images/Chart19.gif"));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereePointsWindow.this.savePoints();
            }
        });
        this.c = new JButton(AnzeigeResource.getResourceString("general.reset2"));
        this.c.setIcon(new ImageIcon("images/changeside.png"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereePointsWindow.this.reset();
            }
        });
        this.d = new JButton("Add Judge manually");
        this.d.setIcon(new ImageIcon("images/add.png"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String judgeval = JOptionPane.showInputDialog("Add Judge manually:", (Object)"");
                int judge = 0;
                try {
                    judge = Integer.parseInt(judgeval);
                    int maxjudge = 3;
                    if (AnzeigePropertiesHelper.getPpboxing5referees().equals("true")) {
                        maxjudge = 5;
                    }
                    if (judge > 0 && judge <= maxjudge) {
                        if (AnzeigeMaster.getInstance().getRefereesPoints().containsKey(judge)) {
                            AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue(0.0f);
                            AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue2(0.0f);
                        } else {
                            ScoringObject so = new ScoringObject();
                            so.setReferee(judge);
                            so.setScoreValue(0.0f);
                            so.setScoreValue2(0.0f);
                            so.setScoreName("resultinput_manual");
                            AnzeigeMaster.getInstance().getRefereesPoints().put(judge, so);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.i = new JLabel();
        psouth.add(this.i);
        psouth.add(this.b);
        psouth.add(this.c);
        psouth.add(this.d);
        this.add((Component)psouth, "South");
    }

    public void initTable() {
        if (this.h != null) {
            this.h.clear();
        } else {
            this.h = new Vector();
        }
        this.g = new Vector();
        this.g.add("Referee/Judge");
        this.g.add("Score " + MainConstants.AKA_LABEL_TEXT);
        this.g.add("Score " + MainConstants.AO_LABEL_TEXT);
        this.f = new DefaultTableModel(this.h, this.g){
            Class[] a;
            boolean[] b;
            {
                this.a = new Class[]{String.class, String.class, String.class};
                this.b = new boolean[3];
            }

            public Class getColumnClass(int columnIndex) {
                return this.a[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.b[columnIndex];
            }
        };
        this.e = new JXTable((TableModel)this.f);
        this.e.setAutoResizeMode(4);
        this.e.getTableHeader().setReorderingAllowed(false);
        this.e.setSelectionMode(0);
        this.e.setRolloverEnabled(true);
        this.e.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, Color.GRAY, Color.WHITE));
        this.e.setSortable(false);
        this.e.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                block10: {
                    if (evt.getClickCount() == 2) {
                        Point p = evt.getPoint();
                        int rowNumber = RefereePointsWindow.this.e.rowAtPoint(p);
                        int colnumber = RefereePointsWindow.this.e.columnAtPoint(p);
                        try {
                            int scoreint2;
                            String score;
                            int judge = Integer.parseInt((String)RefereePointsWindow.this.e.getValueAt(rowNumber, 0));
                            if (judge <= 0) break block10;
                            if (colnumber == 1) {
                                score = JOptionPane.showInputDialog("Judge " + judge + " score for " + MainConstants.AKA_LABEL_TEXT, RefereePointsWindow.this.e.getValueAt(rowNumber, colnumber));
                                try {
                                    scoreint2 = Integer.parseInt(score);
                                    if (scoreint2 >= 7 && scoreint2 <= 10) {
                                        AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue(Float.parseFloat(score));
                                    }
                                }
                                catch (Exception scoreint2) {
                                    // empty catch block
                                }
                            }
                            if (colnumber != 2) break block10;
                            score = JOptionPane.showInputDialog("Judge " + judge + " score for " + MainConstants.AO_LABEL_TEXT, RefereePointsWindow.this.e.getValueAt(rowNumber, colnumber));
                            try {
                                scoreint2 = Integer.parseInt(score);
                                if (scoreint2 >= 7 && scoreint2 <= 10) {
                                    AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue2(Float.parseFloat(score));
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.e.setDefaultRenderer(String.class, (TableCellRenderer)new RefereeWindowRenderer());
    }

    public synchronized void updateTableData() {
        try {
            new SwingWorker<String, Void>(){

                protected String a() {
                    if (RefereePointsWindow.this.h != null) {
                        RefereePointsWindow.this.h.clear();
                    } else {
                        RefereePointsWindow.this.h = new Vector();
                    }
                    for (int key : AnzeigeMaster.getInstance().getRefereesPoints().keySet()) {
                        if (AnzeigeMaster.getInstance().getRefereesPoints().get(key).getReferee() > 5) continue;
                        Vector<Object> subvector = new Vector<Object>();
                        subvector.add("" + key);
                        int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                        int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                        subvector.add(score1);
                        subvector.add(score2);
                        RefereePointsWindow.this.h.add(subvector);
                    }
                    return "";
                }

                @Override
                protected void done() {
                    RefereePointsWindow.this.e.clearSelection();
                    RefereePointsWindow.this.f.setDataVector(RefereePointsWindow.this.h, RefereePointsWindow.this.g);
                    RefereePointsWindow.this.e.repaint();
                }

                @Override
                protected /* synthetic */ Object doInBackground() throws Exception {
                    return this.a();
                }
            }.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void savePoints() {
        if (AnzeigeMaster.getInstance().getRefereesPoints().size() > 0) {
            int roundssaved = AnzeigeMaster.getInstance().getAcp().getMatchScoreOverview().getRefereescoresaka().size();
            if (roundssaved < Integer.parseInt(AnzeigePropertiesHelper.getPpnumberofrounds())) {
                for (Integer key : AnzeigeMaster.getInstance().getRefereesPoints().keySet()) {
                    ScoringObject obj = AnzeigeMaster.getInstance().getRefereesPoints().get(key);
                    int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                    int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                    String score1str = "" + score1;
                    String score2str = "" + score2;
                    System.out.println(score1str + " - " + score2str);
                    if (obj.getReferee() == 1) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, score2str);
                    }
                    if (obj.getReferee() == 2) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, score2str);
                    }
                    if (obj.getReferee() == 3) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, score2str);
                    }
                    if (obj.getReferee() == 4) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(242, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(243, score2str);
                    }
                    if (obj.getReferee() != 5) continue;
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(246, score1str);
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(247, score2str);
                }
                this.reset();
                if (AnzeigeMaster.getInstance().getAnzeige().getMatchroundcomp().getNumberOfRounds() == AnzeigeMaster.getInstance().getAnzeige().getMatchroundcomp().getRoundwinner().size() + 1 && AnzeigeMaster.getInstance().getAnzeige().getMatchroundcomp().getActualRound() == AnzeigeMaster.getInstance().getAnzeige().getMatchroundcomp().getNumberOfRounds() && AnzeigeMaster.getInstance().getAnzeige().getClock().getSecoundsact() == 0) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(252, "");
                } else {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(250, "");
                }
            } else {
                new FehlerFenster("Cannot save round scores, already " + roundssaved + " rounds saved!");
            }
        }
    }

    public void reset() {
        AnzeigeMaster.getInstance().getRefereesPoints().clear();
        this.updateTableData();
    }

    public void checkPoints() {
        this.a = false;
        if (this.j == null) {
            this.j = new Thread("SET Point Scoring Checker"){

                @Override
                public void run() {
                    RefereePointsWindow.this.i.setIcon(new ImageIcon("images/ajax_loading.gif"));
                    while (!RefereePointsWindow.this.a) {
                        RefereePointsWindow.this.updateTableData();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RefereePointsWindow.this.i.setIcon(null);
                }
            };
            this.j.start();
        }
    }

    public void stopCheckPoints() {
        this.a = true;
    }

    public void close() {
        this.stopCheckPoints();
        AnzeigeMaster.getInstance().setRefereeWindowLocation(this.getLocation());
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setName(String name) {
        this.k.setText(name);
    }
}

