/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.anzeige.beans;

import java.util.Map;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppwakolc.anzeige.constants.MainConstants;

public class ScoringAuthObject {
    private String a;
    private String b;
    private String c;
    private boolean d;
    private String e;

    public String getPin() {
        return this.a;
    }

    public void setPin(String pin) {
        this.a = pin;
    }

    public String getRefnr() {
        return this.b;
    }

    public void setRefnr(String refnr) {
        this.b = refnr;
    }

    public String getImei() {
        return this.c;
    }

    public void setImei(String imei) {
        this.c = imei;
    }

    public boolean isIsassigned() {
        return this.d;
    }

    public void setIsassigned(boolean isassigned) {
        this.d = isassigned;
    }

    public String getComment() {
        return this.e;
    }

    public void setComment(String comment) {
        this.e = comment;
    }

    public void mapObject(Map<String, String[]> map) {
        if (map.size() > 0) {
            for (String key : map.keySet()) {
                if (key.equals("pin")) {
                    try {
                        this.a = map.get(key)[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key.equals("imei")) {
                    try {
                        this.c = map.get(key)[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!key.equals("refnr")) continue;
                try {
                    this.b = map.get(key)[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void mapObjectSimple(Map<String, String[]> map) {
        if (map.size() > 0) {
            for (String key : map.keySet()) {
                if (key.equals("imei")) {
                    try {
                        this.c = map.get(key)[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!key.equals("refnr")) continue;
                try {
                    this.b = map.get(key)[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isValidObject() {
        if (!(this.a == null || this.a.trim().equals("") || this.c == null || this.c.trim().equals("") || this.b == null || this.b.trim().equals(""))) {
            int refnrint = 0;
            int pinint = 0;
            try {
                refnrint = Integer.parseInt(this.b);
            }
            catch (NumberFormatException e) {
                this.e = "Referee number is no Integer";
                return false;
            }
            try {
                pinint = Integer.parseInt(this.a);
            }
            catch (NumberFormatException e) {
                this.e = "Pin number is no Integer";
                return false;
            }
            if (refnrint <= 0 || refnrint > MainConstants.REFEREE_MAX && refnrint != 8) {
                this.e = "Referee number not valid";
                return false;
            }
            if (!AnzeigeMaster.getInstance().getReferees().containsKey(this.c) && pinint != AnzeigeMaster.getInstance().getPin()) {
                this.e = "Invalid Pin ";
                return false;
            }
            if (AnzeigeMaster.getInstance().getReferees().containsKey(this.c)) {
                if (AnzeigeMaster.getInstance().getReferees().get(this.c).isIsassigned()) {
                    this.e = "Device and Referee Number already assigned";
                    return false;
                }
                AnzeigeMaster.getInstance().removeReferee(this.c);
                AnzeigeMaster.getInstance().addReferee(this);
                this.e = "Replace Device and Referee Number waiting for approval";
            } else {
                AnzeigeMaster.getInstance().addReferee(this);
            }
            return true;
        }
        this.e = "Required value is NULL";
        return false;
    }

    public boolean isValidObjectSimple() {
        if (this.c != null && !this.c.trim().equals("") && this.b != null && !this.b.trim().equals("")) {
            int refnrint = 0;
            try {
                refnrint = Integer.parseInt(this.b);
            }
            catch (NumberFormatException e) {
                this.e = "Referee number is no Integer";
                return false;
            }
            if (refnrint <= 0 || refnrint > MainConstants.REFEREE_MAX && refnrint != 8) {
                this.e = "Referee number not valid";
                return false;
            }
            return true;
        }
        this.e = "Required value is NULL";
        return false;
    }

    public void printObject() {
        System.out.println("Mapped SET PP WAKO LC Scoring Auth Object:");
        System.out.println("-----------------------------");
        System.out.println("imei: " + this.getImei());
        System.out.println("pin: " + this.getPin());
        System.out.println("refnr: " + this.getRefnr());
        System.out.println("isassigned: " + this.isIsassigned());
        System.out.println("isvalid: " + this.isValidObject());
        System.out.println("comment: " + this.getComment());
        System.out.println("-----------------------------");
    }

    public void printObjectSimple() {
        System.out.println("Mapped SET PP WAKO LC Scoring Auth Object:");
        System.out.println("-----------------------------");
        System.out.println("imei: " + this.getImei());
        System.out.println("refnr: " + this.getRefnr());
        System.out.println("isvalid: " + this.isValidObjectSimple());
        System.out.println("comment: " + this.getComment());
        System.out.println("-----------------------------");
    }
}

