/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.anzeige.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppwakolc.anzeige.beans.ScoringObject;
import org.sportdata.setppwakolc.anzeige.constants.MainConstants;
import org.sportdata.setppwakolc.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppwakolc.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppwakolc.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setppwakolc.anzeige.utils.RefereeWindowRenderer;

public class RefereeVoteWindow
extends JFrame {
    private static final long serialVersionUID = 3970362580306447158L;
    private JButton b;
    private JButton c;
    private JButton d;
    private JXTable e;
    private DefaultTableModel f;
    private Vector<String> g;
    private Vector<Vector<Object>> h;
    private JLabel i;
    private Thread j = null;
    boolean a = false;
    private JLabel k;

    public RefereeVoteWindow() {
        this.setTitle("Judge Votes");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initTable();
        this.a();
        this.setColumnWidth();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RefereeVoteWindow.this.close();
            }
        });
        this.setVisible(true);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.k = new JLabel();
        this.add((Component)this.k, "North");
        this.add((Component)new JScrollPane((Component)this.e), "Center");
        JPanel psouth = new JPanel();
        this.b = new JButton("Save Votes");
        this.b.setIcon(new ImageIcon("images/Chart19.gif"));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereeVoteWindow.this.savePoints();
            }
        });
        this.c = new JButton(AnzeigeResource.getResourceString("general.reset2"));
        this.c.setIcon(new ImageIcon("images/changeside.png"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereeVoteWindow.this.reset();
            }
        });
        this.d = new JButton("Add Judge manually");
        this.d.setIcon(new ImageIcon("images/add.png"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String judgeval = JOptionPane.showInputDialog("Add Judge manually:", (Object)"");
                int judge = 0;
                try {
                    judge = Integer.parseInt(judgeval);
                    int maxjudge = 3;
                    if (AnzeigePropertiesHelper.getPpwakolc5referees().equals("true")) {
                        maxjudge = 5;
                    }
                    if (judge > 0 && judge <= maxjudge) {
                        if (AnzeigeMaster.getInstance().getRefereesPoints().containsKey(judge)) {
                            AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue(0.0f);
                            AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue2(0.0f);
                        } else {
                            ScoringObject so = new ScoringObject();
                            so.setReferee(judge);
                            so.setScoreValue(0.0f);
                            so.setScoreValue2(0.0f);
                            so.setScoreName("resultinput_manual");
                            AnzeigeMaster.getInstance().getRefereesPoints().put(judge, so);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.i = new JLabel();
        psouth.add(this.i);
        psouth.add(this.b);
        psouth.add(this.c);
        psouth.add(this.d);
        this.add((Component)psouth, "South");
    }

    public void initTable() {
        if (this.h != null) {
            this.h.clear();
        } else {
            this.h = new Vector();
        }
        this.g = new Vector();
        this.g.add("Referee/Judge");
        this.g.add("Vote " + MainConstants.AKA_LABEL_TEXT);
        this.g.add("Vote " + MainConstants.AO_LABEL_TEXT);
        this.f = new DefaultTableModel(this.h, this.g){
            Class[] a;
            boolean[] b;
            {
                this.a = new Class[]{String.class, String.class, String.class};
                this.b = new boolean[3];
            }

            public Class getColumnClass(int columnIndex) {
                return this.a[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.b[columnIndex];
            }
        };
        this.e = new JXTable((TableModel)this.f);
        this.e.setAutoResizeMode(4);
        this.e.getTableHeader().setReorderingAllowed(false);
        this.e.setSelectionMode(0);
        this.e.setRolloverEnabled(true);
        this.e.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, Color.GRAY, Color.WHITE));
        this.e.setSortable(false);
        this.e.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    Point p = evt.getPoint();
                    int rowNumber = RefereeVoteWindow.this.e.rowAtPoint(p);
                    int colnumber = RefereeVoteWindow.this.e.columnAtPoint(p);
                    try {
                        int judge = Integer.parseInt((String)RefereeVoteWindow.this.e.getValueAt(rowNumber, 0));
                        if (judge > 0) {
                            String score;
                            if (colnumber == 1) {
                                score = JOptionPane.showInputDialog("Judge " + judge + " score for " + MainConstants.AKA_LABEL_TEXT, RefereeVoteWindow.this.e.getValueAt(rowNumber, colnumber));
                                if (!score.equals("0") && !score.equals("1")) {
                                    score = "0";
                                }
                                AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue(Float.parseFloat(score));
                            }
                            if (colnumber == 2) {
                                score = JOptionPane.showInputDialog("Judge " + judge + " score for " + MainConstants.AO_LABEL_TEXT, RefereeVoteWindow.this.e.getValueAt(rowNumber, colnumber));
                                if (!score.equals("0") && !score.equals("1")) {
                                    score = "0";
                                }
                                AnzeigeMaster.getInstance().getRefereesPoints().get(judge).setScoreValue2(Float.parseFloat(score));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.e.setDefaultRenderer(String.class, (TableCellRenderer)new RefereeWindowRenderer());
    }

    public void setColumnWidth() {
    }

    public void updateTableData() {
        try {
            new SwingWorker<String, Void>(){

                protected String a() {
                    if (RefereeVoteWindow.this.h != null) {
                        RefereeVoteWindow.this.h.clear();
                    } else {
                        RefereeVoteWindow.this.h = new Vector();
                    }
                    for (int key : AnzeigeMaster.getInstance().getRefereesPoints().keySet()) {
                        Vector<Object> subvector = new Vector<Object>();
                        subvector.add("" + key);
                        int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                        int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                        subvector.add(score1);
                        subvector.add(score2);
                        RefereeVoteWindow.this.h.add(subvector);
                    }
                    return "";
                }

                @Override
                protected void done() {
                    RefereeVoteWindow.this.e.clearSelection();
                    RefereeVoteWindow.this.f.setDataVector(RefereeVoteWindow.this.h, RefereeVoteWindow.this.g);
                    RefereeVoteWindow.this.setColumnWidth();
                    RefereeVoteWindow.this.e.repaint();
                }

                @Override
                protected /* synthetic */ Object doInBackground() throws Exception {
                    return this.a();
                }
            }.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void savePoints() {
        if (AnzeigeMaster.getInstance().getRefereesPoints().size() > 0) {
            Object votes = "";
            int votes_red = 0;
            int votes_blue = 0;
            int advantage = 0;
            Iterator<Integer> it = AnzeigeMaster.getInstance().getRefereesPoints().keySet().iterator();
            int counter = 0;
            while (it.hasNext()) {
                Integer key = it.next();
                if (key > 3 && !AnzeigePropertiesHelper.getPpwakolc5referees().equals("true")) break;
                ScoringObject obj = AnzeigeMaster.getInstance().getRefereesPoints().get(key);
                int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                if (counter == 0) {
                    votes = (String)votes + ";";
                }
                if (score1 > 0) {
                    votes = (String)votes + "1";
                    ++votes_red;
                } else {
                    votes = (String)votes + "2";
                    ++votes_blue;
                }
                ++counter;
            }
            if (votes_red > votes_blue) {
                advantage = 1;
            }
            if (votes_red < votes_blue) {
                advantage = 2;
            }
            System.out.println("Judges Tie Votes: " + (String)votes);
            AnzeigeMaster.getInstance().getAcp().getLogcomp().appendCustomText("Judges Tie Votes: " + (String)votes);
            AnzeigeMaster.getInstance().setDecisionadvantage(advantage);
            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(268, "");
            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            this.close();
        }
    }

    public void reset() {
        AnzeigeMaster.getInstance().getRefereesPoints().clear();
        AnzeigeMaster.getInstance().setDecisionadvantage(0);
        this.updateTableData();
        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(268, "");
        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
    }

    public void checkPoints() {
        this.a = false;
        if (this.j == null) {
            this.j = new Thread("SET Point Scoring Checker"){

                @Override
                public void run() {
                    RefereeVoteWindow.this.i.setIcon(new ImageIcon("images/ajax_loading.gif"));
                    while (!RefereeVoteWindow.this.a) {
                        RefereeVoteWindow.this.updateTableData();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RefereeVoteWindow.this.i.setIcon(null);
                }
            };
            this.j.start();
        }
    }

    public void stopCheckPoints() {
        this.a = true;
    }

    public void close() {
        this.stopCheckPoints();
        AnzeigeMaster.getInstance().setRefereeVoteWindowLocation(this.getLocation());
        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(268, "");
        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setName(String name) {
        this.k.setText(name);
    }
}

