/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.anzeige.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;

public class DateUtils {
    public static String getLogDateFormated() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getDateFormated() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static Date convertFromString(String datestring, String dateformat) {
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            Date date = df.parse(datestring);
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String getDateFormatedShort() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getDateFormatedClock() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getDateFormatedShortLicense(Date aktdate) {
        String strdate = "";
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static boolean isValidAppRequestByDateOfRunningClock(String datestr) {
        System.out.println("Clock is not running -> check if request was during running clock..." + datestr);
        boolean isok = false;
        ArrayList<String> clockstart = AnzeigeMaster.getInstance().getAnzeige().getClock().getClockstart();
        ArrayList<String> clockend = AnzeigeMaster.getInstance().getAnzeige().getClock().getClockend();
        if (clockstart.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                Date daterequest = sdf.parse(datestr);
                int i = 0;
                while (i < clockstart.size()) {
                    System.out.println("Start: " + clockstart.get(i));
                    System.out.println("End: " + clockend.get(i));
                    Date datestart = sdf.parse(clockstart.get(i));
                    Date dateend = sdf.parse(clockend.get(i));
                    if (daterequest.compareTo(datestart) == 0) {
                        isok = true;
                        break;
                    }
                    if (daterequest.compareTo(dateend) == 0) {
                        isok = true;
                        break;
                    }
                    if (daterequest.compareTo(datestart) > 0 && daterequest.compareTo(dateend) < 0) {
                        isok = true;
                        break;
                    }
                    ++i;
                }
                if (isok) {
                    System.out.println("->Request is VALID!");
                } else {
                    System.out.println("->Request is INVALID!");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return isok;
    }

    public static String getFormatedDateStringShort(long millis) {
        long min = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(millis) % 60L;
        String toRet = String.format("%01d:%02d", min, sec);
        return toRet;
    }
}

