/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.anzeige.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.sportdata.setppwakolc.anzeige.beans.ScoringObject;
import org.sportdata.setppwakolc.anzeige.components.MatchScoreOverview;
import org.sportdata.setppwakolc.anzeige.properties.helper.AnzeigePropertiesHelper;

public class RefereeWindowRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -3613910485340916472L;

    public RefereeWindowRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            if (value != null) {
                this.setText(value.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Border b2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.setBorder(b2);
        this.setFont(new Font("Dialog", 1, 16));
        this.setForeground(table.getForeground());
        this.setHorizontalAlignment(0);
        this.setBackground(table.getBackground());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        }
        if (hasFocus) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        }
        if (column == 3 && value != null && !value.toString().trim().equals("")) {
            if (AnzeigePropertiesHelper.getPpwakolcenablemuaythaimode().equals("true")) {
                this.setText(MatchScoreOverview.createWarningsHtml(value.toString(), ""));
            }
            if (value.toString().indexOf(ScoringObject.SCORESTATUS_OFFICIAL) > -1) {
                this.setBackground(Color.GREEN);
                this.setForeground(Color.BLACK);
            }
        }
        return this;
    }
}

