/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VComponent;
import jfxtras.icalendarfx.properties.component.descriptive.Attachment;
import jfxtras.icalendarfx.properties.component.descriptive.Summary;

public interface VDescribable<T>
extends VComponent {
    public List<Attachment<?>> getAttachments();

    public void setAttachments(List<Attachment<?>> var1);

    default public T withAttachments(List<Attachment<?>> attachments) {
        if (this.getAttachments() == null) {
            this.setAttachments(new ArrayList());
        }
        this.getAttachments().addAll(attachments);
        if (attachments != null) {
            attachments.forEach(c -> this.orderChild((VChild)c));
        }
        return (T)this;
    }

    default public T withAttachments(String ... attachments) {
        List<Attachment<?>> list = Arrays.stream(attachments).map(c -> Attachment.parse(c)).collect(Collectors.toList());
        return this.withAttachments(list);
    }

    default public T withAttachments(Attachment<?> ... attachments) {
        return this.withAttachments(Arrays.asList(attachments));
    }

    public Summary getSummary();

    default public void setSummary(String summary) {
        this.setSummary(Summary.parse(summary));
    }

    public void setSummary(Summary var1);

    default public T withSummary(Summary summary) {
        this.setSummary(summary);
        return (T)this;
    }

    default public T withSummary(String summary) {
        this.setSummary(summary);
        return (T)this;
    }
}

