/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.HashMap;
import java.util.Map;
import jfxtras.icalendarfx.parameters.VParameterBase;
import jfxtras.icalendarfx.utilities.StringConverter;

public class Encoding
extends VParameterBase<Encoding, EncodingType> {
    private static final StringConverter<EncodingType> CONVERTER = new StringConverter<EncodingType>(){

        @Override
        public String toString(EncodingType object) {
            return object.toString();
        }

        @Override
        public EncodingType fromString(String string) {
            return EncodingType.enumFromName(string.toUpperCase());
        }
    };

    public Encoding() {
        super(EncodingType.EIGHT_BIT, CONVERTER);
    }

    public Encoding(EncodingType value) {
        super(value, CONVERTER);
    }

    public Encoding(Encoding source) {
        super(source, CONVERTER);
    }

    public static Encoding parse(String content) {
        return Encoding.parse(new Encoding(), content);
    }

    public static enum EncodingType {
        EIGHT_BIT("8BIT"),
        BASE64("BASE64");

        private static Map<String, EncodingType> enumFromNameMap;
        private String name;

        private static Map<String, EncodingType> makeEnumFromNameMap() {
            HashMap<String, EncodingType> map = new HashMap<String, EncodingType>();
            EncodingType[] values = EncodingType.values();
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i].toString(), values[i]);
            }
            return map;
        }

        public static EncodingType enumFromName(String propertyName) {
            return enumFromNameMap.get(propertyName.toUpperCase());
        }

        public String toString() {
            return this.name;
        }

        private EncodingType(String name) {
            this.name = name;
        }

        static {
            enumFromNameMap = EncodingType.makeEnumFromNameMap();
        }
    }
}

