/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jfxtras.icalendarfx.parameters.ParameterEnumBasedWithUnknown;
import jfxtras.icalendarfx.utilities.StringConverter;

public class FreeBusyType
extends ParameterEnumBasedWithUnknown<FreeBusyType, FreeBusyTypeEnum> {
    private static final StringConverter<FreeBusyTypeEnum> CONVERTER = new StringConverter<FreeBusyTypeEnum>(){

        @Override
        public String toString(FreeBusyTypeEnum object) {
            return object.toString();
        }

        @Override
        public FreeBusyTypeEnum fromString(String string) {
            return FreeBusyTypeEnum.enumFromName(string.toUpperCase());
        }
    };

    public FreeBusyType() {
        super(FreeBusyTypeEnum.BUSY, CONVERTER);
    }

    public FreeBusyType(FreeBusyTypeEnum value) {
        super(value, CONVERTER);
    }

    public FreeBusyType(FreeBusyType source) {
        super(source, CONVERTER);
    }

    public static FreeBusyType parse(String content) {
        return FreeBusyType.parse(new FreeBusyType(), content);
    }

    public static enum FreeBusyTypeEnum {
        FREE(Arrays.asList("FREE")),
        BUSY(Arrays.asList("BUSY")),
        BUSY_UNAVAILABLE(Arrays.asList("BUSY-UNAVAILABLE", "BUSY_UNAVAILABLE")),
        BUSY_TENTATIVE(Arrays.asList("BUSY-TENTATIVE", "BUSY_TENTATIVE")),
        UNKNOWN(Arrays.asList("UNKNOWN"));

        private static Map<String, FreeBusyTypeEnum> enumFromNameMap;
        private List<String> names;

        private static Map<String, FreeBusyTypeEnum> makeEnumFromNameMap() {
            HashMap<String, FreeBusyTypeEnum> map = new HashMap<String, FreeBusyTypeEnum>();
            Arrays.stream(FreeBusyTypeEnum.values()).forEach(r -> r.names.stream().forEach(n -> map.put((String)n, (FreeBusyTypeEnum)((Object)r))));
            return map;
        }

        public static FreeBusyTypeEnum enumFromName(String propertyName) {
            FreeBusyTypeEnum type = enumFromNameMap.get(propertyName.toUpperCase());
            return type == null ? UNKNOWN : type;
        }

        public String toString() {
            return this.names.get(0);
        }

        private FreeBusyTypeEnum(List<String> names) {
            this.names = names;
        }

        static {
            enumFromNameMap = FreeBusyTypeEnum.makeEnumFromNameMap();
        }
    }
}

