/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jfxtras.icalendarfx.VElementBase;
import jfxtras.icalendarfx.VParent;
import jfxtras.icalendarfx.parameters.VParameter;
import jfxtras.icalendarfx.parameters.VParameterElement;
import jfxtras.icalendarfx.utilities.StringConverter;

public abstract class VParameterBase<U, T>
extends VElementBase
implements VParameter<T> {
    private VParent myParent;
    private T value;
    protected final StringConverter<T> converter;
    protected final VParameterElement elementType = VParameterElement.enumFromClass(this.getClass());

    @Override
    public void setParent(VParent parent) {
        this.myParent = parent;
    }

    @Override
    public VParent getParent() {
        return this.myParent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public void setValue(CharSequence value) {
        this.parseContent(value.toString());
    }

    public U withValue(T value) {
        this.setValue(value);
        return (U)this;
    }

    public U withValue(CharSequence value) {
        this.setValue(value);
        return (U)this;
    }

    String valueAsString() {
        if (this.getValue() == null) {
            return "";
        }
        return this.getConverter().toString(this.getValue());
    }

    @Override
    protected List<VElementBase.Message> parseContent(String content) {
        String valueString = VParameterBase.extractValue(content);
        T value = this.getConverter().fromString(valueString);
        this.setValue(value);
        return Collections.EMPTY_LIST;
    }

    private StringConverter<T> getConverter() {
        return this.converter;
    }

    @Override
    public String name() {
        return this.elementType.toString();
    }

    public String toString() {
        return this.name() + "=" + this.valueAsString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VParameterBase testObj = (VParameterBase)obj;
        boolean valueEquals = this.getValue().equals(testObj.getValue());
        return valueEquals;
    }

    public int hashCode() {
        int hash = super.hashCode();
        int prime = 31;
        hash = 31 * hash + this.getValue().hashCode();
        return hash;
    }

    VParameterBase(StringConverter<T> stringConverter) {
        this.converter = this.elementType.getConverter();
    }

    VParameterBase(T value, StringConverter<T> stringConverter) {
        this(stringConverter);
        this.setValue(value);
    }

    VParameterBase(VParameterBase<U, T> source, StringConverter<T> stringConverter) {
        this(stringConverter);
        this.setValue(source.getValue());
        this.setParent(source.getParent());
    }

    @Override
    public List<String> errors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getValue() == null) {
            errors.add(this.name() + " value is null.  The parameter MUST have a value.");
        }
        return errors;
    }

    static String extractValue(String content) {
        String valueString;
        int equalsIndex = content.indexOf(61);
        if (equalsIndex > 0) {
            String name = content.substring(0, equalsIndex);
            boolean hasName1 = VParameterElement.enumFromName(name.toUpperCase()) != null;
            valueString = hasName1 ? content.substring(equalsIndex + 1) : content;
        } else {
            valueString = content;
        }
        return valueString;
    }
}

