/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.icalendarfx.utilities;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import jfxtras.icalendarfx.utilities.StringConverter;

public class StringConverters {
    public static StringConverter<String> defaultStringConverterWithQuotes() {
        return new StringConverter<String>(){

            @Override
            public String toString(String object) {
                return StringConverters.addDoubleQuotesIfNecessary(object);
            }

            @Override
            public String fromString(String string) {
                return StringConverters.removeDoubleQuote(string);
            }
        };
    }

    public static StringConverter<URI> uriConverterNoQuotes() {
        return new StringConverter<URI>(){

            @Override
            public String toString(URI object) {
                return object.toString();
            }

            @Override
            public URI fromString(String string) {
                try {
                    return new URI(string);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public static StringConverter<URI> uriConverterWithQuotes() {
        return new StringConverter<URI>(){

            @Override
            public String toString(URI object) {
                return StringConverters.addDoubleQuotesIfNecessary(object.toString());
            }

            @Override
            public URI fromString(String string) {
                try {
                    return new URI(StringConverters.removeDoubleQuote(string));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public static StringConverter<List<URI>> uriListConverter() {
        return new StringConverter<List<URI>>(){

            @Override
            public String toString(List<URI> object) {
                return object.stream().map(u -> StringConverters.addDoubleQuotesIfNecessary(u.toString())).collect(Collectors.joining(","));
            }

            @Override
            public List<URI> fromString(String string) {
                ArrayList<URI> uriList = new ArrayList<URI>();
                Iterator i = Arrays.stream(string.split(",")).iterator();
                while (i.hasNext()) {
                    String item = (String)i.next();
                    URI uri = null;
                    try {
                        uri = new URI(StringConverters.removeDoubleQuote(item));
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    uriList.add(uri);
                }
                return uriList;
            }
        };
    }

    public static StringConverter<Boolean> booleanConverter() {
        return new StringConverter<Boolean>(){

            @Override
            public String toString(Boolean object) {
                return object.toString().toUpperCase();
            }

            @Override
            public Boolean fromString(String string) {
                return Boolean.parseBoolean(string);
            }
        };
    }

    public static String removeDoubleQuote(String input) {
        int quote = 34;
        StringBuilder builder = new StringBuilder(input);
        if (builder.charAt(0) == '\"') {
            builder.deleteCharAt(0);
        }
        if (builder.charAt(builder.length() - 1) == '\"') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    static String addDoubleQuotesIfNecessary(String text) {
        boolean hasDQuote = text.contains("\"");
        boolean hasColon = text.contains(":");
        boolean hasSemiColon = text.contains(";");
        if (hasDQuote || hasColon || hasSemiColon) {
            return "\"" + text + "\"";
        }
        return text;
    }
}

