/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.gauge.linear.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.converter.PaintConverter;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.util.Duration;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.internal.scene.control.gauge.linear.skin.AbstractLinearGaugeSkin;
import jfxtras.scene.control.gauge.linear.BasicRoundDailGauge;
import jfxtras.scene.control.gauge.linear.elements.Label;
import jfxtras.scene.control.gauge.linear.elements.Marker;
import jfxtras.scene.control.gauge.linear.elements.Segment;

public class BasicRoundDailGaugeSkin
extends AbstractLinearGaugeSkin<BasicRoundDailGaugeSkin, BasicRoundDailGauge> {
    private static final double RING_OUTER_RADIUS_FACTOR = 0.99;
    private static final double RING_INNER_RADIUS_FACTOR = 0.96;
    private static final double RING_WIDTH_FACTOR = 0.04;
    private static final double BACKPLATE_RADIUS_FACTOR = 0.96;
    private static final double TICK_OUTER_RADIUS_FACTOR = 0.93;
    private static final double TICK_INNER_RADIUS_FACTOR = 0.85;
    private static final double TICK_MINOR_RADIUS_FACTOR = 0.82;
    private static final double TICK_MAJOR_RADIUS_FACTOR = 0.8;
    private static final double LABEL_RADIUS_FACTOR = 0.6;
    private static final double SEGMENT_INNER_RADIUS_FACTOR = 0.82;
    private static final double MARKER_RADIUS_FACTOR = 0.76;
    private static final double INDICATOR_RADIUS_FACTOR = 0.3;
    private static final double FULL_ARC_IN_DEGREES = 270.0;
    private ObjectProperty<Paint> tickColorProperty = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)((Paint)StyleableProperties.access$000().getInitialValue(null)));
    private final SimpleDoubleProperty centerX = new SimpleDoubleProperty();
    private final SimpleDoubleProperty centerY = new SimpleDoubleProperty();
    private final SimpleDoubleProperty radius = new SimpleDoubleProperty();
    private final StackPane stackPane = new StackPane();
    private final SegmentPane segmentPane = new SegmentPane();
    private final BackPlatePane backPlatePane = new BackPlatePane();
    private final MarkerPane markerPane = new MarkerPane();
    private final IndicatorPane indicatorPane = new IndicatorPane();
    private final NeedlePane needlePane = new NeedlePane();
    private final ValuePane valuePane = new ValuePane();
    private final GlassPlatePane glassPlatePane = new GlassPlatePane();

    public BasicRoundDailGaugeSkin(BasicRoundDailGauge control) {
        super(control);
        this.constructNodes();
    }

    public final ObjectProperty<Paint> tickColorProperty() {
        return this.tickColorProperty;
    }

    public final void setTickColor(Paint value) {
        this.tickColorProperty().set((Object)value);
    }

    public final Paint getTickColor() {
        return (Paint)this.tickColorProperty.get();
    }

    public final BasicRoundDailGaugeSkin withTickColor(Paint value) {
        this.setTickColor(value);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        List<CssMetaData<Styleable, ?>> classCssMetaData = AbstractLinearGaugeSkin.getClassCssMetaData();
        classCssMetaData = new ArrayList(classCssMetaData);
        classCssMetaData.addAll(StyleableProperties.STYLEABLES);
        return Collections.unmodifiableList(classCssMetaData);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return BasicRoundDailGaugeSkin.getClassCssMetaData();
    }

    private void constructNodes() {
        ((BasicRoundDailGauge)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.centerX.bind((ObservableValue)this.stackPane.widthProperty().multiply(0.5));
        this.centerY.bind((ObservableValue)this.stackPane.heightProperty().multiply(0.5));
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.segmentPane, this.backPlatePane, this.markerPane, this.indicatorPane, this.valuePane, this.needlePane, this.glassPlatePane});
        this.getChildren().add((Object)this.stackPane);
        this.stackPane.setPrefSize(200.0, 200.0);
    }

    @Override
    protected boolean validateValueAndHandleInvalid() {
        String validationMessage = this.validateValue();
        if (validationMessage != null) {
            new Throwable(validationMessage).printStackTrace();
            if (this.needlePane != null && this.valuePane != null) {
                this.valuePane.valueText.setText("");
                this.needlePane.needleRotate.setAngle(0.0);
            }
            return false;
        }
        return true;
    }

    private Point2D calculatePointOnCircle(double radius, double angleInDegrees) {
        double angleInRadians = Math.toRadians(angleInDegrees + 135.0);
        double x = this.centerX.get() + radius * Math.cos(angleInRadians);
        double y = this.centerY.get() + radius * Math.sin(angleInRadians);
        return new Point2D(x, y);
    }

    private double calculateRadius() {
        this.radius.set(Math.min(this.centerX.get(), this.centerY.get()));
        return this.radius.get();
    }

    private class GlassPlatePane
    extends Pane {
        private final Circle outerringCircle = new Circle();
        private final Circle innerringCircle = new Circle();
        private final Circle clipCircle = new Circle();

        private GlassPlatePane() {
            this.getStyleClass().add((Object)"GlassPlatePane");
            this.outerringCircle.getStyleClass().addAll((Object[])new String[]{"outerring"});
            this.outerringCircle.centerXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.outerringCircle.centerYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.innerringCircle.getStyleClass().addAll((Object[])new String[]{"innerring"});
            this.innerringCircle.centerXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.innerringCircle.centerYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.getChildren().addAll((Object[])new Node[]{this.outerringCircle, this.innerringCircle});
            this.clipCircle.centerXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.clipCircle.centerYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.clipCircle.setRadius(100.0);
            this.setClip((Node)this.clipCircle);
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            this.outerringCircle.setRadius(radius * 0.99);
            this.outerringCircle.setStyle("-fx-stroke-width: " + radius * 0.04 + ";");
            this.innerringCircle.setRadius(radius * 0.96);
            this.innerringCircle.setStyle("-fx-stroke-width: " + radius * 0.04 + ";");
            if (this.outerringCircle.getRadius() > 1.0) {
                this.clipCircle.setRadius(this.getWidth() / 2.0);
            }
        }
    }

    private class NeedlePane
    extends Pane {
        private final Region needleRegion = new Region();
        private final Rotate needleRotate = new Rotate();
        private final Scale needleScale = new Scale();
        private final Region knobRegion = new Region();
        private final Timeline timeline = new Timeline();

        private NeedlePane() {
            this.getStyleClass().add((Object)"NeedlePane");
            this.needleRegion.setPickOnBounds(false);
            this.needleRegion.getStyleClass().setAll((Object[])new String[]{"needle", "needle-standard"});
            this.needleRegion.setPrefSize(6.0, 75.0);
            this.needleRegion.layoutXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX.add((ObservableNumberValue)this.needleRegion.widthProperty().multiply(-0.5)));
            this.needleRegion.layoutYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.needleRotate.pivotXProperty().bind((ObservableValue)this.needleRegion.widthProperty().multiply(0.5));
            this.needleRegion.getTransforms().add((Object)this.needleRotate);
            this.needleRegion.getTransforms().add((Object)this.needleScale);
            this.needleScale.yProperty().bind((ObservableValue)this.needleScale.xProperty());
            this.knobRegion.setPickOnBounds(false);
            this.knobRegion.getStyleClass().setAll((Object[])new String[]{"knob"});
            this.knobRegion.layoutXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.knobRegion.layoutYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.knobRegion.getTransforms().add((Object)new Scale(1.0, 1.0));
            this.getChildren().addAll((Object[])new Node[]{this.needleRegion, this.knobRegion});
            ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).valueProperty().addListener(observable -> {
                if (!BasicRoundDailGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).minValueProperty().addListener(observable -> {
                if (!BasicRoundDailGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).maxValueProperty().addListener(observable -> {
                if (!BasicRoundDailGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            this.rotateNeedle(false);
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            this.needleScale.setX(radius / 100.0);
            Scale scale = (Scale)this.knobRegion.getTransforms().get(0);
            scale.setX(radius / 200.0 * 0.3);
            scale.setY(scale.getX());
        }

        private void rotateNeedle(boolean allowAnimation) {
            if (!BasicRoundDailGaugeSkin.this.validateValueAndHandleInvalid()) {
                return;
            }
            double controlMinValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double value = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getValue();
            double angle = (value - controlMinValue) / controlValueRange * 270.0;
            angle += 45.0;
            if (!allowAnimation || AbstractLinearGaugeSkin.Animated.NO.equals((Object)BasicRoundDailGaugeSkin.this.getAnimated())) {
                this.needleRotate.setAngle(angle);
            } else {
                this.timeline.stop();
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)angle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{KEY_VALUE});
                this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                this.timeline.play();
            }
            BasicRoundDailGaugeSkin.this.activateSegments(BasicRoundDailGaugeSkin.this.segmentPane.segmentToArc);
        }
    }

    private class ValuePane
    extends AbstractLinearGaugeSkin.AbstractValuePane {
        private ValuePane() {
            this.valueTextPane.layoutXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX.subtract((ObservableNumberValue)this.valueTextPane.widthProperty().multiply(0.5).multiply((ObservableNumberValue)this.valueScale.xProperty())));
            this.valueTextPane.layoutYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY.add((ObservableNumberValue)BasicRoundDailGaugeSkin.this.radius.multiply(0.65)).subtract((ObservableNumberValue)this.valueTextPane.heightProperty().multiply(0.5).multiply((ObservableNumberValue)this.valueScale.yProperty())));
        }

        @Override
        protected void scaleValueText() {
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius() * 0.7;
            double minScale = this.calculateValueTextScaleFactor(radius, ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMinValue());
            double maxScale = this.calculateValueTextScaleFactor(radius, ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMaxValue());
            double scale = Math.min(minScale, maxScale);
            this.valueScale.setX(scale);
            this.valueScale.setY(scale);
        }

        protected double calculateValueTextScaleFactor(double radius, double value) {
            this.hiddenText.setText(BasicRoundDailGaugeSkin.this.valueFormat(value));
            double width = this.hiddenText.getBoundsInParent().getWidth();
            double height = this.hiddenText.getBoundsInParent().getHeight();
            double scaleFactor = radius / Math.sqrt(width * width + height * height);
            return scaleFactor;
        }
    }

    protected class IndicatorPane
    extends AbstractLinearGaugeSkin.AbstractIndicatorPane {
        protected IndicatorPane() {
        }

        @Override
        protected double calculateScaleFactor() {
            return 0.3 * BasicRoundDailGaugeSkin.this.calculateRadius() / 150.0;
        }

        @Override
        protected Point2D calculateLocation(int idx) {
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            double indicatorRadius = radius * 0.3;
            if (idx < 6) {
                return BasicRoundDailGaugeSkin.this.calculatePointOnCircle(indicatorRadius, (double)idx * 270.0 / 5.0);
            }
            System.err.println("The " + ((Object)((Object)((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()))).getClass().getSimpleName() + " gauge supports indicators [0,4], not " + idx);
            return null;
        }
    }

    private class MarkerPane
    extends AbstractLinearGaugeSkin.AbstractMarkerPane {
        private MarkerPane() {
        }

        @Override
        protected void positionAndScaleMarker(Marker marker, Rotate rotate, Scale scale) {
            double controlMinValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            double markerRadius = radius * 0.76;
            double markerValue = marker.getValue();
            double angle = (markerValue - controlMinValue) / controlValueRange * 270.0;
            Region region = (Region)this.markerToRegion.get(marker);
            Point2D markerPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(markerRadius, angle);
            region.setLayoutX(markerPoint2D.getX());
            region.setLayoutY(markerPoint2D.getY());
            rotate.setAngle(angle + 45.0);
            scale.setX(2.0 * radius / 300.0);
            scale.setY(scale.getX());
        }
    }

    private class BackPlatePane
    extends Pane {
        private final Circle backpaneCircle = new Circle();
        private final Canvas ticksCanvas = new Canvas();
        private final Text tickText = new Text();

        private BackPlatePane() {
            this.getStyleClass().add((Object)"BackPlatePane");
            this.backpaneCircle.getStyleClass().addAll((Object[])new String[]{"backplate"});
            this.backpaneCircle.setStyle("-fx-fill: -fxx-backplate-color;");
            this.backpaneCircle.centerXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.backpaneCircle.centerYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            this.ticksCanvas.setCache(true);
            this.ticksCanvas.setCacheHint(CacheHint.QUALITY);
            this.ticksCanvas.getStyleClass().addAll((Object[])new String[]{"tick"});
            this.ticksCanvas.layoutXProperty().set(0.0);
            this.ticksCanvas.layoutYProperty().set(0.0);
            this.ticksCanvas.widthProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.stackPane.widthProperty());
            this.ticksCanvas.heightProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.stackPane.heightProperty());
            this.backpaneCircle.fillProperty().addListener(observable -> this.layoutChildren());
            this.getChildren().addAll((Object[])new Node[]{this.backpaneCircle, this.ticksCanvas});
            ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).segments().addListener(change -> this.requestLayout());
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            double plateRadius = radius * (((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).segments().size() == 0 ? 0.99 : 0.82);
            this.backpaneCircle.setRadius(plateRadius);
            double size = radius * 2.0;
            GraphicsContext graphicsContext = this.ticksCanvas.getGraphicsContext2D();
            graphicsContext.clearRect(0.0, 0.0, this.ticksCanvas.getWidth(), this.ticksCanvas.getHeight());
            graphicsContext.setStroke(BasicRoundDailGaugeSkin.this.getTickColor());
            double tickInnerRadius = radius * 0.85;
            double tickOuterRadius = radius * 0.93;
            double tickMajorRadius = radius * 0.8;
            double tickMinorRadius = radius * 0.82;
            for (int i = 0; i <= 100; ++i) {
                double angle = 2.7 * (double)i;
                Point2D outerPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(tickOuterRadius, angle);
                Point2D innerPoint2D = null;
                if (i % 10 == 0) {
                    innerPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(tickMajorRadius, angle);
                    graphicsContext.setLineWidth(size * 0.0055);
                } else if (i % 5 == 0) {
                    innerPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(tickMinorRadius, angle);
                    graphicsContext.setLineWidth(size * 0.0035);
                } else {
                    innerPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(tickInnerRadius, angle);
                    graphicsContext.setLineWidth(size * 0.00225);
                }
                graphicsContext.strokeLine(innerPoint2D.getX(), innerPoint2D.getY(), outerPoint2D.getX(), outerPoint2D.getY());
            }
            for (Label lLabel : ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).labels()) {
                double angle = 2.7 * lLabel.getValue();
                this.tickText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.045 * size)));
                Point2D textPoint2D = BasicRoundDailGaugeSkin.this.calculatePointOnCircle(radius * 0.6, angle);
                graphicsContext.save();
                graphicsContext.translate(textPoint2D.getX(), textPoint2D.getY());
                graphicsContext.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.045 * size)));
                graphicsContext.setTextAlign(TextAlignment.CENTER);
                graphicsContext.setTextBaseline(VPos.CENTER);
                graphicsContext.setFill(BasicRoundDailGaugeSkin.this.getTickColor());
                graphicsContext.fillText(lLabel.getText(), 0.0, 0.0);
                graphicsContext.restore();
            }
        }
    }

    private class SegmentPane
    extends Pane {
        private final Map<Segment, Arc> segmentToArc = new HashMap<Segment, Arc>();
        private final Circle backpaneCircle = new Circle();

        private SegmentPane() {
            this.getStyleClass().add((Object)"SegmentPane");
            this.backpaneCircle.getStyleClass().addAll((Object[])new String[]{"backplate"});
            this.backpaneCircle.centerXProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerX);
            this.backpaneCircle.centerYProperty().bind((ObservableValue)BasicRoundDailGaugeSkin.this.centerY);
            ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).segments().addListener(change -> this.createAndAddSegments());
            this.createAndAddSegments();
        }

        private void createAndAddSegments() {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.backpaneCircle});
            this.segmentToArc.clear();
            int segmentCnt = 0;
            for (Segment segment : ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).segments()) {
                Arc arc = new Arc();
                this.getChildren().add((Object)arc);
                this.segmentToArc.put(segment, arc);
                arc.getStyleClass().addAll((Object[])new String[]{"segment", "segment" + segmentCnt});
                if (segment.getId() != null) {
                    arc.setId(segment.getId());
                }
                ++segmentCnt;
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double radius = BasicRoundDailGaugeSkin.this.calculateRadius();
            double plateRadius = radius * 0.96;
            this.backpaneCircle.setRadius(plateRadius);
            double controlMinValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double segmentRadius = BasicRoundDailGaugeSkin.this.calculateRadius() * 0.96;
            for (Segment segment : ((BasicRoundDailGauge)BasicRoundDailGaugeSkin.this.getSkinnable()).segments()) {
                String message = BasicRoundDailGaugeSkin.this.validateSegment(segment);
                if (message != null) {
                    new Throwable(message).printStackTrace();
                    continue;
                }
                double segmentMinValue = segment.getMinValue();
                double segmentMaxValue = segment.getMaxValue();
                double startAngle = (segmentMinValue - controlMinValue) / controlValueRange * 270.0;
                double endAngle = (segmentMaxValue - controlMinValue) / controlValueRange * 270.0;
                Arc arc = this.segmentToArc.get(segment);
                if (arc == null) continue;
                arc.setCenterX(BasicRoundDailGaugeSkin.this.centerX.get());
                arc.setCenterY(BasicRoundDailGaugeSkin.this.centerY.get());
                arc.setRadiusX(segmentRadius);
                arc.setRadiusY(segmentRadius);
                arc.setStartAngle(-1.0 * (startAngle + 135.0));
                arc.setLength(-1.0 * (endAngle - startAngle));
                arc.setType(ArcType.ROUND);
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<BasicRoundDailGauge, Paint> TICKCOLOR_CSSMETADATA = new CssMetaDataForSkinProperty<BasicRoundDailGauge, BasicRoundDailGaugeSkin, Paint>("-fxx-tick-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            protected ObjectProperty<Paint> getProperty(BasicRoundDailGaugeSkin s) {
                return s.tickColorProperty;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return TICKCOLOR_CSSMETADATA;
        }

        static {
            ArrayList<CssMetaData<BasicRoundDailGauge, Paint>> styleables = new ArrayList<CssMetaData<BasicRoundDailGauge, Paint>>(SkinBase.getClassCssMetaData());
            styleables.add(TICKCOLOR_CSSMETADATA);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

