/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.gauge.linear.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.internal.scene.control.gauge.linear.skin.AbstractLinearGaugeSkin;
import jfxtras.scene.control.gauge.linear.AbstractLinearGauge;
import jfxtras.scene.control.gauge.linear.SimpleMetroArcGauge;
import jfxtras.scene.control.gauge.linear.elements.CompleteSegment;
import jfxtras.scene.control.gauge.linear.elements.Marker;
import jfxtras.scene.control.gauge.linear.elements.Segment;

public class SimpleMetroArcGaugeSkin
extends AbstractLinearGaugeSkin<SimpleMetroArcGaugeSkin, SimpleMetroArcGauge> {
    private static final double SEGMENT_RADIUS_FACTOR = 0.95;
    private static final double NEEDLE_RADIUS_FACTOR = 0.5;
    private static final double NEEDLE_TIP_RADIUS_FACTOR = 0.87;
    private static final double MARKER_RADIUS_FACTOR = 0.95;
    private static final double INDICATOR_RADIUS_FACTOR = 0.1425;
    private static final double FULL_ARC_IN_DEGREES = 270.0;
    private final SimpleDoubleProperty centerX = new SimpleDoubleProperty();
    private final SimpleDoubleProperty centerY = new SimpleDoubleProperty();
    private final SimpleDoubleProperty radius = new SimpleDoubleProperty();
    private final StackPane stackPane = new StackPane();
    private final SegmentPane segmentPane = new SegmentPane();
    private final MarkerPane markerPane = new MarkerPane();
    private final IndicatorPane indicatorPane = new IndicatorPane();
    private final NeedlePane needlePane = new NeedlePane();
    private final ValuePane valuePane = new ValuePane();

    public SimpleMetroArcGaugeSkin(SimpleMetroArcGauge control) {
        super(control);
        this.constructNodes();
    }

    private void constructNodes() {
        ((SimpleMetroArcGauge)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.centerX.bind((ObservableValue)this.stackPane.widthProperty().multiply(0.5));
        this.centerY.bind((ObservableValue)this.stackPane.heightProperty().multiply(0.55));
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.segmentPane, this.markerPane, this.indicatorPane, this.needlePane, this.valuePane});
        this.getChildren().add((Object)this.stackPane);
    }

    @Override
    protected boolean validateValueAndHandleInvalid() {
        String validationMessage = this.validateValue();
        if (validationMessage != null) {
            new Throwable(validationMessage).printStackTrace();
            if (this.needlePane != null && this.valuePane != null) {
                this.valuePane.valueText.setText("");
                this.needlePane.needleRotate.setAngle(-45.0);
            }
            return false;
        }
        return true;
    }

    private Point2D calculatePointOnCircle(double radius, double angleInDegrees) {
        double angleInRadians = Math.toRadians(angleInDegrees + 135.0);
        double x = this.centerX.get() + radius * Math.cos(angleInRadians);
        double y = this.centerY.get() + radius * Math.sin(angleInRadians);
        return new Point2D(x, y);
    }

    private double calculateRadius() {
        this.radius.set(Math.min(this.centerX.get(), this.centerY.get()));
        return this.radius.get();
    }

    private class ValuePane
    extends AbstractLinearGaugeSkin.AbstractValuePane {
        private ValuePane() {
            this.valueTextPane.layoutXProperty().bind((ObservableValue)SimpleMetroArcGaugeSkin.this.centerX.subtract((ObservableNumberValue)this.valueTextPane.widthProperty().multiply(0.5).multiply((ObservableNumberValue)this.valueScale.xProperty())));
            this.valueTextPane.layoutYProperty().bind((ObservableValue)SimpleMetroArcGaugeSkin.this.centerY.subtract((ObservableNumberValue)this.valueTextPane.heightProperty().multiply(0.5).multiply((ObservableNumberValue)this.valueScale.yProperty())));
        }

        @Override
        protected void scaleValueText() {
            double radius = SimpleMetroArcGaugeSkin.this.calculateRadius();
            double arcRadius = radius * 0.5;
            double minScale = this.calculateValueTextScaleFactor(arcRadius, ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMinValue());
            double maxScale = this.calculateValueTextScaleFactor(arcRadius, ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMaxValue());
            double scale = Math.min(minScale, maxScale);
            this.valueScale.setX(scale);
            this.valueScale.setY(scale);
        }

        protected double calculateValueTextScaleFactor(double radius, double value) {
            this.hiddenText.setText(SimpleMetroArcGaugeSkin.this.valueFormat(value));
            double width = this.hiddenText.getBoundsInParent().getWidth();
            double height = this.hiddenText.getBoundsInParent().getHeight();
            double diameter = radius * 2.0;
            double scaleFactor = diameter / Math.sqrt(width * width + height * height);
            return scaleFactor;
        }
    }

    private class NeedlePane
    extends Pane {
        private final Path needlePath = new Path();
        private final Rotate needleRotate = new Rotate(0.0);
        private double previousWidth = -1.0;
        private double previousHeight = -1.0;
        private final Timeline timeline = new Timeline();

        private NeedlePane() {
            this.getChildren().add((Object)this.needlePath);
            this.needlePath.getStyleClass().add((Object)"needle");
            this.needleRotate.pivotXProperty().bind((ObservableValue)SimpleMetroArcGaugeSkin.this.centerX);
            this.needleRotate.pivotYProperty().bind((ObservableValue)SimpleMetroArcGaugeSkin.this.centerY);
            ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).valueProperty().addListener(observable -> {
                if (!SimpleMetroArcGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).minValueProperty().addListener(observable -> {
                if (!SimpleMetroArcGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).maxValueProperty().addListener(observable -> {
                if (!SimpleMetroArcGaugeSkin.this.validateValueAndHandleInvalid()) {
                    return;
                }
                this.rotateNeedle(true);
            });
            this.rotateNeedle(false);
        }

        protected void layoutChildren() {
            super.layoutChildren();
            if (this.previousWidth != this.getWidth() || this.previousHeight != this.getHeight()) {
                double radius = SimpleMetroArcGaugeSkin.this.calculateRadius();
                double tipRadius = radius * 0.87;
                double arcRadius = radius * 0.5;
                Point2D arcStartPoint2D = SimpleMetroArcGaugeSkin.this.calculatePointOnCircle(arcRadius, -15.0);
                Point2D arcEndPoint2D = SimpleMetroArcGaugeSkin.this.calculatePointOnCircle(arcRadius, 15.0);
                Point2D tipPoint2D = SimpleMetroArcGaugeSkin.this.calculatePointOnCircle(tipRadius, 0.0);
                this.needlePath.getElements().clear();
                this.needlePath.setFillRule(FillRule.EVEN_ODD);
                this.needlePath.getStyleClass().add((Object)"needle");
                this.needlePath.setStrokeLineJoin(StrokeLineJoin.ROUND);
                this.needlePath.getElements().add((Object)new MoveTo(arcStartPoint2D.getX(), arcStartPoint2D.getY()));
                ArcTo arcTo = new ArcTo();
                arcTo.setX(arcEndPoint2D.getX());
                arcTo.setY(arcEndPoint2D.getY());
                arcTo.setRadiusX(arcRadius);
                arcTo.setRadiusY(arcRadius);
                arcTo.setLargeArcFlag(true);
                arcTo.setSweepFlag(false);
                this.needlePath.getElements().add((Object)arcTo);
                this.needlePath.getElements().add((Object)new LineTo(tipPoint2D.getX(), tipPoint2D.getY()));
                this.needlePath.getElements().add((Object)new LineTo(arcStartPoint2D.getX(), arcStartPoint2D.getY()));
                this.needlePath.setStrokeWidth(arcRadius * 0.1);
                this.needlePath.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
                this.previousWidth = this.getWidth();
                this.previousHeight = this.getHeight();
            }
        }

        private void rotateNeedle(boolean allowAnimation) {
            double controlMinValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double value = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getValue();
            double angle = (value - controlMinValue) / controlValueRange * 270.0;
            if (!allowAnimation || AbstractLinearGaugeSkin.Animated.NO.equals((Object)SimpleMetroArcGaugeSkin.this.getAnimated())) {
                this.needleRotate.setAngle(angle);
            } else {
                this.timeline.stop();
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)angle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{KEY_VALUE});
                this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                this.timeline.play();
            }
            SimpleMetroArcGaugeSkin.this.activateSegments(SimpleMetroArcGaugeSkin.this.segmentPane.segmentToArc);
        }
    }

    protected class IndicatorPane
    extends AbstractLinearGaugeSkin.AbstractIndicatorPane {
        protected IndicatorPane() {
        }

        @Override
        protected double calculateScaleFactor() {
            return 0.4 * SimpleMetroArcGaugeSkin.this.calculateRadius() / 150.0;
        }

        @Override
        protected Point2D calculateLocation(int idx) {
            double radius = SimpleMetroArcGaugeSkin.this.calculateRadius();
            double segmentRadius = radius * 0.95;
            double indicatorRadius = radius * 0.1425;
            double indicatorDiameter = 2.0 * indicatorRadius;
            if (idx == 0) {
                return new Point2D(SimpleMetroArcGaugeSkin.this.centerX.get() - indicatorDiameter, SimpleMetroArcGaugeSkin.this.centerY.get() + segmentRadius - indicatorDiameter);
            }
            if (idx == 1) {
                return new Point2D(SimpleMetroArcGaugeSkin.this.centerX.get() + indicatorDiameter, SimpleMetroArcGaugeSkin.this.centerY.get() + segmentRadius - indicatorDiameter);
            }
            System.err.println("The " + ((Object)((Object)((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()))).getClass().getSimpleName() + " gauge supports indicators [0,1], not " + idx);
            return null;
        }
    }

    private class MarkerPane
    extends AbstractLinearGaugeSkin.AbstractMarkerPane {
        private MarkerPane() {
        }

        @Override
        protected void positionAndScaleMarker(Marker marker, Rotate rotate, Scale scale) {
            double controlMinValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double radius = SimpleMetroArcGaugeSkin.this.calculateRadius();
            double markerRadius = radius * 0.95;
            double markerValue = marker.getValue();
            double angle = (markerValue - controlMinValue) / controlValueRange * 270.0;
            Region region = (Region)this.markerToRegion.get(marker);
            Point2D markerPoint2D = SimpleMetroArcGaugeSkin.this.calculatePointOnCircle(markerRadius, angle);
            region.setLayoutX(markerPoint2D.getX());
            region.setLayoutY(markerPoint2D.getY());
            rotate.setAngle(angle - 135.0);
            scale.setX(2.0 * radius / 300.0);
            scale.setY(scale.getX());
        }
    }

    private class SegmentPane
    extends Pane {
        private final List<Segment> segments = new ArrayList<Segment>();
        private final Map<Segment, Arc> segmentToArc = new HashMap<Segment, Arc>();

        private SegmentPane() {
            ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).segments().addListener(change -> this.createAndAddSegments());
            this.createAndAddSegments();
        }

        private void createAndAddSegments() {
            this.getChildren().clear();
            this.segments.clear();
            this.segments.addAll((Collection<Segment>)((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).segments());
            if (this.segments.size() == 0) {
                this.segments.add(new CompleteSegment((AbstractLinearGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()));
            }
            this.segmentToArc.clear();
            int segmentCnt = 0;
            for (Segment segment : this.segments) {
                Arc arc = new Arc();
                this.getChildren().add((Object)arc);
                this.segmentToArc.put(segment, arc);
                arc.getStyleClass().addAll((Object[])new String[]{"segment", "segment" + segmentCnt});
                if (segment.getId() != null) {
                    arc.setId(segment.getId());
                }
                ++segmentCnt;
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double controlMinValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMinValue();
            double controlMaxValue = ((SimpleMetroArcGauge)SimpleMetroArcGaugeSkin.this.getSkinnable()).getMaxValue();
            double controlValueRange = controlMaxValue - controlMinValue;
            double segmentRadius = SimpleMetroArcGaugeSkin.this.calculateRadius() * 0.95;
            for (Segment segment : this.segments) {
                String message = SimpleMetroArcGaugeSkin.this.validateSegment(segment);
                if (message != null) {
                    new Throwable(message).printStackTrace();
                    continue;
                }
                double segmentMinValue = segment.getMinValue();
                double segmentMaxValue = segment.getMaxValue();
                double startAngle = (segmentMinValue - controlMinValue) / controlValueRange * 270.0;
                double endAngle = (segmentMaxValue - controlMinValue) / controlValueRange * 270.0;
                Arc arc = this.segmentToArc.get(segment);
                if (arc == null) continue;
                arc.setCenterX(SimpleMetroArcGaugeSkin.this.centerX.get());
                arc.setCenterY(SimpleMetroArcGaugeSkin.this.centerY.get());
                arc.setRadiusX(segmentRadius);
                arc.setRadiusY(segmentRadius);
                arc.setStartAngle(-1.0 * (startAngle + 135.0));
                arc.setLength(-1.0 * (endAngle - startAngle));
                arc.setType(ArcType.ROUND);
            }
        }
    }
}

