/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.IntegerConverter;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AgendaSkinTimeScale24HourAbstract;
import jfxtras.scene.control.agenda.Agenda;

public class AgendaDaysFromDisplayedSkin
extends AgendaSkinTimeScale24HourAbstract<AgendaDaysFromDisplayedSkin> {
    private Slider daysBeforeSlider;
    private Slider daysAfterSlider;
    private final int daysBackDefault = -1;
    private final int daysForwardDefault = 6;
    private String displayedLocalDatesKey = "";
    private List<LocalDate> displayedLocalDates;
    private ObjectProperty<Integer> daysBeforeFurthestProperty = new SimpleStyleableObjectProperty<Integer>(StyleableProperties.access$000(), (Integer)StyleableProperties.access$000().getInitialValue(null)){};
    private ObjectProperty<Integer> daysAfterFurthestProperty = new SimpleStyleableObjectProperty<Integer>(StyleableProperties.access$100(), (Integer)StyleableProperties.access$100().getInitialValue(null)){};

    public AgendaDaysFromDisplayedSkin(Agenda control) {
        super(control);
        this.construct();
    }

    private void construct() {
        this.daysBeforeSlider = new Slider(-20.0, 0.0, -1.0);
        this.daysBeforeSlider.setId("daysBeforeSlider");
        this.daysBeforeSlider.minProperty().bind(this.daysBeforeFurthestProperty);
        this.daysBeforeSlider.snapToTicksProperty().set(true);
        this.daysBeforeSlider.majorTickUnitProperty().set(1.0);
        this.daysBeforeSlider.minorTickCountProperty().set(0);
        this.daysBeforeSlider.showTickLabelsProperty().set(true);
        this.daysBeforeSlider.prefWidthProperty().bind((ObservableValue)this.borderPane.widthProperty().divide(2.0));
        this.daysBeforeSlider.valueChangingProperty().addListener(observable -> {
            if (!this.daysBeforeSlider.valueChangingProperty().get()) {
                this.reconstruct();
            }
        });
        this.daysAfterSlider = new Slider(0.0, 20.0, 6.0);
        this.daysAfterSlider.setId("daysAfterSlider");
        this.daysAfterSlider.maxProperty().bind(this.daysAfterFurthestProperty);
        this.daysAfterSlider.snapToTicksProperty().set(true);
        this.daysAfterSlider.majorTickUnitProperty().set(1.0);
        this.daysAfterSlider.minorTickCountProperty().set(0);
        this.daysAfterSlider.showTickLabelsProperty().set(true);
        this.daysAfterSlider.prefWidthProperty().bind((ObservableValue)this.borderPane.widthProperty().divide(2.0));
        this.daysAfterSlider.valueChangingProperty().addListener(observable -> {
            if (!this.daysAfterSlider.valueChangingProperty().get()) {
                this.reconstruct();
            }
        });
        this.borderPane.setBottom((Node)new HBox(new Node[]{this.daysBeforeSlider, this.daysAfterSlider}));
    }

    @Override
    protected void reconstruct() {
        super.reconstruct();
        this.borderPane.setBottom((Node)new HBox(new Node[]{this.daysBeforeSlider, this.daysAfterSlider}));
    }

    @Override
    protected List<LocalDate> determineDisplayedLocalDates() {
        LocalDate lStartLocalDate;
        int lEndOffset;
        int lStartOffset = this.daysBeforeSlider == null ? -1 : (int)Math.round(this.daysBeforeSlider.valueProperty().get());
        String lKey = lStartOffset + " / " + (lEndOffset = this.daysAfterSlider == null ? 6 : (int)Math.round(this.daysAfterSlider.valueProperty().get())) + " / " + (lStartLocalDate = ((Agenda)this.getSkinnable()).getDisplayedLocalDateTime().toLocalDate());
        if (!lKey.equals(this.displayedLocalDatesKey)) {
            this.displayedLocalDates = new ArrayList<LocalDate>();
            for (int i = lStartOffset; i < lEndOffset + 1; ++i) {
                this.displayedLocalDates.add(lStartLocalDate.plusDays(i));
            }
            this.displayedLocalDatesKey = lKey;
        }
        return this.displayedLocalDates;
    }

    public final ObjectProperty<Integer> daysBeforeFurthestProperty() {
        return this.daysBeforeFurthestProperty;
    }

    public final void setDaysBeforeFurthest(int value) {
        this.daysBeforeFurthestProperty.set((Object)value);
    }

    public final int getDaysBeforeFurthest() {
        return (Integer)this.daysBeforeFurthestProperty.get();
    }

    public final AgendaDaysFromDisplayedSkin withDaysBeforeFurthest(int value) {
        this.setDaysBeforeFurthest(value);
        return this;
    }

    public final ObjectProperty<Integer> daysAfterFurthestProperty() {
        return this.daysAfterFurthestProperty;
    }

    public final void setDaysAfterFurthest(int value) {
        this.daysAfterFurthestProperty.set((Object)value);
    }

    public final int getDaysAfterFurthest() {
        return (Integer)this.daysAfterFurthestProperty.get();
    }

    public final AgendaDaysFromDisplayedSkin withDaysAfterFurthest(int value) {
        this.setDaysAfterFurthest(value);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AgendaDaysFromDisplayedSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Agenda, Integer> DAYS_BEFORE_FURTHEST_CSSMETADATA = new CssMetaDataForSkinProperty<Agenda, AgendaDaysFromDisplayedSkin, Integer>("-fxx-days-before-furthest", IntegerConverter.getInstance(), Integer.valueOf(-9)){

            @Override
            protected ObjectProperty<Integer> getProperty(AgendaDaysFromDisplayedSkin s) {
                return s.daysBeforeFurthestProperty;
            }
        };
        private static final CssMetaData<Agenda, Integer> DAYS_AFTER_FURTHEST_CSSMETADATA = new CssMetaDataForSkinProperty<Agenda, AgendaDaysFromDisplayedSkin, Integer>("-fxx-days-after-furthest", IntegerConverter.getInstance(), Integer.valueOf(9)){

            @Override
            protected ObjectProperty<Integer> getProperty(AgendaDaysFromDisplayedSkin s) {
                return s.daysAfterFurthestProperty;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return DAYS_BEFORE_FURTHEST_CSSMETADATA;
        }

        static /* synthetic */ CssMetaData access$100() {
            return DAYS_AFTER_FURTHEST_CSSMETADATA;
        }

        static {
            ArrayList classCssMetaData = new ArrayList(AgendaSkinTimeScale24HourAbstract.getClassCssMetaData());
            classCssMetaData.add(DAYS_BEFORE_FURTHEST_CSSMETADATA);
            classCssMetaData.add(DAYS_AFTER_FURTHEST_CSSMETADATA);
            STYLEABLES = Collections.unmodifiableList(classCssMetaData);
        }
    }
}

