/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.util.Duration;
import jfxtras.animation.Timer;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.DoubleConverter;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DayBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DayHeaderPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.internal.scene.control.skin.agenda.base24hour.TimeScale24Hour;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.util.NodeUtil;

public abstract class AgendaSkinTimeScale24HourAbstract<T>
extends SkinBase<Agenda>
implements AgendaSkin {
    protected final Agenda control;
    AllAppointments appointments = null;
    private InvalidationListener localeInvalidationListener = observable -> this.refresh();
    private ChangeListener<? super LocalDateTime> displayedDateTimeChangeListener = (observable, oldSelection, newSelection) -> {
        this.assignDateToDayAndHeaderPanes();
        this.scrollWeekpaneToShowDisplayedTime();
        this.setupAppointments();
    };
    private ListChangeListener<Agenda.Appointment> appointmentsListChangeListener = changes -> this.setupAppointments();
    private ListChangeListener<Agenda.Appointment> appointmentNodeMapCleanUpListChangeListener = changes -> {
        while (changes.next()) {
            if (!changes.wasRemoved()) continue;
            changes.getRemoved().stream().forEach(a -> this.appointmentNodeMap().remove(System.identityHashCode(a)));
        }
    };
    private final Map<Integer, Pane> appointmentNodeMap = new HashMap<Integer, Pane>();
    private ObjectProperty<Double> snapToMinutesProperty = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)((Double)StyleableProperties.access$100().getInitialValue(null)));
    protected BorderPane borderPane = null;
    private WeekHeaderPane weekHeaderPane = null;
    private ScrollPane weekScrollPane = null;
    private WeekBodyPane weekBodyPane = null;
    final Rectangle nowLine = new Rectangle(0.0, 0.0, 0.0, 0.0);
    Runnable nowUpdateRunnable = new Runnable(){
        {
            AgendaSkinTimeScale24HourAbstract.this.nowLine.getStyleClass().add((Object)"Now");
            AgendaSkinTimeScale24HourAbstract.this.nowLine.setHeight(3.0);
        }

        @Override
        public void run() {
            LocalDateTime lNow = LocalDateTime.now();
            LocalDate lToday = lNow.toLocalDate();
            boolean lFound = false;
            for (DayBodyPane lDayPane : ((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).weekBodyPane.dayBodyPanes) {
                if (!((LocalDate)lDayPane.localDateObjectProperty.get()).isEqual(lToday)) {
                    lDayPane.getStyleClass().remove((Object)"today");
                    continue;
                }
                if (!lDayPane.getStyleClass().contains((Object)"today")) {
                    lDayPane.getStyleClass().add((Object)"today");
                }
                lFound = true;
                if (!AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.getChildren().contains((Object)AgendaSkinTimeScale24HourAbstract.this.nowLine)) {
                    AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.getChildren().add((Object)AgendaSkinTimeScale24HourAbstract.this.nowLine);
                    AgendaSkinTimeScale24HourAbstract.this.nowLine.xProperty().bind((ObservableValue)lDayPane.layoutXProperty());
                }
                int lOffsetY = lNow.getHour() * 60 + lNow.getMinute();
                AgendaSkinTimeScale24HourAbstract.this.nowLine.setY(NodeUtil.snapXY(((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayHeightProperty.get() / 1440.0 * (double)lOffsetY));
                if (AgendaSkinTimeScale24HourAbstract.this.nowLine.widthProperty().isBound()) continue;
                AgendaSkinTimeScale24HourAbstract.this.nowLine.widthProperty().bind((ObservableValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayWidthProperty);
            }
            if (!lFound) {
                AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.getChildren().remove((Object)AgendaSkinTimeScale24HourAbstract.this.nowLine);
            }
            for (DayHeaderPane lDayHeaderPane : ((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).weekHeaderPane.dayHeaderPanes) {
                for (Node lNode : lDayHeaderPane.getChildren()) {
                    if (!(lNode instanceof AppointmentAbstractPane)) continue;
                    ((AppointmentAbstractPane)lNode).determineHistoryVisualizer(lNow);
                }
            }
            for (DayBodyPane lDayBodyPane : ((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).weekBodyPane.dayBodyPanes) {
                for (Node lNode : lDayBodyPane.getChildren()) {
                    if (!(lNode instanceof AppointmentAbstractPane)) continue;
                    ((AppointmentAbstractPane)lNode).determineHistoryVisualizer(lNow);
                }
            }
        }
    };
    Timer nowTimer = new Timer(this.nowUpdateRunnable).withCycleDuration(new Duration(60000.0)).withDelay(new Duration((double)((60 - LocalDateTime.now().getSecond()) * 1000 - LocalDateTime.now().getNano() / 1000000))).start();
    private LayoutHelp layoutHelp = new LayoutHelp((Agenda)this.getSkinnable(), this);

    public AgendaSkinTimeScale24HourAbstract(Agenda control) {
        super((Control)control);
        this.control = control;
        this.construct();
    }

    protected void reconstruct() {
        this.weekBodyPane.reconstruct();
        this.weekHeaderPane.reconstruct();
        this.refresh();
    }

    private void construct() {
        this.appointments = new AllAppointments(((Agenda)this.getSkinnable()).appointments());
        this.createNodes();
        ((Agenda)this.getSkinnable()).localeProperty().addListener(this.localeInvalidationListener);
        ((Agenda)this.getSkinnable()).displayedLocalDateTime().addListener(this.displayedDateTimeChangeListener);
        ((Agenda)this.getSkinnable()).appointments().addListener(this.appointmentsListChangeListener);
        ((Agenda)this.getSkinnable()).appointments().addListener(this.appointmentNodeMapCleanUpListChangeListener);
        this.refresh();
    }

    public void dispose() {
        ((Agenda)this.getSkinnable()).localeProperty().removeListener(this.localeInvalidationListener);
        ((Agenda)this.getSkinnable()).displayedLocalDateTime().removeListener(this.displayedDateTimeChangeListener);
        ((Agenda)this.getSkinnable()).appointments().removeListener(this.appointmentsListChangeListener);
        ((Agenda)this.getSkinnable()).appointments().removeListener(this.appointmentNodeMapCleanUpListChangeListener);
        ((Agenda)this.getSkinnable()).getStyleClass().clear();
        ((Agenda)this.getSkinnable()).getStyleClass().add((Object)Agenda.class.getSimpleName());
        super.dispose();
    }

    private void assignDateToDayAndHeaderPanes() {
        Object lRange;
        int i = 0;
        List<LocalDate> lLocalDates = this.determineDisplayedLocalDates();
        for (LocalDate lLocalDate : lLocalDates) {
            DayBodyPane lDayPane = this.weekBodyPane.dayBodyPanes.get(i);
            lDayPane.localDateObjectProperty.set((Object)lLocalDate);
            DayHeaderPane lDayHeaderPane = this.weekHeaderPane.dayHeaderPanes.get(i);
            lDayHeaderPane.localDateObjectProperty.set((Object)lLocalDate);
            ++i;
        }
        this.nowUpdateRunnable.run();
        LocalDate lStartLocalDate = lLocalDates.get(0);
        LocalDate lEndLocalDate = lLocalDates.get(lLocalDates.size() - 1);
        if (((Agenda)this.getSkinnable()).getLocalDateTimeRangeCallback() != null) {
            lRange = new Agenda.LocalDateTimeRange(lStartLocalDate.atStartOfDay(), lEndLocalDate.plusDays(1L).atStartOfDay());
            ((Agenda)this.getSkinnable()).getLocalDateTimeRangeCallback().call(lRange);
        }
        if (((Agenda)this.getSkinnable()).getCalendarRangeCallback() != null) {
            lRange = new Agenda.CalendarRange(DateTimeToCalendarHelper.createCalendarFromLocalDate(lStartLocalDate, TimeZone.getDefault(), Locale.getDefault()), DateTimeToCalendarHelper.createCalendarFromLocalDate(lEndLocalDate, TimeZone.getDefault(), Locale.getDefault()));
            ((Agenda)this.getSkinnable()).getCalendarRangeCallback().call(lRange);
        }
    }

    private void refreshLocale() {
        String lWeekendOrWeekday;
        Locale locale = ((Agenda)this.getSkinnable()).getLocale();
        this.layoutHelp.dayOfWeekDateFormat = new SimpleDateFormat("E", locale);
        this.layoutHelp.dayOfWeekDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("E").toFormatter(locale);
        this.layoutHelp.dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        this.layoutHelp.dateDateTimeFormatter = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.SHORT, null).toFormatter(locale);
        for (DayBodyPane lDayBodyPane : this.weekBodyPane.dayBodyPanes) {
            lWeekendOrWeekday = this.isWeekend((LocalDate)lDayBodyPane.localDateObjectProperty.get()) ? "weekend" : "weekday";
            lDayBodyPane.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayBodyPane.getStyleClass().add((Object)lWeekendOrWeekday);
        }
        for (DayHeaderPane lDayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            lWeekendOrWeekday = this.isWeekend((LocalDate)lDayHeaderPane.localDateObjectProperty.get()) ? "weekend" : "weekday";
            lDayHeaderPane.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayHeaderPane.getStyleClass().add((Object)lWeekendOrWeekday);
        }
    }

    @Override
    public void setupAppointments() {
        for (DayHeaderPane dayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            dayHeaderPane.setupAppointments();
        }
        for (DayBodyPane dayBodyPane : this.weekBodyPane.dayBodyPanes) {
            dayBodyPane.setupAppointments();
        }
        this.calculateSizes();
        this.nowUpdateRunnable.run();
    }

    @Override
    public void refresh() {
        this.assignDateToDayAndHeaderPanes();
        this.refreshLocale();
        this.setupAppointments();
        this.nowUpdateRunnable.run();
    }

    public Pane getNodeForPopup(Agenda.Appointment appointment) {
        return this.appointmentNodeMap.get(System.identityHashCode(appointment));
    }

    Map<Integer, Pane> appointmentNodeMap() {
        return this.appointmentNodeMap;
    }

    public final ObjectProperty<Double> snapToMinutesProperty() {
        return this.snapToMinutesProperty;
    }

    public final void setSnapToMinutes(double value) {
        this.snapToMinutesProperty().set((Object)value);
    }

    public final double getSnapToMinutes() {
        return ((Double)this.snapToMinutesProperty.get()).intValue();
    }

    public final T withSnapToMinutes(double value) {
        this.setSnapToMinutes(value);
        return (T)this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AgendaSkinTimeScale24HourAbstract.getClassCssMetaData();
    }

    private void createNodes() {
        this.getChildren().clear();
        if (this.borderPane != null) {
            this.layoutHelp.dragPane.getChildren().remove((Object)this.borderPane);
        }
        this.borderPane = new BorderPane();
        this.borderPane.prefWidthProperty().bind((ObservableValue)((Agenda)this.getSkinnable()).widthProperty());
        this.borderPane.prefHeightProperty().bind((ObservableValue)((Agenda)this.getSkinnable()).heightProperty());
        this.getChildren().add((Object)this.borderPane);
        this.weekBodyPane = new WeekBodyPane();
        this.weekScrollPane = new ScrollPane();
        this.weekScrollPane.setContent((Node)this.weekBodyPane);
        this.weekScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.weekScrollPane.setFitToWidth(true);
        this.weekScrollPane.setPannable(false);
        this.borderPane.setCenter((Node)this.weekScrollPane);
        this.weekScrollPane.viewportBoundsProperty().addListener(observable -> {
            this.calculateSizes();
            this.nowUpdateRunnable.run();
        });
        this.weekHeaderPane = new WeekHeaderPane(this.weekBodyPane);
        this.weekHeaderPane.setTranslateX(1.0);
        this.borderPane.setTop((Node)this.weekHeaderPane);
        this.getChildren().remove((Object)this.borderPane);
        this.layoutHelp.dragPane.getChildren().add((Object)this.borderPane);
        this.getChildren().add((Object)this.layoutHelp.dragPane);
        ((Agenda)this.getSkinnable()).getStyleClass().add((Object)this.getClass().getSimpleName());
    }

    private void scrollWeekpaneToShowDisplayedTime() {
        LocalDateTime lDisplayedLocalDateTime = (LocalDateTime)((Agenda)this.getSkinnable()).displayedLocalDateTime().get();
        double lOffsetInMinutes = lDisplayedLocalDateTime.getHour() * 60 + lDisplayedLocalDateTime.getMinute();
        double lScrollRange = this.weekScrollPane.getVmax() - this.weekScrollPane.getVmin();
        double lValue = lScrollRange * lOffsetInMinutes / 1440.0;
        this.weekScrollPane.setVvalue(lValue);
    }

    protected abstract List<LocalDate> determineDisplayedLocalDates();

    private boolean isWeekend(LocalDate localDate) {
        return localDate.getDayOfWeek() == DayOfWeek.SATURDAY || localDate.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    private void calculateSizes() {
        int lMaxOfWholeDayAppointments = 0;
        for (DayHeaderPane lDayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            int lNumberOfWholeDayAppointments = lDayHeaderPane.getNumberOfWholeDayAppointments();
            lMaxOfWholeDayAppointments = Math.max(lMaxOfWholeDayAppointments, lNumberOfWholeDayAppointments);
        }
        this.layoutHelp.highestNumberOfWholedayAppointmentsProperty.set(lMaxOfWholeDayAppointments);
        if (this.weekScrollPane.viewportBoundsProperty().get() != null) {
            this.layoutHelp.dayWidthProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getWidth() - this.layoutHelp.timeWidthProperty.get()) / (double)this.determineDisplayedLocalDates().size());
        }
        double lScrollbarSize = new ScrollBar().getWidth();
        this.layoutHelp.hourHeighProperty.set(this.layoutHelp.textHeightProperty.get() * 2.0 + 10.0);
        if (this.weekScrollPane.viewportBoundsProperty().get() != null && ((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize > this.layoutHelp.hourHeighProperty.get() * 24.0) {
            this.layoutHelp.hourHeighProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize) / 24.0);
        }
    }

    @Override
    public LocalDateTime convertClickInSceneToDateTime(double x, double y) {
        LocalDateTime lLocalDateTime;
        for (DayBodyPane lDayPane : this.weekBodyPane.dayBodyPanes) {
            lLocalDateTime = lDayPane.convertClickInSceneToDateTime(x, y);
            if (lLocalDateTime == null) continue;
            return lLocalDateTime;
        }
        for (DayHeaderPane lDayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            lLocalDateTime = lDayHeaderPane.convertClickInSceneToDateTime(x, y);
            if (lLocalDateTime == null) continue;
            return lLocalDateTime;
        }
        return null;
    }

    @Override
    public void print(PrinterJob job) {
        float width = 5000.0f;
        float height = 5000.0f;
        BorderPane borderPane = new BorderPane();
        borderPane.prefWidthProperty().set((double)width);
        borderPane.prefHeightProperty().set((double)height);
        WeekBodyPane weekBodyPane = new WeekBodyPane();
        borderPane.setCenter((Node)weekBodyPane);
        WeekHeaderPane weekHeaderPane = new WeekHeaderPane(weekBodyPane);
        borderPane.setTop((Node)weekHeaderPane);
        borderPane.getStyleClass().add((Object)Agenda.class.getSimpleName());
        borderPane.getStyleClass().add((Object)this.getClass().getSimpleName());
        PageLayout pageLayout = job.getJobSettings().getPageLayout();
        double scaleX = pageLayout.getPrintableWidth() / borderPane.getBoundsInParent().getWidth();
        double scaleY = pageLayout.getPrintableHeight() / borderPane.getBoundsInParent().getHeight();
        borderPane.getTransforms().add((Object)new Scale(scaleX, scaleY *= 0.9));
        job.printPage(pageLayout, (Node)borderPane);
    }

    class WeekBodyPane
    extends Pane {
        final List<DayBodyPane> dayBodyPanes = new ArrayList<DayBodyPane>();

        public WeekBodyPane() {
            this.getStyleClass().add((Object)"Week");
            this.construct();
        }

        private void construct() {
            this.getChildren().add((Object)new TimeScale24Hour(this, AgendaSkinTimeScale24HourAbstract.this.layoutHelp));
            int i = 0;
            for (LocalDate localDate : AgendaSkinTimeScale24HourAbstract.this.determineDisplayedLocalDates()) {
                DayBodyPane lDayPane = new DayBodyPane(localDate, AgendaSkinTimeScale24HourAbstract.this.appointments, AgendaSkinTimeScale24HourAbstract.this.layoutHelp);
                lDayPane.layoutXProperty().bind((ObservableValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayWidthProperty.multiply(i).add((ObservableNumberValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayFirstColumnXProperty));
                lDayPane.layoutYProperty().set(0.0);
                lDayPane.prefWidthProperty().bind((ObservableValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayWidthProperty);
                lDayPane.prefHeightProperty().bind((ObservableValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.dayHeightProperty);
                this.getChildren().add((Object)lDayPane);
                this.dayBodyPanes.add(lDayPane);
                localDate = localDate.plusDays(1L);
                ++i;
            }
        }

        void reconstruct() {
            this.dayBodyPanes.clear();
            this.getChildren().clear();
            this.construct();
        }
    }

    class WeekHeaderPane
    extends Pane {
        final List<DayHeaderPane> dayHeaderPanes = new ArrayList<DayHeaderPane>();

        public WeekHeaderPane(WeekBodyPane weekBodyPane) {
            this.construct();
        }

        private void construct() {
            for (DayBodyPane dayBodyPane : ((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).weekBodyPane.dayBodyPanes) {
                DayHeaderPane lDayHeader = new DayHeaderPane((LocalDate)dayBodyPane.localDateObjectProperty.get(), AgendaSkinTimeScale24HourAbstract.this.appointments, AgendaSkinTimeScale24HourAbstract.this.layoutHelp);
                lDayHeader.layoutXProperty().bind((ObservableValue)dayBodyPane.layoutXProperty());
                lDayHeader.layoutYProperty().set(0.0);
                lDayHeader.prefWidthProperty().bind((ObservableValue)dayBodyPane.prefWidthProperty());
                lDayHeader.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                this.getChildren().add((Object)lDayHeader);
                this.dayHeaderPanes.add(lDayHeader);
            }
            this.prefWidthProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.widthProperty());
            this.prefHeightProperty().bind((ObservableValue)((AgendaSkinTimeScale24HourAbstract)AgendaSkinTimeScale24HourAbstract.this).layoutHelp.headerHeightProperty);
        }

        private void reconstruct() {
            this.dayHeaderPanes.clear();
            this.getChildren().clear();
            this.construct();
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<Agenda, Double> SNAPTOMINUTES_CSSMETADATA = new CssMetaDataForSkinProperty<Agenda, AgendaSkinTimeScale24HourAbstract<?>, Double>("-fxx-snap-to-minutes", DoubleConverter.getInstance(), 5.0){

            @Override
            protected ObjectProperty<Double> getProperty(AgendaSkinTimeScale24HourAbstract<?> s) {
                return ((AgendaSkinTimeScale24HourAbstract)s).snapToMinutesProperty;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$100() {
            return SNAPTOMINUTES_CSSMETADATA;
        }

        static {
            ArrayList<CssMetaData<Agenda, Double>> styleables = new ArrayList<CssMetaData<Agenda, Double>>(SkinBase.getClassCssMetaData());
            styleables.add(SNAPTOMINUTES_CSSMETADATA);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

