/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.text.Text;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractTrackedPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DurationDragger;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;

public class AppointmentRegularBodyPane
extends AppointmentAbstractTrackedPane {
    private String startAsString;
    private String endAsString;
    private final InvalidationListener allowResizeInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            AppointmentRegularBodyPane.this.setupDurationDragger();
        }
    };
    private DurationDragger durationDragger = null;

    public AppointmentRegularBodyPane(LocalDate localDate, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        super(localDate, appointment, layoutHelp);
        this.startAsString = layoutHelp.timeDateTimeFormatter.format(this.startDateTime);
        this.endAsString = layoutHelp.timeDateTimeFormatter.format(this.endDateTime);
        Text lTimeText = new Text((this.firstPaneOfAppointment ? this.startAsString : "") + "-" + (this.lastPaneOfAppointment ? this.endAsString : ""));
        lTimeText.getStyleClass().add((Object)"AppointmentTimeLabel");
        lTimeText.setX(layoutHelp.paddingProperty.get());
        lTimeText.setY(lTimeText.prefHeight(0.0));
        layoutHelp.clip(this, lTimeText, this.widthProperty().subtract((ObservableNumberValue)layoutHelp.paddingProperty), this.heightProperty().add(0.0), true, 0.0);
        this.getChildren().add((Object)lTimeText);
        Text lSummaryText = new Text(appointment.getSummary());
        lSummaryText.getStyleClass().add((Object)"AppointmentLabel");
        lSummaryText.setX(layoutHelp.paddingProperty.get());
        lSummaryText.setY(lTimeText.getY() + layoutHelp.textHeightProperty.get());
        lSummaryText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(layoutHelp.paddingProperty.get()));
        layoutHelp.clip(this, lSummaryText, this.widthProperty().add(0.0), this.heightProperty().subtract((ObservableNumberValue)layoutHelp.paddingProperty), false, 0.0);
        this.getChildren().add((Object)lSummaryText);
        this.getChildren().add((Object)this.appointmentMenu);
        layoutHelp.skinnable.allowResizeProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.allowResizeInvalidationListener));
        this.setupDurationDragger();
    }

    private void setupDurationDragger() {
        if (this.lastPaneOfAppointment && this.layoutHelp.skinnable.getAllowResize()) {
            if (this.durationDragger == null) {
                this.durationDragger = new DurationDragger(this, this.appointment, this.layoutHelp);
            }
            this.getChildren().add((Object)this.durationDragger);
        } else {
            this.getChildren().remove((Object)this.durationDragger);
        }
    }
}

