/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AgendaSkinTimeScale24HourAbstract;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractTrackedPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentTaskBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentWholedayBodyPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.util.NodeUtil;

class DayBodyPane
extends Pane {
    final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    final AllAppointments allAppointments;
    final LayoutHelp layoutHelp;
    private Rectangle resizeRectangle = null;
    private boolean dragged = false;
    final List<AppointmentAbstractTrackedPane> trackedAppointmentBodyPanes = new ArrayList<AppointmentAbstractTrackedPane>();
    private final List<Agenda.Appointment> wholedayAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentWholedayBodyPane> wholedayAppointmentBodyPanes = new ArrayList<AppointmentWholedayBodyPane>();
    private final List<Agenda.Appointment> taskAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentTaskBodyPane> taskAppointmentBodyPanes = new ArrayList<AppointmentTaskBodyPane>();
    private final List<Agenda.Appointment> regularAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentRegularBodyPane> regularAppointmentBodyPanes = new ArrayList<AppointmentRegularBodyPane>();

    public DayBodyPane(LocalDate localDate, AllAppointments allAppointments, LayoutHelp layoutHints) {
        this.localDateObjectProperty.set((Object)localDate);
        this.allAppointments = allAppointments;
        this.layoutHelp = layoutHints;
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)"Day");
        this.setId("DayBodyPane" + this.localDateObjectProperty.get());
        this.allAppointments.addOnChangeListener(() -> this.setupAppointments());
        this.setupAppointments();
        this.widthProperty().addListener(observable -> this.relayout());
        this.heightProperty().addListener(observable -> this.relayout());
        this.setupMouseDrag();
        this.localDateObjectProperty.addListener(observable -> this.setId("DayBody" + this.localDateObjectProperty.get()));
        this.setId("DayBody" + this.localDateObjectProperty.get());
    }

    private void setupMouseDrag() {
        this.setOnMousePressed(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            if (this.layoutHelp.skinnable.createAppointmentCallbackProperty().get() == null && this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() == null) {
                return;
            }
            this.setCursor(Cursor.V_RESIZE);
            double lY = NodeUtil.snapXY(mouseEvent.getScreenY() - NodeUtil.screenY((Node)this));
            this.resizeRectangle = new Rectangle(0.0, lY, this.layoutHelp.dayWidthProperty.get(), 10.0);
            this.resizeRectangle.getStyleClass().add((Object)"GhostRectangle");
            this.getChildren().add((Object)this.resizeRectangle);
            mouseEvent.consume();
            this.dragged = false;
            this.layoutHelp.skinnable.selectedAppointments().clear();
        });
        this.setOnMouseDragged(mouseEvent -> {
            if (this.resizeRectangle == null) {
                return;
            }
            double lHeight = mouseEvent.getScreenY() - NodeUtil.screenY((Node)this.resizeRectangle);
            if (lHeight < 5.0) {
                lHeight = 5.0;
            }
            this.resizeRectangle.setHeight(lHeight);
            mouseEvent.consume();
            this.dragged = true;
        });
        this.setOnMouseReleased(mouseEvent -> {
            if (this.resizeRectangle == null) {
                return;
            }
            mouseEvent.consume();
            this.setCursor(Cursor.HAND);
            this.getChildren().remove((Object)this.resizeRectangle);
            if (!this.dragged) {
                return;
            }
            LocalDateTime lStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay();
            lStartDateTime = lStartDateTime.plusSeconds((int)(this.resizeRectangle.getY() * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
            lStartDateTime = this.layoutHelp.roundTimeToNearestMinutes(lStartDateTime, (int)((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).getSnapToMinutes());
            LocalDateTime lEndDateTime = lStartDateTime.plusSeconds((int)(this.resizeRectangle.getHeight() * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
            lEndDateTime = this.layoutHelp.roundTimeToNearestMinutes(lEndDateTime, (int)((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).getSnapToMinutes());
            this.resizeRectangle = null;
            Agenda.Appointment lAppointment = null;
            if (this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() != null) {
                lAppointment = (Agenda.Appointment)((Callback)this.layoutHelp.skinnable.newAppointmentCallbackProperty().get()).call((Object)new Agenda.LocalDateTimeRange(lStartDateTime, lEndDateTime));
            }
            if (this.layoutHelp.skinnable.createAppointmentCallbackProperty().get() != null) {
                lAppointment = (Agenda.Appointment)((Callback)this.layoutHelp.skinnable.createAppointmentCallbackProperty().get()).call((Object)new Agenda.CalendarRange(DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lStartDateTime, TimeZone.getDefault(), Locale.getDefault()), DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lEndDateTime, TimeZone.getDefault(), Locale.getDefault())));
            }
            if (lAppointment != null) {
                this.layoutHelp.skinnable.appointments().add((Object)lAppointment);
            }
        });
    }

    private void relayout() {
        int lWholedayCnt = this.wholedayAppointmentBodyPanes.size();
        double lAllFlagpolesWidth = this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.get() * (double)lWholedayCnt;
        double lDayWidth = this.layoutHelp.dayContentWidthProperty.get();
        double lRemainingWidthForAppointments = lDayWidth - lAllFlagpolesWidth;
        double lNumberOfPixelsPerMinute = this.layoutHelp.dayHeightProperty.get() / 1440.0;
        for (AppointmentAbstractTrackedPane lAppointmentAbstractTrackedPane : this.trackedAppointmentBodyPanes) {
            double lH;
            double lNumberOfTracks = lAppointmentAbstractTrackedPane.clusterOwner.clusterTracks.size();
            double lTrackWidth = lRemainingWidthForAppointments / lNumberOfTracks;
            double lTrackIdx = lAppointmentAbstractTrackedPane.clusterTrackIdx;
            double lX = lAllFlagpolesWidth + lTrackWidth * lTrackIdx;
            lAppointmentAbstractTrackedPane.setLayoutX(NodeUtil.snapXY(lX));
            int lStartOffsetInMinutes = lAppointmentAbstractTrackedPane.startDateTime.getHour() * 60 + lAppointmentAbstractTrackedPane.startDateTime.getMinute();
            double lY = lNumberOfPixelsPerMinute * (double)lStartOffsetInMinutes;
            lAppointmentAbstractTrackedPane.setLayoutY(NodeUtil.snapXY(lY));
            double lW = lTrackWidth;
            if (lTrackIdx < lNumberOfTracks - 1.0) {
                lW *= 1.75;
            }
            lAppointmentAbstractTrackedPane.setPrefWidth(NodeUtil.snapWH(lAppointmentAbstractTrackedPane.getLayoutX(), lW));
            if (lAppointmentAbstractTrackedPane instanceof AppointmentTaskBodyPane) {
                lH = 5.0;
            } else {
                long lHeightInMinutes = lAppointmentAbstractTrackedPane.durationInMS / 1000L / 60L;
                lH = lNumberOfPixelsPerMinute * (double)lHeightInMinutes;
                if (lH < 2.0 * this.layoutHelp.paddingProperty.get()) {
                    lH = 2.0 * this.layoutHelp.paddingProperty.get();
                }
            }
            lAppointmentAbstractTrackedPane.setPrefHeight(NodeUtil.snapWH(lAppointmentAbstractTrackedPane.getLayoutY(), lH));
        }
    }

    void setupAppointments() {
        this.setupWholedayAppointments();
        this.setupTaskAppointments();
        this.setupRegularAppointments();
        this.trackedAppointmentBodyPanes.clear();
        this.trackedAppointmentBodyPanes.addAll(this.regularAppointmentBodyPanes);
        this.trackedAppointmentBodyPanes.addAll(this.taskAppointmentBodyPanes);
        List<? extends AppointmentAbstractTrackedPane> determineTracks = AppointmentRegularBodyPane.determineTracks(this.trackedAppointmentBodyPanes);
        this.getChildren().addAll(determineTracks);
        this.relayout();
    }

    private void setupWholedayAppointments() {
        this.wholedayAppointments.clear();
        this.wholedayAppointments.addAll(this.allAppointments.collectWholedayFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.wholedayAppointmentBodyPanes);
        this.wholedayAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.wholedayAppointments) {
            AppointmentWholedayBodyPane lAppointmentPane = new AppointmentWholedayBodyPane((LocalDate)this.localDateObjectProperty.get(), lAppointment, this.layoutHelp);
            this.wholedayAppointmentBodyPanes.add(lAppointmentPane);
            ((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).appointmentNodeMap().put(System.identityHashCode(lAppointment), lAppointmentPane);
            lAppointmentPane.setId(((Object)((Object)lAppointmentPane)).getClass().getSimpleName() + this.localDateObjectProperty.get() + "/" + lCnt);
            lAppointmentPane.layoutXProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt)));
            lAppointmentPane.setLayoutY(0.0);
            lAppointmentPane.prefWidthProperty().bind((ObservableValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty);
            lAppointmentPane.prefHeightProperty().bind((ObservableValue)this.layoutHelp.dayHeightProperty);
            ++lCnt;
        }
        this.getChildren().addAll(this.wholedayAppointmentBodyPanes);
    }

    private void setupTaskAppointments() {
        this.taskAppointments.clear();
        this.taskAppointments.addAll(this.allAppointments.collectTaskFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.taskAppointmentBodyPanes);
        this.taskAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.taskAppointments) {
            AppointmentTaskBodyPane lAppointmentPane = new AppointmentTaskBodyPane(lAppointment, this.layoutHelp);
            this.taskAppointmentBodyPanes.add(lAppointmentPane);
            ((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).appointmentNodeMap().put(System.identityHashCode(lAppointment), lAppointmentPane);
            lAppointmentPane.setId(((Object)((Object)lAppointmentPane)).getClass().getSimpleName() + this.localDateObjectProperty.get() + "/" + lCnt);
            ++lCnt;
        }
    }

    private void setupRegularAppointments() {
        this.regularAppointments.clear();
        this.regularAppointments.addAll(this.allAppointments.collectRegularFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.regularAppointmentBodyPanes);
        this.regularAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.regularAppointments) {
            AppointmentRegularBodyPane lAppointmentPane = new AppointmentRegularBodyPane((LocalDate)this.localDateObjectProperty.get(), lAppointment, this.layoutHelp);
            this.regularAppointmentBodyPanes.add(lAppointmentPane);
            ((AgendaSkinTimeScale24HourAbstract)this.layoutHelp.skin).appointmentNodeMap().put(System.identityHashCode(lAppointment), lAppointmentPane);
            lAppointmentPane.setId(((Object)((Object)lAppointmentPane)).getClass().getSimpleName() + this.localDateObjectProperty.get() + "/" + lCnt);
            ++lCnt;
        }
    }

    LocalDateTime convertClickInSceneToDateTime(double x, double y) {
        Rectangle r = new Rectangle(NodeUtil.sceneX((Node)this), NodeUtil.sceneY((Node)this), this.getWidth(), this.getHeight());
        if (r.contains(x, y)) {
            LocalDate localDate = (LocalDate)this.localDateObjectProperty.get();
            double lHeightOffset = y - r.getY();
            int ms = (int)(lHeightOffset * this.layoutHelp.durationInMSPerPixelProperty.get());
            LocalDateTime localDateTime = localDate.atStartOfDay().plusSeconds(ms / 1000);
            localDateTime = localDateTime.withNano(1);
            return localDateTime;
        }
        return null;
    }
}

