/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentWholedayHeaderPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import jfxtras.scene.control.agenda.Agenda;
import jfxtras.util.NodeUtil;

public class DayHeaderPane
extends Pane {
    final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    final AllAppointments allAppointments;
    final LayoutHelp layoutHelp;
    private Text dayText = new Text("?");
    private final List<Agenda.Appointment> appointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentWholedayHeaderPane> appointmentHeaderPanes = new ArrayList<AppointmentWholedayHeaderPane>();

    public DayHeaderPane(LocalDate localDate, AllAppointments allAppointments, LayoutHelp layoutHelp) {
        this.localDateObjectProperty.set((Object)localDate);
        this.allAppointments = allAppointments;
        this.layoutHelp = layoutHelp;
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)"DayHeader");
        this.dayText = new Text("?");
        this.dayText.getStyleClass().add((Object)"DayLabel");
        this.dayText.setX(this.layoutHelp.paddingProperty.get());
        this.dayText.setY(this.dayText.prefHeight(0.0));
        this.getChildren().add((Object)this.dayText);
        Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract(this.layoutHelp.paddingProperty.get()));
        lClip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.dayText.setClip((Node)lClip);
        this.localDateObjectProperty.addListener(observable -> this.setLabel());
        this.setLabel();
        this.allAppointments.addOnChangeListener(() -> this.setupAppointments());
        this.setupAppointments();
        this.setupMouse();
    }

    private void setLabel() {
        String lLabel = ((LocalDate)this.localDateObjectProperty.get()).format(this.layoutHelp.dayOfWeekDateTimeFormatter) + " " + ((LocalDate)this.localDateObjectProperty.get()).format(this.layoutHelp.dateDateTimeFormatter);
        this.dayText.setText(lLabel);
        this.setId("DayHeader" + this.localDateObjectProperty.get());
    }

    public void setupAppointments() {
        this.getChildren().removeAll(this.appointmentHeaderPanes);
        this.appointmentHeaderPanes.clear();
        this.appointments.clear();
        this.appointments.addAll(this.allAppointments.collectWholedayFor((LocalDate)this.localDateObjectProperty.get()));
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.appointments) {
            AppointmentWholedayHeaderPane lAppointmentHeaderPane = new AppointmentWholedayHeaderPane(lAppointment, this.layoutHelp);
            this.getChildren().add((Object)lAppointmentHeaderPane);
            this.appointmentHeaderPanes.add(lAppointmentHeaderPane);
            lAppointmentHeaderPane.setId(((Object)((Object)lAppointmentHeaderPane)).getClass().getSimpleName() + this.localDateObjectProperty.get() + "/" + lCnt);
            lAppointmentHeaderPane.layoutXProperty().bind((ObservableValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt));
            lAppointmentHeaderPane.layoutYProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.layoutHelp.appointmentHeaderPaneHeightProperty.multiply(this.appointments.size() - lCnt)));
            lAppointmentHeaderPane.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt)));
            lAppointmentHeaderPane.prefHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)lAppointmentHeaderPane.layoutYProperty()));
            ++lCnt;
        }
    }

    public int getNumberOfWholeDayAppointments() {
        return this.appointments.size();
    }

    private void setupMouse() {
        this.setOnMousePressed(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            if (this.layoutHelp.skinnable.createAppointmentCallbackProperty().get() == null && this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() == null) {
                return;
            }
            mouseEvent.consume();
            LocalDateTime lStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay();
            LocalDateTime lEndDateTime = lStartDateTime.plusDays(1L);
            Agenda.Appointment lAppointment = this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() != null ? (Agenda.Appointment)((Callback)this.layoutHelp.skinnable.newAppointmentCallbackProperty().get()).call((Object)new Agenda.LocalDateTimeRange(lStartDateTime, lEndDateTime)) : (Agenda.Appointment)((Callback)this.layoutHelp.skinnable.createAppointmentCallbackProperty().get()).call((Object)new Agenda.CalendarRange(DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lStartDateTime, TimeZone.getDefault(), Locale.getDefault()), DateTimeToCalendarHelper.createCalendarFromLocalDateTime(lEndDateTime, TimeZone.getDefault(), Locale.getDefault())));
            if (lAppointment != null) {
                lAppointment.setWholeDay(true);
                this.layoutHelp.skinnable.appointments().add((Object)lAppointment);
            }
        });
    }

    LocalDateTime convertClickInSceneToDateTime(double x, double y) {
        Rectangle r = new Rectangle(NodeUtil.sceneX((Node)this), NodeUtil.sceneY((Node)this), this.getWidth(), this.getHeight());
        if (r.contains(x, y)) {
            LocalDate localDate = (LocalDate)this.localDateObjectProperty.get();
            LocalDateTime localDateTime = localDate.atStartOfDay();
            localDateTime = localDateTime.withNano(0);
            return localDateTime;
        }
        return null;
    }
}

