/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.NodeOrientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractPane;
import jfxtras.internal.scene.control.skin.agenda.base24hour.DragPane;
import jfxtras.scene.control.agenda.Agenda;

class LayoutHelp {
    final Agenda skinnable;
    final AgendaSkin skin;
    final DragPane dragPane;
    final DoubleProperty msPerDayProperty = new SimpleDoubleProperty(8.64E7);
    final IntegerProperty highestNumberOfWholedayAppointmentsProperty = new SimpleIntegerProperty(0);
    final DoubleProperty paddingProperty = new SimpleDoubleProperty(3.0);
    final DoubleProperty timeColumnWhitespaceProperty = new SimpleDoubleProperty(10.0);
    final DoubleProperty wholedayAppointmentFlagpoleWidthProperty = new SimpleDoubleProperty(5.0);
    final DoubleProperty textHeightProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty titleDateTimeHeightProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty headerHeightProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty appointmentHeaderPaneHeightProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty timeWidthProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty dayFirstColumnXProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty dayWidthProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty dayContentWidthProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty dayHeightProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty durationInMSPerPixelProperty = new SimpleDoubleProperty(0.0);
    final DoubleProperty hourHeighProperty = new SimpleDoubleProperty(0.0);
    SimpleDateFormat dayOfWeekDateFormat = new SimpleDateFormat("E", Locale.getDefault());
    DateTimeFormatter dayOfWeekDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("E").toFormatter(Locale.getDefault());
    SimpleDateFormat dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, Locale.getDefault());
    DateTimeFormatter dateDateTimeFormatter = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.SHORT, null).toFormatter(Locale.getDefault());
    static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    DateTimeFormatter timeDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm").toFormatter(Locale.getDefault());

    public LayoutHelp(Agenda skinnable, AgendaSkin skin) {
        this.skinnable = skinnable;
        this.skin = skin;
        this.dragPane = new DragPane(this);
        this.titleDateTimeHeightProperty.bind((ObservableValue)this.textHeightProperty.multiply(1.5));
        this.appointmentHeaderPaneHeightProperty.bind((ObservableValue)this.textHeightProperty.add(5));
        this.headerHeightProperty.bind((ObservableValue)this.highestNumberOfWholedayAppointmentsProperty.multiply((ObservableNumberValue)this.appointmentHeaderPaneHeightProperty).add((ObservableNumberValue)this.titleDateTimeHeightProperty));
        this.dayFirstColumnXProperty.bind((ObservableValue)this.timeWidthProperty);
        this.dayContentWidthProperty.bind((ObservableValue)this.dayWidthProperty.subtract(10));
        this.dayHeightProperty.bind((ObservableValue)this.hourHeighProperty.multiply(24));
        this.durationInMSPerPixelProperty.bind((ObservableValue)this.msPerDayProperty.divide((ObservableNumberValue)this.dayHeightProperty));
        Text textHeight = new Text("X");
        textHeight.getStyleClass().add((Object)"Agenda");
        this.textHeightProperty.set(textHeight.getBoundsInParent().getHeight());
        Text textWidth = new Text("88:88");
        textWidth.getStyleClass().add((Object)"Agenda");
        this.timeWidthProperty.bind((ObservableValue)this.timeColumnWhitespaceProperty.add(textWidth.getBoundsInParent().getWidth()));
    }

    void clip(Pane pane, Text text, DoubleBinding width, DoubleBinding height, boolean mirrorWidth, double additionMirorXOffset) {
        Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        if (mirrorWidth && this.skinnable.getNodeOrientation().equals((Object)NodeOrientation.RIGHT_TO_LEFT)) {
            lClip.xProperty().bind((ObservableValue)pane.widthProperty().multiply(-1.0).add(text.getBoundsInParent().getWidth()).add(additionMirorXOffset));
        }
        lClip.widthProperty().bind((ObservableValue)width);
        lClip.heightProperty().bind((ObservableValue)height);
        text.setClip((Node)lClip);
    }

    void setupMouseOverAsBusy(Node node) {
        node.setOnMouseEntered(mouseEvent -> {
            if (!mouseEvent.isPrimaryButtonDown()) {
                node.setCursor(Cursor.HAND);
                mouseEvent.consume();
            }
        });
        node.setOnMouseExited(mouseEvent -> {
            if (!mouseEvent.isPrimaryButtonDown()) {
                node.setCursor(Cursor.DEFAULT);
                mouseEvent.consume();
            }
        });
    }

    LocalDateTime roundTimeToNearestMinutes(LocalDateTime localDateTime, int minutes) {
        int lMinutes = (localDateTime = localDateTime.withSecond(0).withNano(0)).getMinute() % minutes;
        localDateTime = lMinutes < minutes / 2 ? localDateTime.plusMinutes(-1 * lMinutes) : localDateTime.plusMinutes(minutes - lMinutes);
        return localDateTime;
    }

    void callAppointmentChangedCallback(Agenda.Appointment appointment) {
        Callback<Agenda.Appointment, Void> lChangedCallback;
        if (!(appointment instanceof AppointmentAbstractPane.AppointmentForDrag) && (lChangedCallback = this.skinnable.getAppointmentChangedCallback()) != null) {
            lChangedCallback.call((Object)appointment);
        }
    }
}

