/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour;

import java.time.temporal.Temporal;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.Pair;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.EditChoiceDialog;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.scene.control.agenda.icalendar.editors.ChangeDialogOption;

public class EditWithRecurrencesChoiceDialog
extends EditChoiceDialog {
    public static final Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> EDIT_DIALOG_CALLBACK = choices -> {
        EditWithRecurrencesChoiceDialog dialog = new EditWithRecurrencesChoiceDialog((Map<ChangeDialogOption, Pair<Temporal, Temporal>>)choices, Settings.resources);
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (ChangeDialogOption)((Object)((Object)result.get())) : ChangeDialogOption.CANCEL;
    };

    public EditWithRecurrencesChoiceDialog(Map<ChangeDialogOption, Pair<Temporal, Temporal>> choiceList, ResourceBundle resources) {
        super(choiceList, resources);
        this.getDialogPane().setId("editWithRecurrencesChoiceDialog");
        this.setTitle(resources.getString("dialog.edit.title"));
        CheckBox includeRecurrenceCheckBox = new CheckBox("include special recurrences");
        includeRecurrenceCheckBox.setSelected(true);
        this.handleRecurrenceCheckBoxVisibility(includeRecurrenceCheckBox, (ChangeDialogOption)((Object)this.comboBox.getValue()));
        includeRecurrenceCheckBox.setVisible(false);
        GridPane g = (GridPane)this.getDialogPane().getContent();
        g.add((Node)includeRecurrenceCheckBox, 0, 1);
        this.comboBox.valueProperty().addListener((obs, oldValue, newValue) -> this.handleRecurrenceCheckBoxVisibility(includeRecurrenceCheckBox, (ChangeDialogOption)((Object)newValue)));
        this.setResultConverter(dialogButton -> {
            ChangeDialogOption selectedItem;
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            switch ((ChangeDialogOption)((Object)((Object)this.comboBox.getSelectionModel().getSelectedItem()))) {
                case ALL: {
                    selectedItem = includeRecurrenceCheckBox.isSelected() ? ChangeDialogOption.ALL : ChangeDialogOption.ALL_IGNORE_RECURRENCES;
                    break;
                }
                case THIS_AND_FUTURE: {
                    selectedItem = includeRecurrenceCheckBox.isSelected() ? ChangeDialogOption.THIS_AND_FUTURE : ChangeDialogOption.THIS_AND_FUTURE_IGNORE_RECURRENCES;
                    break;
                }
                default: {
                    selectedItem = (ChangeDialogOption)((Object)((Object)this.comboBox.getSelectionModel().getSelectedItem()));
                }
            }
            return data == ButtonBar.ButtonData.OK_DONE ? selectedItem : null;
        });
    }

    private void handleRecurrenceCheckBoxVisibility(CheckBox includeRecurrenceCheckBox, ChangeDialogOption newValue) {
        switch (newValue) {
            case ALL: 
            case THIS_AND_FUTURE: {
                includeRecurrenceCheckBox.setVisible(true);
                break;
            }
            case ONE: {
                includeRecurrenceCheckBox.setVisible(false);
                break;
            }
        }
    }
}

