/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.popup;

import java.io.IOException;
import java.net.URL;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.CategorySelectionGridPane;
import jfxtras.internal.scene.control.skin.agenda.icalendar.base24hour.Settings;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.control.agenda.TemporalUtilities;

public abstract class EditDescriptiveVBox<T extends VDisplayable<T>>
extends VBox {
    @FXML
    private ResourceBundle resources;
    static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    @FXML
    GridPane timeGridPane;
    LocalDateTimeTextField startDateTimeTextField = new LocalDateTimeTextField();
    LocalDateTextField startDateTextField = new LocalDateTextField();
    protected static final LocalTime DEFAULT_START_TIME = LocalTime.of(10, 0);
    @FXML
    Label endLabel;
    @FXML
    private CheckBox wholeDayCheckBox;
    @FXML
    TextField summaryTextField;
    @FXML
    TextArea descriptionTextArea;
    @FXML
    Label locationLabel;
    @FXML
    TextField locationTextField;
    @FXML
    TextField categoryTextField;
    @FXML
    private CategorySelectionGridPane categorySelectionGridPane;
    @FXML
    private Button saveComponentButton;
    @FXML
    private Button cancelComponentButton;
    @FXML
    private Button saveRepeatButton;
    @FXML
    private Button cancelRepeatButton;
    @FXML
    private Button deleteComponentButton;
    @FXML
    private Tab appointmentTab;
    @FXML
    private Tab repeatableTab;
    private final ChangeListener<? super LocalDate> startDateTextListener = (observable, oldValue, newValue) -> this.synchStartDate((LocalDate)oldValue, (LocalDate)newValue);
    private final ChangeListener<? super LocalDateTime> startDateTimeTextListener = (observable, oldValue, newValue) -> this.synchStartDateTime((LocalDateTime)oldValue, (LocalDateTime)newValue);
    protected final Callback<Throwable, Void> errorCallback = throwable -> {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Invalid Date or Time");
        alert.setContentText("Please enter valid date and time");
        alert.showAndWait();
        return null;
    };
    T vComponentEdited;
    private String initialCategory;
    Temporal startOriginalRecurrence;
    ObjectProperty<Temporal> startRecurrenceProperty;
    ChangeListener<? super Temporal> dateTimeStartListener = (obs, oldValue, newValue) -> {
        LocalDate d1 = LocalDate.from((TemporalAccessor)this.startRecurrenceProperty.get());
        LocalDate d2 = LocalDate.from(newValue);
        LocalDate d3 = LocalDate.from(oldValue);
        if (!DateTimeUtilities.isAfter(d1, d2) || d1.equals(d3)) {
            Temporal r = newValue.with(this.startDateTextField.getLocalDate());
            TemporalAmount shift = DateTimeUtilities.temporalAmountBetween(r, newValue);
            LocalDateTime startNew = this.startDateTimeTextField.getLocalDateTime().plus(shift);
            this.startDateTimeTextField.setLocalDateTime(startNew);
        }
    };

    public ResourceBundle getResources() {
        return this.resources;
    }

    public EditDescriptiveVBox() {
        EditDescriptiveVBox.loadFxml(EditDescriptiveVBox.class.getResource("EditDescriptive.fxml"), (Object)this);
        this.categorySelectionGridPane.getStylesheets().addAll((Collection)this.getStylesheets());
        this.startDateTimeTextField.setId("startDateTimeTextField");
        this.startDateTextField.setId("startDateTextField");
        this.startDateTimeTextField.setId("startDateTimeTextField");
    }

    void synchStartDate(LocalDate oldValue, LocalDate newValue) {
        this.startRecurrenceProperty.set((Object)newValue);
        this.startDateTimeTextField.localDateTimeProperty().removeListener(this.startDateTimeTextListener);
        LocalDateTime newDateTime = this.startDateTimeTextField.getLocalDateTime().with(newValue);
        this.startDateTimeTextField.setLocalDateTime(newDateTime);
        this.startDateTimeTextField.localDateTimeProperty().addListener(this.startDateTimeTextListener);
    }

    void synchStartDateTime(LocalDateTime oldValue, LocalDateTime newValue) {
        if (this.startOriginalRecurrence.isSupported(ChronoUnit.NANOS)) {
            this.startRecurrenceProperty.set((Object)this.startOriginalRecurrence.with(newValue));
        } else {
            this.startRecurrenceProperty.set((Object)ZonedDateTime.of(newValue, DEFAULT_ZONE_ID));
        }
        this.startDateTextField.localDateProperty().removeListener(this.startDateTextListener);
        LocalDate newDate = LocalDate.from(this.startDateTimeTextField.getLocalDateTime());
        this.startDateTextField.setLocalDate(newDate);
        this.startDateTextField.localDateProperty().addListener(this.startDateTextListener);
    }

    public void setupData(T vComponent, Temporal startRecurrence, Temporal endRecurrence, List<String> categories) {
        this.startOriginalRecurrence = startRecurrence;
        this.startRecurrenceProperty = new SimpleObjectProperty((Object)startRecurrence);
        this.vComponentEdited = vComponent;
        if (((VDisplayable)this.vComponentEdited).getRecurrenceDates() != null) {
            this.repeatableTab.setDisable(true);
            this.repeatableTab.setTooltip(new Tooltip(this.resources.getString("repeat.tab.unavailable")));
        }
        String initialSummary = ((VDisplayable)vComponent).getSummary() == null || ((VDisplayable)vComponent).getSummary().getValue() == null ? "" : (String)((VDisplayable)vComponent).getSummary().getValue();
        this.summaryTextField.setText(initialSummary);
        this.summaryTextField.textProperty().addListener((obs, oldValue, newValue) -> vComponent.setSummary((String)newValue));
        this.startDateTimeTextField.setLocale(Locale.getDefault());
        this.startDateTextField.setLocale(Locale.getDefault());
        this.startDateTimeTextField.setParseErrorCallback(this.errorCallback);
        this.startDateTextField.setParseErrorCallback(this.errorCallback);
        LocalDate start2 = LocalDate.from(startRecurrence);
        LocalDateTime start1 = ((VPrimary)this.vComponentEdited).isWholeDay() ? LocalDate.from(startRecurrence).atTime(DEFAULT_START_TIME) : TemporalUtilities.toLocalDateTime(startRecurrence);
        this.startDateTimeTextField.setLocalDateTime(start1);
        this.startDateTextField.setLocalDate(start2);
        this.startDateTimeTextField.localDateTimeProperty().addListener(this.startDateTimeTextListener);
        this.startDateTextField.localDateProperty().addListener(this.startDateTextListener);
        this.wholeDayCheckBox.setSelected(((VPrimary)this.vComponentEdited).isWholeDay());
        this.handleWholeDayChange(this.vComponentEdited, this.wholeDayCheckBox.isSelected());
        this.wholeDayCheckBox.selectedProperty().addListener((observable, oldSelection, newSelection) -> this.handleWholeDayChange(vComponent, (Boolean)newSelection));
        if (((VDisplayable)this.vComponentEdited).getCategories() == null) {
            ((VDisplayable)this.vComponentEdited).withCategories("");
            this.categoryTextField.setDisable(true);
            this.categoryTextField.setPromptText("Select a category color box");
        }
        this.categorySelectionGridPane.categorySelectedProperty().addListener((observable, oldSelection, newSelection) -> {
            Integer i = this.categorySelectionGridPane.getCategorySelected();
            String newText = (String)categories.get(i);
            this.categoryTextField.setDisable(false);
            this.categoryTextField.setPromptText("Enter category name");
            this.categoryTextField.setText(newText);
        });
        this.categoryTextField.textProperty().addListener((observable, oldSelection, newSelection) -> {
            int i = this.categorySelectionGridPane.getCategorySelected();
            if (!((String)categories.get(i)).equals(newSelection)) {
                categories.remove(i);
                categories.add(i, (String)newSelection);
            }
            this.categorySelectionGridPane.updateToolTip(i, (String)categories.get(i));
            ((VDisplayable)this.vComponentEdited).getCategories().get(0).setValue(Arrays.asList(newSelection));
        });
        this.categoryTextField.focusedProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.initialCategory = this.categoryTextField.getText();
            } else {
                int selectedIndex = this.categorySelectionGridPane.getCategorySelected();
                int otherMatch = -1;
                for (int i = 0; i < categories.size(); ++i) {
                    if (i == selectedIndex || !((String)categories.get(i)).equals(this.categoryTextField.getText())) continue;
                    otherMatch = ++i;
                    break;
                }
                if (otherMatch >= 0) {
                    this.invalidCategoryAlert(this.categoryTextField.getText(), otherMatch);
                    this.categoryTextField.setText(this.initialCategory);
                }
            }
        });
        String initialCategory = (String)((List)((VDisplayable)this.vComponentEdited).getCategories().get(0).getValue()).get(0);
        this.categorySelectionGridPane.setupData(initialCategory, categories);
        this.startDateTimeTextField.localDateTimeProperty().addListener(this.dateTimeStartListener);
    }

    void handleWholeDayChange(T vComponent, Boolean newSelection) {
        this.startDateTimeTextField.localDateTimeProperty().removeListener(this.startDateTimeTextListener);
        this.startDateTextField.localDateProperty().removeListener(this.startDateTextListener);
        if (newSelection.booleanValue()) {
            this.timeGridPane.getChildren().remove((Object)this.startDateTimeTextField);
            this.timeGridPane.add((Node)this.startDateTextField, 1, 0);
            this.startRecurrenceProperty.set((Object)this.startDateTextField.getLocalDate());
        } else {
            this.timeGridPane.getChildren().remove((Object)this.startDateTextField);
            this.timeGridPane.add((Node)this.startDateTimeTextField, 1, 0);
            if (this.startOriginalRecurrence instanceof LocalDate) {
                this.startRecurrenceProperty.set((Object)this.startDateTimeTextField.getLocalDateTime().atZone(DEFAULT_ZONE_ID));
            } else if (this.startOriginalRecurrence instanceof LocalDateTime) {
                this.startRecurrenceProperty.set((Object)this.startDateTimeTextField.getLocalDateTime());
            } else if (this.startOriginalRecurrence instanceof ZonedDateTime) {
                ZoneId originalZoneId = ((ZonedDateTime)this.startOriginalRecurrence).getZone();
                this.startRecurrenceProperty.set((Object)this.startDateTimeTextField.getLocalDateTime().atZone(originalZoneId));
            } else {
                throw new DateTimeException("Unsupported Temporal type:" + this.startOriginalRecurrence.getClass());
            }
        }
        this.startDateTextField.localDateProperty().addListener(this.startDateTextListener);
        this.startDateTimeTextField.localDateTimeProperty().addListener(this.startDateTimeTextListener);
    }

    void synchRecurrenceDates(Temporal oldValue, Temporal newValue) {
        if (!this.vComponentEdited.isRecurrence((Temporal)this.startRecurrenceProperty.get())) {
            TemporalAmount shift = DateTimeUtilities.temporalAmountBetween(oldValue, newValue);
            LocalDateTime startNew = this.startDateTimeTextField.getLocalDateTime().plus(shift);
            this.startDateTimeTextField.setLocalDateTime(startNew);
        }
    }

    @Deprecated
    protected void startRecurrenceChangedAlert(Temporal t1, Temporal t2) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.getDialogPane().setId("startInstanceChangedAlert");
        alert.getDialogPane().lookupButton(ButtonType.OK).setId("startInstanceChangedAlertOkButton");
        alert.setHeaderText("Time not valid due to repeat rule change");
        alert.setContentText(Settings.DATE_FORMAT_AGENDA_EXCEPTION.format(t1) + " is no longer valid." + System.lineSeparator() + "It has been replaced by " + Settings.DATE_FORMAT_AGENDA_EXCEPTION.format(t2));
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    protected void invalidCategoryAlert(String newString, int otherMatch) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.getDialogPane().setId("invalidCategoryAlert");
        alert.getDialogPane().lookupButton(ButtonType.OK).setId("invalidCategoryAlertOkButton");
        alert.setTitle("Edit Component Error");
        alert.setHeaderText("Invalid Category Name.");
        alert.setContentText("The Category name must be unique." + System.lineSeparator() + "The name \"" + newString + "\" matches category #" + otherMatch);
        ButtonType buttonTypeOk = new ButtonType("OK", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOk});
        alert.showAndWait();
    }

    protected static void loadFxml(URL fxmlFile, Object rootController) {
        FXMLLoader loader = new FXMLLoader(fxmlFile);
        loader.setController(rootController);
        loader.setRoot(rootController);
        loader.setResources(Settings.resources);
        try {
            loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

