/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda;

import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TreeMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.print.PrinterJob;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import jfxtras.internal.scene.control.skin.agenda.AgendaWeekSkin;
import jfxtras.scene.control.agenda.TemporalUtilities;

public class Agenda
extends Control {
    private final ObservableList<Appointment> appointments = FXCollections.observableArrayList();
    private final ObservableList<AppointmentGroup> appointmentGroups = FXCollections.observableArrayList();
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final SimpleBooleanProperty allowDraggingObjectProperty = new SimpleBooleanProperty((Object)this, "allowDragging", true);
    private final SimpleBooleanProperty allowResizeObjectProperty = new SimpleBooleanProperty((Object)this, "allowResize", true);
    private final ObjectProperty<Calendar> displayedCalendarObjectProperty = new SimpleObjectProperty((Object)this, "displayedCalendar", (Object)Calendar.getInstance());
    private final ObjectProperty<LocalDateTime> displayedLocalDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDateTime", (Object)LocalDateTime.now());
    private final ObservableList<Appointment> selectedAppointments = FXCollections.observableArrayList();
    @Deprecated
    private final ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "calendarRangeCallback", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, Void>> localDateTimeRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateTimeRangeCallback", null);
    @Deprecated
    private final ObjectProperty<Callback<CalendarRange, Appointment>> createAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "createAppointmentCallback", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, Appointment>> newAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "newAppointmentCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "editAppointmentCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> appointmentChangedCallbackObjectProperty = new SimpleObjectProperty((Object)this, "appointmentChangedCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> actionCallbackObjectProperty = new SimpleObjectProperty((Object)this, "actionCallback", null);

    public Agenda() {
        this.construct();
    }

    private void construct() {
        this.setPrefSize(1000.0, 800.0);
        this.getStyleClass().add((Object)Agenda.class.getSimpleName());
        DateTimeToCalendarHelper.syncLocalDateTime(this.displayedCalendarObjectProperty, this.displayedLocalDateTimeObjectProperty, this.localeObjectProperty);
        this.constructAppointmentGroups();
        this.constructAppointments();
    }

    public String getUserAgentStylesheet() {
        return Agenda.class.getResource("/jfxtras/internal/scene/control/skin/agenda/" + Agenda.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new AgendaWeekSkin(this);
    }

    public Agenda withId(String value) {
        this.setId(value);
        return this;
    }

    public ObservableList<Appointment> appointments() {
        return this.appointments;
    }

    private void constructAppointments() {
        this.appointments.addListener((ListChangeListener)new ListChangeListener<Appointment>(){

            public void onChanged(ListChangeListener.Change<? extends Appointment> changes) {
                while (changes.next()) {
                    for (Appointment lAppointment : changes.getRemoved()) {
                        Agenda.this.selectedAppointments.remove((Object)lAppointment);
                    }
                }
            }
        });
    }

    public ObservableList<AppointmentGroup> appointmentGroups() {
        return this.appointmentGroups;
    }

    private void constructAppointmentGroups() {
        TreeMap<CallSite, AppointmentGroupImpl> lAppointmentGroupMap = new TreeMap<CallSite, AppointmentGroupImpl>();
        for (int i = 0; i < 24; ++i) {
            lAppointmentGroupMap.put((CallSite)((Object)("group" + (i < 10 ? "0" : "") + i)), new AppointmentGroupImpl().withStyleClass("group" + i));
        }
        for (String lId : lAppointmentGroupMap.keySet()) {
            AppointmentGroup lAppointmentGroup = (AppointmentGroup)lAppointmentGroupMap.get(lId);
            lAppointmentGroup.setDescription(lId);
            this.appointmentGroups().add((Object)lAppointmentGroup);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public Agenda withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public SimpleBooleanProperty allowDraggingProperty() {
        return this.allowDraggingObjectProperty;
    }

    public boolean getAllowDragging() {
        return this.allowDraggingObjectProperty.getValue();
    }

    public void setAllowDragging(boolean value) {
        this.allowDraggingObjectProperty.setValue(Boolean.valueOf(value));
    }

    public Agenda withAllowDragging(boolean value) {
        this.setAllowDragging(value);
        return this;
    }

    public SimpleBooleanProperty allowResizeProperty() {
        return this.allowResizeObjectProperty;
    }

    public boolean getAllowResize() {
        return this.allowResizeObjectProperty.getValue();
    }

    public void setAllowResize(boolean value) {
        this.allowResizeObjectProperty.setValue(Boolean.valueOf(value));
    }

    public Agenda withAllowResize(boolean value) {
        this.setAllowResize(value);
        return this;
    }

    @Deprecated
    public ObjectProperty<Calendar> displayedCalendar() {
        return this.displayedCalendarObjectProperty;
    }

    @Deprecated
    public Calendar getDisplayedCalendar() {
        return (Calendar)this.displayedCalendarObjectProperty.getValue();
    }

    @Deprecated
    public void setDisplayedCalendar(Calendar value) {
        this.displayedCalendarObjectProperty.setValue((Object)value);
    }

    @Deprecated
    public Agenda withDisplayedCalendar(Calendar value) {
        this.setDisplayedCalendar(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> displayedLocalDateTime() {
        return this.displayedLocalDateTimeObjectProperty;
    }

    public LocalDateTime getDisplayedLocalDateTime() {
        return (LocalDateTime)this.displayedLocalDateTimeObjectProperty.getValue();
    }

    public void setDisplayedLocalDateTime(LocalDateTime value) {
        this.displayedLocalDateTimeObjectProperty.setValue((Object)value);
    }

    public Agenda withDisplayedLocalDateTime(LocalDateTime value) {
        this.setDisplayedLocalDateTime(value);
        return this;
    }

    public ObservableList<Appointment> selectedAppointments() {
        return this.selectedAppointments;
    }

    @Deprecated
    public ObjectProperty<Callback<CalendarRange, Void>> calendarRangeCallbackProperty() {
        return this.calendarRangeCallbackObjectProperty;
    }

    @Deprecated
    public Callback<CalendarRange, Void> getCalendarRangeCallback() {
        return (Callback)this.calendarRangeCallbackObjectProperty.getValue();
    }

    @Deprecated
    public void setCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.calendarRangeCallbackObjectProperty.setValue(value);
    }

    @Deprecated
    public Agenda withCalendarRangeCallback(Callback<CalendarRange, Void> value) {
        this.setCalendarRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, Void>> localDateTimeRangeCallbackProperty() {
        return this.localDateTimeRangeCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, Void> getLocalDateTimeRangeCallback() {
        return (Callback)this.localDateTimeRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.localDateTimeRangeCallbackObjectProperty.setValue(value);
    }

    public Agenda withLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.setLocalDateTimeRangeCallback(value);
        return this;
    }

    @Deprecated
    public ObjectProperty<Callback<CalendarRange, Appointment>> createAppointmentCallbackProperty() {
        return this.createAppointmentCallbackObjectProperty;
    }

    @Deprecated
    public Callback<CalendarRange, Appointment> getCreateAppointmentCallback() {
        return (Callback)this.createAppointmentCallbackObjectProperty.getValue();
    }

    @Deprecated
    public void setCreateAppointmentCallback(Callback<CalendarRange, Appointment> value) {
        this.createAppointmentCallbackObjectProperty.setValue(value);
    }

    @Deprecated
    public Agenda withCreateAppointmentCallback(Callback<CalendarRange, Appointment> value) {
        this.setCreateAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, Appointment>> newAppointmentCallbackProperty() {
        return this.newAppointmentCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, Appointment> getNewAppointmentCallback() {
        return (Callback)this.newAppointmentCallbackObjectProperty.getValue();
    }

    public void setNewAppointmentCallback(Callback<LocalDateTimeRange, Appointment> value) {
        this.newAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withNewAppointmentCallback(Callback<LocalDateTimeRange, Appointment> value) {
        this.setNewAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackProperty() {
        return this.editAppointmentCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getEditAppointmentCallback() {
        return (Callback)this.editAppointmentCallbackObjectProperty.getValue();
    }

    public void setEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.editAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.setEditAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> appointmentChangedCallbackProperty() {
        return this.appointmentChangedCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getAppointmentChangedCallback() {
        return (Callback)this.appointmentChangedCallbackObjectProperty.getValue();
    }

    public void setAppointmentChangedCallback(Callback<Appointment, Void> value) {
        this.appointmentChangedCallbackObjectProperty.setValue(value);
    }

    public Agenda withAppointmentChangedCallback(Callback<Appointment, Void> value) {
        this.setAppointmentChangedCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> actionCallbackProperty() {
        return this.actionCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getActionCallback() {
        return (Callback)this.actionCallbackObjectProperty.getValue();
    }

    public void setActionCallback(Callback<Appointment, Void> value) {
        this.actionCallbackObjectProperty.setValue(value);
    }

    public Agenda withActionCallback(Callback<Appointment, Void> value) {
        this.setActionCallback(value);
        return this;
    }

    public void refresh() {
        ((AgendaSkin)this.getSkin()).refresh();
    }

    public void print(PrinterJob job) {
        ((AgendaSkin)this.getSkin()).print(job);
    }

    public static class AppointmentGroupImpl
    implements AppointmentGroup {
        private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
        private final ObjectProperty<String> styleClassObjectProperty = new SimpleObjectProperty((Object)this, "styleClass");

        public ObjectProperty<String> descriptionProperty() {
            return this.descriptionObjectProperty;
        }

        @Override
        public String getDescription() {
            return (String)this.descriptionObjectProperty.getValue();
        }

        @Override
        public void setDescription(String value) {
            this.descriptionObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withDescription(String value) {
            this.setDescription(value);
            return this;
        }

        public ObjectProperty<String> styleClassProperty() {
            return this.styleClassObjectProperty;
        }

        @Override
        public String getStyleClass() {
            return (String)this.styleClassObjectProperty.getValue();
        }

        @Override
        public void setStyleClass(String value) {
            this.styleClassObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withStyleClass(String value) {
            this.setStyleClass(value);
            return this;
        }
    }

    public static interface AppointmentGroup {
        public String getDescription();

        public void setDescription(String var1);

        public String getStyleClass();

        public void setStyleClass(String var1);
    }

    public static class AppointmentImplTemporal
    extends AppointmentImplBase<AppointmentImplTemporal>
    implements Appointment {
        private final ObjectProperty<Temporal> startTemporalProperty = new SimpleObjectProperty((Object)this, "startTemporal");
        private final ObjectProperty<Temporal> endTemporalProperty = new SimpleObjectProperty((Object)this, "endTemporal");

        public ObjectProperty<Temporal> startTemporal() {
            return this.startTemporalProperty;
        }

        @Override
        public Temporal getStartTemporal() {
            return (Temporal)this.startTemporalProperty.getValue();
        }

        @Override
        public void setStartTemporal(Temporal value) {
            this.startTemporalProperty.setValue((Object)value);
        }

        public AppointmentImplTemporal withStartTemporal(Temporal value) {
            this.setStartTemporal(value);
            return this;
        }

        @Override
        public LocalDateTime getStartLocalDateTime() {
            return TemporalUtilities.toLocalDateTime(this.getStartTemporal());
        }

        @Override
        public void setStartLocalDateTime(LocalDateTime value) {
            Comparable<ChronoLocalDateTime<?>> adjuster = this.isWholeDay() != false ? LocalDate.from(value) : value;
            LocalDateTime start = this.getStartTemporal() == null ? value : TemporalUtilities.combine(this.getStartTemporal(), adjuster);
            this.setStartTemporal(start);
        }

        public AppointmentImplTemporal withStartLocalDateTime(LocalDateTime value) {
            this.setStartLocalDateTime(value);
            return this;
        }

        public ObjectProperty<Temporal> endTemporal() {
            return this.endTemporalProperty;
        }

        @Override
        public Temporal getEndTemporal() {
            return (Temporal)this.endTemporalProperty.getValue();
        }

        @Override
        public void setEndTemporal(Temporal value) {
            this.endTemporalProperty.setValue((Object)value);
        }

        public AppointmentImplTemporal withEndTemporal(Temporal value) {
            this.setEndTemporal(value);
            return this;
        }

        @Override
        public LocalDateTime getEndLocalDateTime() {
            return TemporalUtilities.toLocalDateTime(this.getEndTemporal());
        }

        @Override
        public void setEndLocalDateTime(LocalDateTime value) {
            Comparable<ChronoLocalDateTime<?>> adjuster = this.isWholeDay() != false ? LocalDate.from(value) : value;
            LocalDateTime end = this.getEndTemporal() == null ? value : TemporalUtilities.combine(this.getEndTemporal(), adjuster);
            this.setEndTemporal(end);
        }

        public AppointmentImplTemporal withEndLocalDateTime(LocalDateTime value) {
            this.setEndLocalDateTime(value);
            return this;
        }

        public String toString() {
            return super.toString() + ", " + this.getStartTemporal() + " - " + this.getEndTemporal();
        }
    }

    public static class AppointmentImplLocal
    extends AppointmentImplBase<AppointmentImplLocal>
    implements Appointment {
        private final ObjectProperty<LocalDateTime> startLocalDateTime = new SimpleObjectProperty((Object)this, "startLocalDateTime");
        private final ObjectProperty<LocalDateTime> endLocalDateTimeProperty = new SimpleObjectProperty((Object)this, "endLocalDateTimeProperty");

        public ObjectProperty<LocalDateTime> startLocalDateTime() {
            return this.startLocalDateTime;
        }

        @Override
        public LocalDateTime getStartLocalDateTime() {
            return (LocalDateTime)this.startLocalDateTime.getValue();
        }

        @Override
        public void setStartLocalDateTime(LocalDateTime value) {
            this.startLocalDateTime.setValue((Object)value);
        }

        public AppointmentImplLocal withStartLocalDateTime(LocalDateTime value) {
            this.setStartLocalDateTime(value);
            return this;
        }

        public ObjectProperty<LocalDateTime> endLocalDateTimeProperty() {
            return this.endLocalDateTimeProperty;
        }

        @Override
        public LocalDateTime getEndLocalDateTime() {
            return (LocalDateTime)this.endLocalDateTimeProperty.getValue();
        }

        @Override
        public void setEndLocalDateTime(LocalDateTime value) {
            this.endLocalDateTimeProperty.setValue((Object)value);
        }

        public AppointmentImplLocal withEndLocalDateTime(LocalDateTime value) {
            this.setEndLocalDateTime(value);
            return this;
        }

        public String toString() {
            return super.toString() + ", " + this.getStartLocalDateTime() + " - " + this.getEndLocalDateTime();
        }
    }

    public static class AppointmentImpl
    extends AppointmentImplBase<AppointmentImpl>
    implements Appointment {
        private final ObjectProperty<Calendar> startTimeObjectProperty = new SimpleObjectProperty((Object)this, "startTime");
        private final ObjectProperty<Calendar> endTimeObjectProperty = new SimpleObjectProperty((Object)this, "endTime");

        public ObjectProperty<Calendar> startTimeProperty() {
            return this.startTimeObjectProperty;
        }

        @Override
        public Calendar getStartTime() {
            return (Calendar)this.startTimeObjectProperty.getValue();
        }

        @Override
        public void setStartTime(Calendar value) {
            this.startTimeObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withStartTime(Calendar value) {
            this.setStartTime(value);
            return this;
        }

        public ObjectProperty<Calendar> endTimeProperty() {
            return this.endTimeObjectProperty;
        }

        @Override
        public Calendar getEndTime() {
            return (Calendar)this.endTimeObjectProperty.getValue();
        }

        @Override
        public void setEndTime(Calendar value) {
            this.endTimeObjectProperty.setValue((Object)value);
        }

        public AppointmentImpl withEndTime(Calendar value) {
            this.setEndTime(value);
            return this;
        }

        public String toString() {
            return super.toString() + ", " + DateTimeToCalendarHelper.quickFormatCalendar(this.getStartTime()) + " - " + DateTimeToCalendarHelper.quickFormatCalendar(this.getEndTime());
        }
    }

    public static abstract class AppointmentImplBase<T>
    implements Appointment {
        private final ObjectProperty<Boolean> wholeDayObjectProperty = new SimpleObjectProperty((Object)this, "wholeDay", (Object)false);
        private final ObjectProperty<String> summaryObjectProperty = new SimpleObjectProperty((Object)this, "summary");
        private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
        private final ObjectProperty<String> locationObjectProperty = new SimpleObjectProperty((Object)this, "location");
        private final ObjectProperty<AppointmentGroup> appointmentGroupObjectProperty = new SimpleObjectProperty((Object)this, "appointmentGroup");

        public ObjectProperty<Boolean> wholeDayProperty() {
            return this.wholeDayObjectProperty;
        }

        @Override
        public Boolean isWholeDay() {
            return (Boolean)this.wholeDayObjectProperty.getValue();
        }

        @Override
        public void setWholeDay(Boolean value) {
            this.wholeDayObjectProperty.setValue((Object)value);
        }

        public T withWholeDay(Boolean value) {
            this.setWholeDay(value);
            return (T)this;
        }

        public ObjectProperty<String> summaryProperty() {
            return this.summaryObjectProperty;
        }

        @Override
        public String getSummary() {
            return (String)this.summaryObjectProperty.getValue();
        }

        @Override
        public void setSummary(String value) {
            this.summaryObjectProperty.setValue((Object)value);
        }

        public T withSummary(String value) {
            this.setSummary(value);
            return (T)this;
        }

        public ObjectProperty<String> descriptionProperty() {
            return this.descriptionObjectProperty;
        }

        @Override
        public String getDescription() {
            return (String)this.descriptionObjectProperty.getValue();
        }

        @Override
        public void setDescription(String value) {
            this.descriptionObjectProperty.setValue((Object)value);
        }

        public T withDescription(String value) {
            this.setDescription(value);
            return (T)this;
        }

        public ObjectProperty<String> locationProperty() {
            return this.locationObjectProperty;
        }

        @Override
        public String getLocation() {
            return (String)this.locationObjectProperty.getValue();
        }

        @Override
        public void setLocation(String value) {
            this.locationObjectProperty.setValue((Object)value);
        }

        public T withLocation(String value) {
            this.setLocation(value);
            return (T)this;
        }

        public ObjectProperty<AppointmentGroup> appointmentGroupProperty() {
            return this.appointmentGroupObjectProperty;
        }

        @Override
        public AppointmentGroup getAppointmentGroup() {
            return (AppointmentGroup)this.appointmentGroupObjectProperty.getValue();
        }

        @Override
        public void setAppointmentGroup(AppointmentGroup value) {
            this.appointmentGroupObjectProperty.setValue((Object)value);
        }

        public T withAppointmentGroup(AppointmentGroup value) {
            this.setAppointmentGroup(value);
            return (T)this;
        }
    }

    public static interface Appointment {
        public Boolean isWholeDay();

        public void setWholeDay(Boolean var1);

        public String getSummary();

        public void setSummary(String var1);

        public String getDescription();

        public void setDescription(String var1);

        public String getLocation();

        public void setLocation(String var1);

        public AppointmentGroup getAppointmentGroup();

        public void setAppointmentGroup(AppointmentGroup var1);

        default public Calendar getStartTime() {
            throw new RuntimeException("Not implemented");
        }

        default public void setStartTime(Calendar c) {
            throw new RuntimeException("Not implemented");
        }

        default public Calendar getEndTime() {
            throw new RuntimeException("Not implemented");
        }

        default public void setEndTime(Calendar c) {
            throw new RuntimeException("Not implemented");
        }

        default public Temporal getStartTemporal() {
            return this.getStartLocalDateTime();
        }

        default public void setStartTemporal(Temporal t) {
            this.setStartLocalDateTime(LocalDateTime.from(t));
        }

        default public Temporal getEndTemporal() {
            return this.getEndLocalDateTime();
        }

        default public void setEndTemporal(Temporal t) {
            this.setEndLocalDateTime(LocalDateTime.from(t));
        }

        default public LocalDateTime getStartLocalDateTime() {
            return LocalDateTime.ofInstant(this.getStartTime().toInstant(), ZoneId.systemDefault());
        }

        default public void setStartLocalDateTime(LocalDateTime v) {
            this.setStartTime(GregorianCalendar.from(v.atZone(ZoneId.systemDefault())));
        }

        default public LocalDateTime getEndLocalDateTime() {
            return this.getEndTime() == null ? null : LocalDateTime.ofInstant(this.getEndTime().toInstant(), ZoneId.systemDefault());
        }

        default public void setEndLocalDateTime(LocalDateTime v) {
            this.setEndTime(GregorianCalendar.from(v.atZone(ZoneId.systemDefault())));
        }
    }

    public static class LocalDateTimeRange {
        final LocalDateTime start;
        final LocalDateTime end;

        public LocalDateTimeRange(LocalDateTime start, LocalDateTime end) {
            this.start = start;
            this.end = end;
        }

        public LocalDateTime getStartLocalDateTime() {
            return this.start;
        }

        public LocalDateTime getEndLocalDateTime() {
            return this.end;
        }

        public String toString() {
            return super.toString() + " " + this.start + " to " + this.end;
        }
    }

    @Deprecated
    public static class CalendarRange {
        final Calendar start;
        final Calendar end;

        public CalendarRange(Calendar start, Calendar end) {
            this.start = start;
            this.end = end;
        }

        public Calendar getStartCalendar() {
            return this.start;
        }

        public Calendar getEndCalendar() {
            return this.end;
        }
    }
}

