/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahDate;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.HashMap;
import java.util.Map;

public final class TemporalUtilities {
    private TemporalUtilities() {
    }

    public static Temporal combine(Temporal initialTemporal, TemporalAdjuster adjuster) {
        return TemporalType.from(initialTemporal.getClass()).combineByType(initialTemporal, adjuster);
    }

    public static LocalDateTime toLocalDateTime(Temporal temporal) {
        return TemporalType.from(temporal.getClass()).toLocalDateTimeByType(temporal);
    }

    public static enum TemporalType {
        HIJRAH_DATE(HijrahDate.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDate.from(t).atStartOfDay();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return TemporalType.combineDateBased(initialTemporal, adjuster);
            }
        }
        ,
        INSTANT(Instant.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDateTime.ofInstant(Instant.from(t), ZoneId.systemDefault());
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return initialTemporal.with(adjuster);
            }
        }
        ,
        JAPANESE_DATE(JapaneseDate.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDate.from(t).atStartOfDay();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return TemporalType.combineDateBased(initialTemporal, adjuster);
            }
        }
        ,
        LOCAL_DATE(LocalDate.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDate.from(t).atStartOfDay();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return TemporalType.combineDateBased(initialTemporal, adjuster);
            }
        }
        ,
        LOCAL_DATE_TIME(LocalDateTime.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDateTime.from(t);
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return initialTemporal.with(adjuster);
            }
        }
        ,
        MINGUO_DATE(MinguoDate.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDate.from(t).atStartOfDay();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return TemporalType.combineDateBased(initialTemporal, adjuster);
            }
        }
        ,
        OFFSET_DATE_TIME(OffsetDateTime.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                ZoneOffset o = ZonedDateTime.now().getOffset();
                return OffsetDateTime.from(t).withOffsetSameInstant(o).toLocalDateTime();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return initialTemporal.with(adjuster);
            }
        }
        ,
        THAI_BUDDHIST_DATE(ThaiBuddhistDate.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return LocalDate.from(t).atStartOfDay();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return TemporalType.combineDateBased(initialTemporal, adjuster);
            }
        }
        ,
        ZONED_DATE_TIME(ZonedDateTime.class){

            @Override
            protected LocalDateTime toLocalDateTimeByType(Temporal t) {
                return ZonedDateTime.from(t).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
            }

            @Override
            protected Temporal combineByType(Temporal initialTemporal, TemporalAdjuster adjuster) {
                return initialTemporal.with(adjuster);
            }
        };

        private static Map<Class<? extends Temporal>, TemporalType> temporalClassToTemporalTypeMap;
        private Class<? extends Temporal> clazz;

        private static Map<Class<? extends Temporal>, TemporalType> makeMap() {
            HashMap<Class<? extends Temporal>, TemporalType> map = new HashMap<Class<? extends Temporal>, TemporalType>();
            TemporalType[] values = TemporalType.values();
            for (int i = 0; i < values.length; ++i) {
                map.put(values[i].clazz, values[i]);
            }
            return map;
        }

        public static TemporalType from(Class<? extends Temporal> clazz) {
            return temporalClassToTemporalTypeMap.get(clazz);
        }

        private static Temporal combineDateBased(Temporal initialTemporal, TemporalAdjuster adjuster) {
            if (adjuster instanceof LocalDate) {
                return initialTemporal.with(adjuster);
            }
            if (adjuster instanceof LocalDateTime) {
                return (LocalDateTime)adjuster;
            }
            throw new DateTimeException("Unsupported TemporalAdjuster:" + adjuster);
        }

        public Class<? extends Temporal> getTemporalClass() {
            return this.clazz;
        }

        private TemporalType(Class<? extends Temporal> clazz) {
            this.clazz = clazz;
        }

        protected abstract LocalDateTime toLocalDateTimeByType(Temporal var1);

        protected abstract Temporal combineByType(Temporal var1, TemporalAdjuster var2);

        static {
            temporalClassToTemporalTypeMap = TemporalType.makeMap();
        }
    }
}

