/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.editors.deleters;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.util.Callback;
import javafx.util.Pair;
import jfxtras.icalendarfx.VCalendar;
import jfxtras.icalendarfx.VChild;
import jfxtras.icalendarfx.components.VDisplayable;
import jfxtras.icalendarfx.parameters.Range;
import jfxtras.icalendarfx.properties.component.descriptive.Status;
import jfxtras.icalendarfx.properties.component.recurrence.RecurrenceRule;
import jfxtras.icalendarfx.properties.component.relationship.RecurrenceId;
import jfxtras.scene.control.agenda.icalendar.editors.ChangeDialogOption;
import jfxtras.scene.control.agenda.icalendar.editors.deleters.Deleter;

public abstract class DeleterDisplayable<T, U extends VDisplayable<?>>
implements Deleter {
    private U vComponent;
    private Temporal startOriginalRecurrence;
    private Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback;

    public DeleterDisplayable(U vComponent) {
        this.vComponent = vComponent;
    }

    public U getVComponentCopy() {
        return this.vComponent;
    }

    public void setVComponentCopy(U vComponentEdited) {
        this.vComponent = vComponentEdited;
    }

    public T withVComponentCopy(U vComponentEdited) {
        this.setVComponentCopy(vComponentEdited);
        return (T)this;
    }

    public Temporal getStartOriginalRecurrence() {
        return this.startOriginalRecurrence;
    }

    public void setStartOriginalRecurrence(Temporal startOriginalRecurrence) {
        this.startOriginalRecurrence = startOriginalRecurrence;
    }

    public T withStartOriginalRecurrence(Temporal startOriginalRecurrence) {
        this.setStartOriginalRecurrence(startOriginalRecurrence);
        return (T)this;
    }

    public Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> getDialogCallback() {
        return this.dialogCallback;
    }

    public void setDialogCallback(Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback) {
        this.dialogCallback = dialogCallback;
    }

    public T withDialogCallback(Callback<Map<ChangeDialogOption, Pair<Temporal, Temporal>>, ChangeDialogOption> dialogCallback) {
        this.setDialogCallback(dialogCallback);
        return (T)this;
    }

    private boolean isValid() {
        if (this.getDialogCallback() == null) {
            System.out.println("dialogCallback must not be null");
            return false;
        }
        return true;
    }

    @Override
    public List<VCalendar> delete() {
        boolean hasRRule;
        if (!this.isValid()) {
            throw new RuntimeException("Invalid parameters for component revision:");
        }
        U vComponent = this.getVComponentCopy();
        ArrayList<VCalendar> itipMessages = new ArrayList<VCalendar>();
        boolean bl = hasRRule = ((VDisplayable)vComponent).getRecurrenceRule() != null;
        if (hasRRule) {
            Map<ChangeDialogOption, Pair<Temporal, Temporal>> choices = ChangeDialogOption.makeDialogChoices(vComponent, this.startOriginalRecurrence);
            ChangeDialogOption changeResponse = (ChangeDialogOption)((Object)this.dialogCallback.call(choices));
            switch (changeResponse) {
                case ALL: {
                    VCalendar cancelMessage = this.setUpCancelMessage(vComponent);
                    itipMessages.add(cancelMessage);
                    break;
                }
                case CANCEL: {
                    break;
                }
                case ONE: {
                    VCalendar cancelMessage = this.setUpCancelMessage(vComponent);
                    ((VDisplayable)vComponent).setRecurrenceId(this.getStartOriginalRecurrence());
                    ((VDisplayable)vComponent).setRecurrenceRule((RecurrenceRule)null);
                    itipMessages.add(cancelMessage);
                    break;
                }
                case THIS_AND_FUTURE: {
                    VCalendar cancelMessage = this.setUpCancelMessage(vComponent);
                    ((VDisplayable)vComponent).setRecurrenceId(new RecurrenceId(this.getStartOriginalRecurrence()).withRange(Range.RangeType.THIS_AND_FUTURE));
                    itipMessages.add(cancelMessage);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupprted response:" + changeResponse);
                }
            }
        } else {
            VCalendar cancelMessage = this.setUpCancelMessage(vComponent);
            itipMessages.add(cancelMessage);
        }
        return itipMessages;
    }

    private VCalendar setUpCancelMessage(U vComponent) {
        VCalendar cancelMessage = Deleter.emptyCanceliTIPMessage();
        ((VDisplayable)vComponent).setStatus(Status.StatusType.CANCELLED);
        ((VDisplayable)vComponent).setRecurrenceRule((RecurrenceRule)null);
        ((VDisplayable)vComponent).eraseDateTimeProperties();
        cancelMessage.addChild((VChild)vComponent);
        return cancelMessage;
    }
}

