/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.editors.revisors;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.List;
import jfxtras.icalendarfx.components.VLocatable;
import jfxtras.icalendarfx.components.VPrimary;
import jfxtras.icalendarfx.properties.VPropertyElement;
import jfxtras.icalendarfx.properties.component.time.DateTimeStart;
import jfxtras.icalendarfx.utilities.DateTimeUtilities;
import jfxtras.scene.control.agenda.icalendar.editors.revisors.ReviserDisplayable;

public abstract class ReviserLocatable<T, U extends VLocatable<U>>
extends ReviserDisplayable<T, U> {
    private Temporal endRecurrence;

    public ReviserLocatable(U component) {
        super(component);
    }

    public Temporal getEndRecurrence() {
        return this.endRecurrence;
    }

    public void setEndRecurrence(Temporal startRecurrence) {
        this.endRecurrence = startRecurrence;
    }

    public T withEndRecurrence(Temporal endRecurrence) {
        this.setEndRecurrence(endRecurrence);
        return (T)this;
    }

    @Override
    boolean isValid() {
        if (this.getEndRecurrence() == null) {
            return false;
        }
        return super.isValid();
    }

    @Override
    void adjustStartAndEnd(U vComponentEditedCopy, U vComponentOriginalCopy) {
        ((VPrimary)vComponentEditedCopy).setDateTimeStart(new DateTimeStart(this.getStartRecurrence()));
        ((VLocatable)vComponentEditedCopy).setEndOrDuration(this.getStartRecurrence(), this.getEndRecurrence());
    }

    @Override
    void becomeNonRecurring(U vComponentEditedCopy) {
        super.becomeNonRecurring(vComponentEditedCopy);
        if (((VLocatable)this.getVComponentOriginal()).getRecurrenceRule() != null) {
            ((VLocatable)this.getVComponentCopyEdited()).setDateTimeStart(new DateTimeStart(this.getStartRecurrence()));
            if (((VLocatable)this.getVComponentCopyEdited()).getDuration() != null) {
                TemporalAmount duration = DateTimeUtilities.temporalAmountBetween(this.getStartRecurrence(), this.getEndRecurrence());
                ((VLocatable)this.getVComponentCopyEdited()).setDuration(duration);
            }
        }
    }

    @Override
    public List<VPropertyElement> dialogRequiredProperties() {
        List<VPropertyElement> list = super.dialogRequiredProperties();
        list.add(VPropertyElement.DATE_TIME_END);
        return list;
    }
}

