/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.control.agenda.icalendar.factories;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import jfxtras.icalendarfx.components.VDisplayable;

public abstract class RecurrenceFactory<R> {
    private ObjectProperty<LocalDateTime> startRange = new SimpleObjectProperty();
    private ObjectProperty<LocalDateTime> endRange = new SimpleObjectProperty();

    public ObjectProperty<LocalDateTime> startRangeProperty() {
        return this.startRange;
    }

    public void setStartRange(LocalDateTime startRange) {
        this.startRange.set((Object)startRange);
    }

    public LocalDateTime getStartRange() {
        return (LocalDateTime)this.startRange.get();
    }

    public ObjectProperty<LocalDateTime> endRangeProperty() {
        return this.endRange;
    }

    public void setEndRange(LocalDateTime endRange) {
        this.endRange.set((Object)endRange);
    }

    public LocalDateTime getEndRange() {
        return (LocalDateTime)this.endRange.get();
    }

    public List<R> makeRecurrences(VDisplayable<?> vComponent) {
        Temporal endRange2;
        Temporal startRange2;
        if (this.getStartRange() == null || this.getEndRange() == null) {
            throw new DateTimeException("Both startRange and endRange MUST NOT be null (" + this.startRange + ", " + this.endRange + ")");
        }
        ArrayList newRecurrences = new ArrayList();
        Boolean isWholeDay = vComponent.getDateTimeStart().getValue() instanceof LocalDate;
        if (isWholeDay.booleanValue()) {
            startRange2 = LocalDate.from(this.getStartRange());
            endRange2 = LocalDate.from(this.getEndRange());
        } else {
            startRange2 = ((Temporal)vComponent.getDateTimeStart().getValue()).with(this.getStartRange());
            endRange2 = ((Temporal)vComponent.getDateTimeStart().getValue()).with(this.getEndRange());
        }
        Stream<Temporal> streamRecurrences = vComponent.streamRecurrences(startRange2, endRange2);
        streamRecurrences.forEach(startTemporal -> {
            R recurrence = this.makeRecurrence(vComponent, (Temporal)startTemporal);
            newRecurrences.add(recurrence);
        });
        return newRecurrences;
    }

    abstract R makeRecurrence(VDisplayable<?> var1, Temporal var2);
}

