/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.json;

import com.sun.javafx.data.json.JSONScanner;
import com.sun.javafx.data.json.JSONSymbol;
import com.sun.javafx.data.pull.impl.Position;
import com.sun.javafx.data.pull.impl.StreamException;
import com.sun.javafx.data.pull.impl.StreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public class JSONStreamReaderImpl
implements StreamReader {
    private JSONScanner scanner;
    private JSONSymbol currentSymbol;
    private String encoding;
    private String key;
    private Stack<String> stack = new Stack();
    private boolean eod = false;

    public JSONStreamReaderImpl(InputStream stream, String encoding) throws StreamException {
        this.encoding = encoding;
        this.currentSymbol = JSONSymbol.EOS;
        try {
            this.scanner = new JSONScanner(stream, encoding);
            JSONSymbol.init(this.scanner);
        }
        catch (IOException e) {
            throw new StreamException(e.toString());
        }
    }

    public int next() throws StreamException {
        boolean found = false;
        if (this.eod) {
            return 8;
        }
        while (!found) {
            try {
                this.currentSymbol = JSONSymbol.next();
            }
            catch (IOException e) {
                throw new StreamException(e.toString());
            }
            switch (this.currentSymbol) {
                case O: {
                    this.key = "";
                    return 1;
                }
                case O_: {
                    this.key = "";
                    return 2;
                }
                case OV: {
                    if (this.next() == 4) {
                        this.key = JSONSymbol.getValue();
                    }
                    this.stack.push(this.key);
                    return 25;
                }
                case OV_: {
                    this.key = this.stack.pop();
                    return 26;
                }
                case X: {
                    this.stack.removeAllElements();
                    return 7;
                }
                case X_: {
                    this.eod = true;
                    this.stack.removeAllElements();
                }
                case EOS: {
                    if (!this.eod) {
                        throw new StreamException("Unexpected end of stream");
                    }
                    return 8;
                }
                case KEYWORD: {
                    String s = this.getText();
                    if (s.equals("true")) {
                        return 22;
                    }
                    if (s.equals("false")) {
                        return 23;
                    }
                    if (s.equals("null")) {
                        return 24;
                    }
                    return 0;
                }
                case STRING: {
                    return 4;
                }
                case NUMBER: {
                    if (this.scanner.isInteger()) {
                        return 21;
                    }
                    return 20;
                }
                case A: {
                    return 16;
                }
                case A_: {
                    return 19;
                }
                case VA: {
                    return 17;
                }
                case VA_: {
                    return 18;
                }
            }
            found = false;
        }
        return 0;
    }

    public boolean hasNext() throws StreamException {
        return this.currentSymbol != JSONSymbol.X_;
    }

    public int getAttributeCount() {
        return 0;
    }

    public String getAttributeNamespace(int index) {
        return null;
    }

    public String getAttributeLocalName(int index) {
        return null;
    }

    public String getAttributePrefix(int index) {
        return null;
    }

    public String getAttributeType(int index) {
        return null;
    }

    public String getAttributeValue(int index) {
        return null;
    }

    public int getNamespaceCount() {
        return 0;
    }

    public String getNamespacePrefix(int index) {
        return null;
    }

    public String getNamespaceURI(int index) {
        return null;
    }

    public String getText() {
        return JSONSymbol.getValue();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Position getLocation() {
        return this.scanner;
    }

    public String getLocalName() {
        return this.key;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    public void clearSkippedElements() {
    }

    public void addSkippedElement(String name, String namespace) {
    }
}

