/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.json;

import com.sun.javafx.data.json.JSONScanner;
import com.sun.javafx.data.pull.impl.StreamException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JSONSymbol {
    X,
    O,
    O1,
    O3,
    OV,
    A,
    A1,
    A2,
    V,
    VA,
    CURLYOPEN,
    CURLYCLOSE,
    COLON,
    COMMA,
    SQUAREOPEN,
    SQUARECLOSE,
    KEYWORD,
    STRING,
    NUMBER,
    EOS,
    X_,
    O_,
    O1_,
    O3_,
    OV_,
    A_,
    A1_,
    A2_,
    V_,
    VA_;

    static final boolean DEBUG = false;
    boolean isTerminal = true;
    boolean isMarker = false;
    HashMap<JSONSymbol, JSONSymbol[]> transitions;
    JSONSymbol markerSymbol;
    private static Stack<JSONSymbol> stack;
    private static JSONSymbol terminal;
    private static JSONSymbol current;
    private static JSONScanner scanner;
    private static String value;

    private void transition(JSONSymbol s, JSONSymbol[] sequence) {
        if (this.isTerminal) {
            this.isTerminal = false;
            this.transitions = new HashMap();
        }
        this.transitions.put(s, sequence);
    }

    private void marker(JSONSymbol s) {
        this.markerSymbol = s;
        s.isMarker = true;
    }

    static void init(JSONScanner js) throws StreamException, IOException {
        scanner = js;
        stack = new Stack();
        stack.push(X);
        terminal = scanner.nextSymbol();
    }

    static JSONSymbol next() throws StreamException, IOException {
        current = stack.pop();
        if (JSONSymbol.current.isMarker) {
            if (current == X_) {
                return current;
            }
        } else if (JSONSymbol.current.isTerminal) {
            if (current != terminal) {
                throw new StreamException("Expected " + (Object)((Object)current) + " but found " + (Object)((Object)terminal), scanner.getLocation());
            }
            value = scanner.getValue();
            terminal = scanner.nextSymbol();
        } else {
            JSONSymbol[] target = JSONSymbol.current.transitions.get((Object)terminal);
            if (target == null) {
                throw new StreamException("Unexpected " + (Object)((Object)terminal) + " while parsing " + (Object)((Object)current), scanner.getLocation());
            }
            stack.push(JSONSymbol.current.markerSymbol);
            int i = target.length;
            while (--i >= 0) {
                JSONSymbol s = target[i];
                stack.push(s);
            }
        }
        return current;
    }

    static String getValue() {
        return value;
    }

    static {
        JSONSymbol[] epsilon = new JSONSymbol[]{};
        X.transition(CURLYOPEN, new JSONSymbol[]{O});
        X.transition(SQUAREOPEN, new JSONSymbol[]{A});
        O.transition(CURLYOPEN, new JSONSymbol[]{CURLYOPEN, O1, CURLYCLOSE});
        O1.transition(CURLYCLOSE, epsilon);
        O1.transition(STRING, new JSONSymbol[]{OV, O3});
        O3.transition(CURLYCLOSE, epsilon);
        O3.transition(COMMA, new JSONSymbol[]{COMMA, OV, O3});
        OV.transition(STRING, new JSONSymbol[]{STRING, COLON, V});
        A.transition(SQUAREOPEN, new JSONSymbol[]{SQUAREOPEN, A1, SQUARECLOSE});
        A1.transition(CURLYOPEN, new JSONSymbol[]{VA, A2});
        A1.transition(SQUAREOPEN, new JSONSymbol[]{VA, A2});
        A1.transition(SQUARECLOSE, epsilon);
        A1.transition(KEYWORD, new JSONSymbol[]{VA, A2});
        A1.transition(STRING, new JSONSymbol[]{VA, A2});
        A1.transition(NUMBER, new JSONSymbol[]{VA, A2});
        A2.transition(COMMA, new JSONSymbol[]{COMMA, VA, A2});
        A2.transition(SQUARECLOSE, epsilon);
        VA.transition(CURLYOPEN, new JSONSymbol[]{V});
        VA.transition(SQUAREOPEN, new JSONSymbol[]{V});
        VA.transition(STRING, new JSONSymbol[]{V});
        VA.transition(NUMBER, new JSONSymbol[]{V});
        VA.transition(KEYWORD, new JSONSymbol[]{V});
        V.transition(CURLYOPEN, new JSONSymbol[]{O});
        V.transition(SQUAREOPEN, new JSONSymbol[]{A});
        V.transition(KEYWORD, new JSONSymbol[]{KEYWORD});
        V.transition(STRING, new JSONSymbol[]{STRING});
        V.transition(NUMBER, new JSONSymbol[]{NUMBER});
        X.marker(X_);
        O.marker(O_);
        O1.marker(O1_);
        O3.marker(O3_);
        OV.marker(OV_);
        A.marker(A_);
        A1.marker(A1_);
        A2.marker(A2_);
        VA.marker(VA_);
        V.marker(V_);
    }
}

