/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderUTF16
extends Reader {
    private InputStream is;
    private char bo;
    private byte[] buff;
    private int bidx = 0;
    private int bcnt = 0;

    public ReaderUTF16(InputStream is, char bo) {
        switch (bo) {
            case 'l': {
                break;
            }
            case 'b': {
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.bo = bo;
        this.is = is;
        this.buff = new byte[128];
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int num;
        if (this.bo == 'b') {
            for (num = 0; num < len; ++num) {
                if (this.bidx >= this.bcnt) {
                    this.bcnt = this.is.read(this.buff, 0, this.buff.length);
                    if (this.bcnt < 0) {
                        return num != 0 ? num : -1;
                    }
                    this.bidx = 0;
                }
                cbuf[off++] = (char)(this.buff[this.bidx++] << 8 | this.getch() & 0xFF);
            }
        } else {
            while (num < len) {
                if (this.bidx >= this.bcnt) {
                    this.bcnt = this.is.read(this.buff, 0, this.buff.length);
                    if (this.bcnt < 0) {
                        return num != 0 ? num : -1;
                    }
                    this.bidx = 0;
                }
                cbuf[off++] = (char)(this.buff[this.bidx++] & 0xFF | this.getch() << 8);
                ++num;
            }
        }
        return num;
    }

    public int read() throws IOException {
        int val = this.is.read();
        if (val < 0) {
            return -1;
        }
        val = this.bo == 'b' ? (int)((char)(val << 8 | this.is.read() & 0xFF)) : (int)((char)(this.is.read() << 8 | val & 0xFF));
        return val;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private char getch() throws IOException {
        if (this.bidx >= this.bcnt) {
            this.bcnt = this.is.read(this.buff, 0, this.buff.length);
            if (this.bcnt <= 0) {
                throw new EOFException();
            }
            this.bidx = 0;
        }
        return (char)this.buff[this.bidx++];
    }
}

