/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class ReaderUTF8
extends Reader {
    private InputStream is;
    private byte[] buff;
    private int bidx = 0;
    private int bcnt = 0;

    public ReaderUTF8(InputStream is) {
        this.is = is;
        this.buff = new byte[64];
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int num;
        block5: for (num = 0; num < len; ++num) {
            char val;
            if (this.bidx >= this.bcnt) {
                this.bcnt = this.is.read(this.buff, 0, this.buff.length);
                if (this.bcnt < 0) {
                    return num != 0 ? num : -1;
                }
                this.bidx = 0;
            }
            if ((val = (char)this.buff[this.bidx++]) <= '\u007f') {
                cbuf[off++] = val;
                continue;
            }
            switch (val & 0xF0) {
                case 192: 
                case 208: {
                    cbuf[off++] = (char)((val & 0x1F) << 6 | this.getch() & 0x3F);
                    continue block5;
                }
                case 224: {
                    cbuf[off++] = (char)((val & 0xF) << 12 | (this.getch() & 0x3F) << 6 | this.getch() & 0x3F);
                    continue block5;
                }
                case 240: {
                    throw new UnsupportedEncodingException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return num;
    }

    public int read() throws IOException {
        int val = this.is.read();
        if (val < 0) {
            return -1;
        }
        if (val > 127) {
            switch (val & 0xF0) {
                case 192: 
                case 208: {
                    val = (val & 0x1F) << 6 | this.is.read() & 0x3F;
                    break;
                }
                case 224: {
                    val = (val & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F;
                    break;
                }
                case 240: {
                    throw new UnsupportedEncodingException();
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return val;
    }

    public void close() throws IOException {
        this.is.close();
    }

    private char getch() throws IOException {
        if (this.bidx >= this.bcnt) {
            this.bcnt = this.is.read(this.buff, 0, this.buff.length);
            if (this.bcnt <= 0) {
                throw new EOFException();
            }
            this.bidx = 0;
        }
        return (char)this.buff[this.bidx++];
    }
}

