/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.xml;

import com.sun.javafx.data.pull.impl.InputSource;
import com.sun.javafx.data.pull.ukit.io.ReaderUTF16;
import com.sun.javafx.data.pull.ukit.io.ReaderUTF8;
import com.sun.javafx.data.pull.ukit.xml.Attrs;
import com.sun.javafx.data.pull.ukit.xml.Input;
import com.sun.javafx.data.pull.ukit.xml.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public abstract class Parser {
    public static final String FAULT = "Syntax Error";
    protected static final int BUFFSIZE_READER = 512;
    protected static final int BUFFSIZE_PARSER = 128;
    public static final char EOS = '\uffff';
    private Pair mNoNS;
    private Pair mXml;
    private Hashtable mEnt;
    private Hashtable mPEnt;
    protected boolean mIsSAlone;
    protected boolean mIsSAloneSet;
    protected boolean mIsNSAware;
    protected boolean mIsDOM;
    protected int mPh = -1;
    protected static final int PH_BEFORE_DOC = -1;
    protected static final int PH_DOC_START = 0;
    protected static final int PH_MISC_DTD = 1;
    protected static final int PH_DTD = 2;
    protected static final int PH_DTD_MISC = 3;
    protected static final int PH_DOCELM = 4;
    protected static final int PH_DOCELM_MISC = 5;
    protected static final int PH_AFTER_DOC = 6;
    protected int mEvt;
    protected static final int EV_NULL = 0;
    protected static final int EV_ELM = 1;
    protected static final int EV_ELMS = 2;
    protected static final int EV_ELME = 3;
    protected static final int EV_TEXT = 4;
    protected static final int EV_WSPC = 5;
    protected static final int EV_PI = 6;
    protected static final int EV_CDAT = 7;
    protected static final int EV_COMM = 8;
    protected static final int EV_DTDS = 9;
    protected static final int EV_DTDE = 10;
    protected static final int EV_ENT = 11;
    protected static final int EV_PENT = 12;
    protected static final int EV_UENT = 13;
    protected static final int EV_NOT = 14;
    public static final int FLAG_NSAWARE = 1;
    public static final int FLAG_XMLSPC_PRESERVE = 2;
    protected static final String XMLSPC_PRESERVE = "preserve";
    private static final String UCS4_CHAR = "#";
    private char mESt;
    protected char[] mBuff;
    protected int mBuffIdx;
    protected Pair mPref;
    protected Pair mElm;
    protected Pair mAttL;
    protected Input mDoc;
    protected Input mInp;
    private Pair mPSid;
    private char[] mChars;
    private int mChLen;
    private int mChIdx;
    protected Attrs mAttrs;
    private String mUnent;
    private int mIent;
    private Pair mDltd;
    protected static final char[] NONS;
    protected static final char[] XML;
    protected static final char[] XMLNS;
    protected static final char[] XMLSPC;
    protected static final char[] XMLID;
    private static final byte[] asctyp;
    private static final byte[] nmttyp;
    protected int x = 0;
    protected int y = 1;
    protected boolean skipPositionUpdate = false;
    private List<QualifiedName> skippedElements = new LinkedList<QualifiedName>();

    protected Parser() {
        this.mBuff = new char[128];
        this.mAttrs = new Attrs();
        this.mPref = this.pair(this.mPref);
        this.mPref.name = "";
        this.mPref.value = "";
        this.mPref.chars = NONS;
        this.mNoNS = this.mPref;
        this.mPref = this.pair(this.mPref);
        this.mPref.name = "xml";
        this.mPref.value = "http://www.w3.org/XML/1998/namespace";
        this.mPref.chars = XML;
        this.mXml = this.mPref;
    }

    protected void init() {
        this.mUnent = null;
        this.mElm = null;
        this.mPref = this.mXml;
        this.mAttL = null;
        this.mPEnt = new Hashtable();
        this.mEnt = new Hashtable();
        this.mDoc = this.mInp;
        this.mChars = this.mInp.chars;
        this.mPh = 0;
    }

    protected void cleanup() {
        while (this.mAttL != null) {
            while (this.mAttL.list != null) {
                if (this.mAttL.list.list != null) {
                    this.del(this.mAttL.list.list);
                }
                this.mAttL.list = this.del(this.mAttL.list);
            }
            this.mAttL = this.del(this.mAttL);
        }
        while (this.mElm != null) {
            this.mElm = this.del(this.mElm);
        }
        while (this.mPref != this.mXml) {
            this.mPref = this.del(this.mPref);
        }
        while (this.mInp != null) {
            this.pop();
        }
        if (this.mDoc != null && this.mDoc.src != null) {
            try {
                this.mDoc.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mPEnt = null;
        this.mEnt = null;
        this.mDoc = null;
        this.mPh = 6;
    }

    private void skipEntity(String s) throws Exception {
        this.bappend('&');
        for (int index = 0; index < this.mUnent.length(); ++index) {
            this.bappend(this.mUnent.charAt(index));
        }
        this.bappend(';');
        this.bflash();
    }

    protected int step() throws Exception {
        int st;
        this.mEvt = 0;
        int n = st = this.mPh == 4 ? 0 : 4;
        block55: while (this.mEvt == 0) {
            char ch = this.getNextCh();
            block2 : switch (st) {
                case 0: {
                    if (ch != '<') {
                        this.bkch();
                        this.mBuffIdx = -1;
                        st = 1;
                        break;
                    }
                    switch (this.getch()) {
                        case '/': {
                            this.mEvt = 3;
                            if (this.mElm == null) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = -1;
                            this.bname(this.mIsNSAware);
                            char[] chars = this.mElm.chars;
                            if (chars.length != this.mBuffIdx + 1) {
                                this.panic(FAULT);
                            }
                            for (int i = 1; i <= this.mBuffIdx; i = (int)((char)(i + 1))) {
                                if (chars[i] == this.mBuff[i]) continue;
                                this.panic(FAULT);
                            }
                            if (this.wsskip() != '>') {
                                this.panic(FAULT);
                            }
                            this.getch();
                            break block2;
                        }
                        case '!': {
                            ch = this.getch();
                            this.bkch();
                            switch (ch) {
                                case '-': {
                                    this.mEvt = 8;
                                    this.comm();
                                    break block2;
                                }
                                case '[': {
                                    this.mEvt = 7;
                                    this.cdat();
                                    break block2;
                                }
                            }
                            this.mEvt = 9;
                            this.mPSid = this.dtd();
                            break block2;
                        }
                        case '?': {
                            this.mEvt = 6;
                            this.pi();
                            break block2;
                        }
                    }
                    this.bkch();
                    this.mElm = this.pair(this.mElm);
                    if (this.mElm.next == null) {
                        this.dtdpost();
                        this.mElm.id = this.mIsNSAware ? 3 : 2;
                    } else {
                        while (this.mElm.list != null) {
                            this.mElm.list = this.del(this.mElm.list);
                        }
                        this.mElm.id = this.mElm.next.id;
                    }
                    this.mElm.chars = this.qname(this.mIsNSAware);
                    this.mElm.name = this.mIsNSAware ? this.mElm.local() : this.mElm.qname();
                    this.mElm.num = 0;
                    Pair elm = this.find(this.mAttL, this.mElm.chars);
                    this.mElm.list = elm != null ? elm.list : null;
                    this.attrs();
                    this.mAttrs.set(this.mElm);
                    switch (this.wsskip()) {
                        case '>': {
                            this.getch();
                            this.mEvt = 2;
                            break block2;
                        }
                        case '/': {
                            this.getch();
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            this.mEvt = 1;
                            break block2;
                        }
                    }
                    this.panic(FAULT);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            this.bappend(ch);
                            break block2;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block2;
                        }
                        case '<': {
                            this.mEvt = 5;
                            this.bkch();
                            this.bflash_ws();
                            break block2;
                        }
                    }
                    this.bkch();
                    st = 2;
                    break;
                }
                case 2: {
                    switch (ch) {
                        case '&': {
                            if (this.mUnent == null) {
                                this.mUnent = this.ent('x');
                                if (this.mUnent == null) continue block55;
                                if (this.mBuffIdx >= 0) {
                                    this.bkch();
                                    this.setch('&');
                                    this.mEvt = 4;
                                    this.bflash();
                                    break block2;
                                }
                                if (this.mUnent == UCS4_CHAR) {
                                    this.mEvt = 4;
                                    this.reportUCS4(this.mIent);
                                } else {
                                    this.mEvt = 11;
                                    this.skipEntity(this.mUnent);
                                }
                                this.mUnent = null;
                                break block2;
                            }
                            if (this.mUnent == UCS4_CHAR) {
                                this.mEvt = 4;
                                this.reportUCS4(this.mIent);
                            } else {
                                this.mEvt = 11;
                                this.skipEntity(this.mUnent);
                            }
                            this.mUnent = null;
                            break block2;
                        }
                        case '<': {
                            this.mEvt = 4;
                            this.bkch();
                            this.bflash();
                            break block2;
                        }
                        case '\r': {
                            if (this.getch() != '\n') {
                                this.bkch();
                            }
                            this.bappend('\n');
                            break block2;
                        }
                        case '\uffff': {
                            this.panic(FAULT);
                        }
                        case '\t': 
                        case '\n': 
                        case ' ': 
                        case '\"': 
                        case '%': 
                        case '\'': {
                            this.bappend(ch);
                            break block2;
                        }
                    }
                    this.bappend();
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '<': {
                            ch = this.getch();
                            switch (ch) {
                                case '!': {
                                    ch = this.getch();
                                    this.bkch();
                                    if (ch == '-') {
                                        this.mEvt = 8;
                                        this.comm();
                                        break block2;
                                    }
                                    this.bntok();
                                    switch (this.bkeyword()) {
                                        case 'n': {
                                            this.mEvt = this.dtdent();
                                            break;
                                        }
                                        case 'a': {
                                            this.dtdattl();
                                            break;
                                        }
                                        case 'e': {
                                            this.dtdelm();
                                            break;
                                        }
                                        case 'o': {
                                            this.mEvt = 14;
                                            this.dtdnot();
                                            break;
                                        }
                                        default: {
                                            this.panic(FAULT);
                                        }
                                    }
                                    this.wsskip();
                                    if (this.getch() == '>') continue block55;
                                    this.panic(FAULT);
                                    break block2;
                                }
                                case '?': {
                                    this.mEvt = 6;
                                    this.pi();
                                    break block2;
                                }
                            }
                            this.panic(FAULT);
                            break block2;
                        }
                        case ']': {
                            if (this.mPSid != null) {
                                InputSource is = this.resolveEnt("[dtd]", this.mPSid.name, this.mPSid.value);
                                if (is != null) {
                                    if (!this.mIsSAlone) {
                                        this.bkch();
                                        this.push(new Input(512));
                                        this.setinp(is);
                                        this.mInp.pubid = this.mPSid.name;
                                        this.mInp.sysid = this.mPSid.value;
                                    } else {
                                        this.skippedEnt("[dtd]");
                                        if (is.getCharacterStream() != null) {
                                            try {
                                                is.getCharacterStream().close();
                                            }
                                            catch (IOException ioe) {
                                                // empty catch block
                                            }
                                        }
                                        if (is.getByteStream() != null) {
                                            try {
                                                is.getByteStream().close();
                                            }
                                            catch (IOException ioe) {
                                                // empty catch block
                                            }
                                        }
                                        this.mEvt = 10;
                                    }
                                } else {
                                    this.skippedEnt("[dtd]");
                                    this.mEvt = 10;
                                }
                                this.del(this.mPSid);
                                this.mPSid = null;
                                break block2;
                            }
                            this.mEvt = 10;
                            break block2;
                        }
                        case '%': {
                            this.pent(' ');
                            break block2;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block2;
                        }
                    }
                    this.panic(FAULT);
                    break;
                }
                case 4: {
                    switch (ch) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block2;
                        }
                    }
                    this.bkch();
                    st = this.mPh != 2 ? 0 : 3;
                    break;
                }
                default: {
                    this.panic(FAULT);
                }
            }
        }
        return this.mEvt;
    }

    private Pair dtd() throws Exception {
        Object str = null;
        String name = null;
        Pair psid = null;
        if (!"DOCTYPE".equals(this.name(false)) || this.mPh >= 2) {
            this.panic(FAULT);
        }
        int st = 0;
        block20: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    if (this.chtyp(ch) == ' ') continue block20;
                    this.bkch();
                    name = this.name(this.mIsNSAware);
                    this.wsskip();
                    st = 1;
                    continue block20;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case 'A': {
                            this.bkch();
                            psid = this.pubsys(' ');
                            st = 2;
                            continue block20;
                        }
                        case '[': {
                            this.bkch();
                            psid = this.pair(null);
                            st = 2;
                            continue block20;
                        }
                        case '>': {
                            this.bkch();
                            psid = this.pair(null);
                            st = 3;
                            continue block20;
                        }
                    }
                    this.panic(FAULT);
                    continue block20;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case '[': {
                            psid.chars = this.dtdint();
                            st = 3;
                            continue block20;
                        }
                        case '>': {
                            this.bkch();
                            st = 3;
                            continue block20;
                        }
                        case ' ': {
                            continue block20;
                        }
                    }
                    this.panic(FAULT);
                    continue block20;
                }
                case 3: {
                    switch (this.chtyp(ch)) {
                        case '>': {
                            this.docType(name, psid.name, psid.value, psid.chars);
                            this.bkch();
                            this.setch(']');
                            Input inp = new Input(psid.chars != null ? psid.chars : new char[]{});
                            inp.pubid = this.mInp.pubid;
                            inp.sysid = this.mInp.sysid;
                            inp.xmlenc = this.mInp.xmlenc;
                            inp.xmlver = this.mInp.xmlver;
                            this.push(inp);
                            psid.chars = null;
                            if (psid.name == null && psid.value == null) {
                                this.del(psid);
                                psid = null;
                            }
                            st = -1;
                            continue block20;
                        }
                        case ' ': {
                            continue block20;
                        }
                    }
                    this.panic(FAULT);
                    continue block20;
                }
            }
            this.panic(FAULT);
        }
        return psid;
    }

    private char[] dtdint() throws Exception {
        int bsize = this.mBuff.length;
        this.mBuffIdx = -1;
        while (true) {
            char ch = this.getNextCh();
            switch (ch) {
                case ']': {
                    char[] chars = new char[this.mBuffIdx + 1];
                    System.arraycopy(this.mBuff, 0, chars, 0, this.mBuffIdx + 1);
                    if (this.mBuff.length > bsize) {
                        this.mBuff = new char[bsize];
                    }
                    this.mBuffIdx = -1;
                    return chars;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
            }
            this.bappend(ch);
        }
    }

    private int dtdent() throws Exception {
        String str = null;
        char[] val = null;
        Input inp = null;
        Pair ids = null;
        int evt = 0;
        int st = 0;
        block21: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ' ': {
                            continue block21;
                        }
                        case '%': {
                            ch = this.getch();
                            this.bkch();
                            if (this.chtyp(ch) == ' ') {
                                this.wsskip();
                                str = this.name(false);
                                switch (this.chtyp(this.wsskip())) {
                                    case 'A': {
                                        ids = this.pubsys(' ');
                                        if (this.wsskip() == '>') {
                                            if (!this.mPEnt.containsKey(str)) {
                                                inp = new Input();
                                                inp.pubid = ids.name;
                                                inp.sysid = ids.value;
                                                this.mPEnt.put(str, inp);
                                            }
                                        } else {
                                            this.panic(FAULT);
                                        }
                                        this.del(ids);
                                        st = -1;
                                        continue block21;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        this.bqstr('d');
                                        val = new char[this.mBuffIdx + 1];
                                        System.arraycopy(this.mBuff, 1, val, 1, val.length - 1);
                                        val[0] = 32;
                                        if (!this.mPEnt.containsKey(str)) {
                                            inp = new Input(val);
                                            inp.pubid = this.mInp.pubid;
                                            inp.sysid = this.mInp.sysid;
                                            inp.xmlenc = this.mInp.xmlenc;
                                            inp.xmlver = this.mInp.xmlver;
                                            this.mPEnt.put(str, inp);
                                        }
                                        st = -1;
                                        continue block21;
                                    }
                                }
                                this.panic(FAULT);
                                continue block21;
                            }
                            this.pent(' ');
                            continue block21;
                        }
                    }
                    this.bkch();
                    str = this.name(false);
                    st = 1;
                    continue block21;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            if (this.mEnt.get(str) == null) {
                                val = new char[this.mBuffIdx];
                                System.arraycopy(this.mBuff, 1, val, 0, val.length);
                                if (!this.mEnt.containsKey(str)) {
                                    inp = new Input(val);
                                    inp.pubid = this.mInp.pubid;
                                    inp.sysid = this.mInp.sysid;
                                    inp.xmlenc = this.mInp.xmlenc;
                                    inp.xmlver = this.mInp.xmlver;
                                    this.mEnt.put(str, inp);
                                    this.intparsedEntDecl(str, val);
                                    evt = 12;
                                }
                            }
                            st = -1;
                            continue block21;
                        }
                        case 'A': {
                            this.bkch();
                            ids = this.pubsys(' ');
                            switch (this.wsskip()) {
                                case '>': {
                                    if (this.mEnt.containsKey(str)) break;
                                    inp = new Input();
                                    inp.pubid = ids.name;
                                    inp.sysid = ids.value;
                                    this.mEnt.put(str, inp);
                                    this.extparsedEntDecl(str, inp.pubid, inp.sysid);
                                    evt = 12;
                                    break;
                                }
                                case 'N': {
                                    if ("NDATA".equals(this.name(false))) {
                                        this.wsskip();
                                        this.unparsedEntDecl(str, ids.name, ids.value, this.name(false));
                                        evt = 13;
                                        break;
                                    }
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.del(ids);
                            st = -1;
                            continue block21;
                        }
                        case ' ': {
                            continue block21;
                        }
                    }
                    this.panic(FAULT);
                    continue block21;
                }
            }
            this.panic(FAULT);
        }
        return evt;
    }

    private void dtdelm() throws Exception {
        this.wsskip();
        this.name(this.mIsNSAware);
        while (true) {
            char ch = this.getch();
            switch (ch) {
                case '>': {
                    this.bkch();
                    return;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
            }
        }
    }

    private void dtdattl() throws Exception {
        char[] elmqn = null;
        Pair elm = null;
        int st = 0;
        block14: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            elmqn = this.qname(this.mIsNSAware);
                            elm = this.find(this.mAttL, elmqn);
                            if (elm == null) {
                                elm = this.pair(this.mAttL);
                                elm.chars = elmqn;
                                this.mAttL = elm;
                            }
                            st = 1;
                            continue block14;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            this.dtdatt(elm);
                            if (this.wsskip() != '>') continue block14;
                            return;
                        }
                        case ' ': {
                            continue block14;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block14;
                        }
                    }
                    this.panic(FAULT);
                    continue block14;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdatt(Pair elm) throws Exception {
        char[] attqn = null;
        Pair att = null;
        int st = 0;
        block57: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            attqn = this.qname(this.mIsNSAware);
                            att = this.find(elm.list, attqn);
                            if (att == null) {
                                att = this.pair(elm.list);
                                att.chars = attqn;
                                att.num = 1;
                                att.id = 99;
                                elm.list = att;
                            } else {
                                att = this.pair(null);
                                att.chars = attqn;
                                att.num = 1;
                                att.id = 99;
                            }
                            this.wsskip();
                            st = 1;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '(': {
                            att.id = 117;
                            st = 2;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.bkch();
                    this.bntok();
                    att.id = this.bkeyword();
                    switch (att.id) {
                        case 111: {
                            if (this.wsskip() != '(') {
                                this.panic(FAULT);
                            }
                            ch = this.getch();
                            st = 2;
                            continue block57;
                        }
                        case 78: 
                        case 82: 
                        case 84: 
                        case 99: 
                        case 105: 
                        case 110: 
                        case 114: 
                        case 116: {
                            this.wsskip();
                            st = 4;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case '-': 
                        case '.': 
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': 
                        case 'd': {
                            this.bkch();
                            switch (att.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            st = 3;
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                        case ' ': {
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 3: {
                    switch (ch) {
                        case ')': {
                            this.wsskip();
                            st = 4;
                            continue block57;
                        }
                        case '|': {
                            this.wsskip();
                            switch (att.id) {
                                case 117: {
                                    this.bntok();
                                    break;
                                }
                                case 111: {
                                    this.mBuffIdx = -1;
                                    this.bname(false);
                                    break;
                                }
                                default: {
                                    this.panic(FAULT);
                                }
                            }
                            this.wsskip();
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
                case 4: {
                    switch (ch) {
                        case '#': {
                            this.bntok();
                            switch (this.bkeyword()) {
                                case 'F': {
                                    switch (this.wsskip()) {
                                        case '\"': 
                                        case '\'': {
                                            st = 5;
                                            continue block57;
                                        }
                                        case '\uffff': {
                                            this.panic(FAULT);
                                        }
                                    }
                                    st = -1;
                                    continue block57;
                                }
                                case 'I': 
                                case 'Q': {
                                    st = -1;
                                    continue block57;
                                }
                            }
                            this.panic(FAULT);
                            continue block57;
                        }
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            st = 5;
                            continue block57;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block57;
                        }
                        case '%': {
                            this.pent(' ');
                            continue block57;
                        }
                    }
                    this.bkch();
                    st = -1;
                    continue block57;
                }
                case 5: {
                    switch (ch) {
                        case '\"': 
                        case '\'': {
                            this.bkch();
                            this.bqstr('d');
                            att.num |= 2;
                            att.list = this.pair(null);
                            att.list.chars = new char[att.chars.length + this.mBuffIdx + 3];
                            System.arraycopy(att.chars, 1, att.list.chars, 0, att.chars.length - 1);
                            att.list.chars[att.chars.length - 1] = 61;
                            att.list.chars[att.chars.length] = ch;
                            System.arraycopy(this.mBuff, 1, att.list.chars, att.chars.length + 1, this.mBuffIdx);
                            att.list.chars[att.chars.length + this.mBuffIdx + 1] = ch;
                            att.list.chars[att.chars.length + this.mBuffIdx + 2] = 32;
                            st = -1;
                            continue block57;
                        }
                    }
                    this.panic(FAULT);
                    continue block57;
                }
            }
            this.panic(FAULT);
        }
    }

    private void dtdnot() throws Exception {
        this.wsskip();
        String name = this.name(false);
        this.wsskip();
        Pair ids = this.pubsys('N');
        this.notDecl(name, ids.name, ids.value);
        this.del(ids);
    }

    protected void dtdpost() throws Exception {
        Pair elm = this.mAttL;
        while (elm != null) {
            Pair attr = elm.list;
            while (attr != null) {
                if (attr.list != null) {
                    this.push(new Input(attr.list.chars));
                    this.bname(false);
                    this.wsskip();
                    if (this.getch() != '=') {
                        this.panic(FAULT);
                    }
                    this.bqstr((char)attr.id == 'c' ? (char)'c' : 'i');
                    this.battrval(attr);
                    this.pop();
                }
                attr = attr.next;
            }
            elm = elm.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void attrs() throws Exception {
        withns = this.mIsNSAware;
        head = null;
        tail = null;
        decl = null;
        next = this.mElm.list;
        attr = null;
        list = null;
        anum = 0;
        block9: while (true) {
            if (next == null) {
                switch (this.wsskip()) {
                    case '/': 
                    case '>': {
                        break block9;
                    }
                    case '\uffff': {
                        this.panic("Syntax Error");
                    }
                    default: {
                        attr = this.pair(null);
                        attr.chars = this.qname(withns);
                        attr.num = 0;
                        this.wsskip();
                        if (this.getch() != '=') {
                            this.panic("Syntax Error");
                        }
                        if ((decl = this.find(this.mElm.list, attr.chars)) != null) {
                            attr.num |= 1;
                            attr.id = decl.id;
                            this.bqstr((char)attr.id == 'c' ? 'c' : 'i');
                        } else {
                            attr.id = 99;
                            this.bqstr('c');
                        }
                        this.battrval(attr);
                        break;
                    }
                }
            } else {
                while (next != null && (next.num & 3) != 3) {
                    next = next.next;
                }
                if (next == null) continue;
                attr = this.pair(null);
                attr.copyof(next);
                next = next.next;
            }
            defa = this.find(list, attr.chars);
            if (defa != null) {
                if ((defa.num & 2) == 0) {
                    this.panic("Syntax Error");
                }
                defa.value = attr.value;
                defa.num &= -3;
                if (defa.list != null) {
                    defa.list.value = defa.value;
                }
                this.del(attr);
                continue;
            }
            switch (attr.chars[0]) {
                case '\u0000': {
                    if (attr.chars.length != 6) break;
                }
                case '\u0006': {
                    if (!withns || attr.chars[1] != 'x' || attr.chars[2] != 'm' || attr.chars[3] != 'l' || attr.chars[4] != 'n' || attr.chars[5] != 's') break;
                    decl = this.pair(null);
                    decl.list = this.mElm;
                    decl.value = attr.value;
                    if (attr.chars[0] == '\u0000') {
                        decl.name = "";
                        decl.chars = Parser.NONS;
                    } else {
                        decl.name = attr.local();
                        len = decl.name.length();
                        decl.chars = new char[len + 1];
                        decl.chars[0] = (char)(len + 1);
                        decl.name.getChars(0, len, decl.chars, 1);
                    }
                    attr.list = decl;
                    if (tail != null) {
                        tail.next = decl;
                        tail = decl;
                        break;
                    }
                    head = decl;
                    tail = decl;
                    break;
                }
                case '\u0004': {
                    if (attr.chars[1] != 'x' || attr.chars[2] != 'm' || attr.chars[3] != 'l') break;
                    if (attr.eqname(Parser.XMLSPC)) {
                        if ("preserve".equals(attr.value)) {
                            this.mElm.id |= 2;
                            break;
                        }
                        this.mElm.id &= -3;
                        break;
                    }
                    if (!attr.eqname(Parser.XMLID)) break;
                    attr.id = 105;
                    break;
                }
            }
            attr.next = list;
            list = attr;
            ++anum;
        }
        this.mElm.list = list;
        this.mElm.num = anum;
        while (head != null) {
            decl = head;
            head = decl.next;
            decl.next = this.mPref;
            this.mPref = decl;
            this.newPrefix();
        }
        if (!withns) {
            return;
        }
        attr = this.mElm;
        while (attr != null) {
            block37: {
                block39: {
                    len = attr.chars[0];
                    if (attr == this.mElm) break block39;
                    next = attr.next;
                    if (len == '\u0000') break block37;
                    if (attr.list == null) ** GOTO lbl-1000
                    attr.ns = "http://www.w3.org/2000/xmlns/";
                    break block37;
                }
                next = list;
                if (len == '\u0000') {
                    pref = this.mPref;
                    while (pref != null) {
                        if (pref.chars[0] == '\u0000') {
                            attr.ns = pref.value;
                            break;
                        }
                        pref = pref.next;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    pref = this.mPref;
                    while (pref != null) {
                        block38: {
                            if (len == pref.chars[0]) {
                                found = null;
                                for (i = '\u0001'; i < len; i = (char)(i + '\u0001')) {
                                    if (pref.chars[i] == attr.chars[i]) {
                                        found = pref;
                                        continue;
                                    }
                                    break block38;
                                }
                                if (found != null) {
                                    attr.ns = found.value;
                                    break;
                                }
                            }
                        }
                        pref = pref.next;
                    }
                    if (attr.ns == null) {
                        this.panic("Syntax Error");
                    }
                }
            }
            attr = next;
        }
    }

    private void comm() throws Exception {
        if (this.mPh == 0) {
            this.mPh = 1;
        }
        this.mBuffIdx = -1;
        int st = 0;
        block13: while (st >= 0) {
            char ch = this.getNextCh();
            if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: {
                    if (ch == '-') {
                        st = 1;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 1: {
                    if (ch == '-') {
                        st = 2;
                        continue block13;
                    }
                    this.panic(FAULT);
                    continue block13;
                }
                case 2: {
                    switch (ch) {
                        case '-': {
                            st = 3;
                            continue block13;
                        }
                    }
                    this.bappend(ch);
                    continue block13;
                }
                case 3: {
                    switch (ch) {
                        case '-': {
                            st = 4;
                            continue block13;
                        }
                    }
                    this.bappend('-');
                    this.bappend(ch);
                    st = 2;
                    continue block13;
                }
                case 4: {
                    if (ch != '>') break;
                    this.comm(this.mBuff, this.mBuffIdx + 1);
                    st = -1;
                    continue block13;
                }
            }
            this.panic(FAULT);
        }
    }

    private void pi() throws Exception {
        String str = null;
        this.mBuffIdx = -1;
        int st = 0;
        block15: while (st >= 0) {
            char ch = this.getch();
            if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: {
                    switch (this.chtyp(ch)) {
                        case ':': 
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            str = this.name(false);
                            if (str.length() == 0 || this.mXml.name.equals(str.toLowerCase())) {
                                this.panic(FAULT);
                            }
                            if (this.mPh == 0) {
                                this.mPh = 1;
                            }
                            this.wsskip();
                            st = 1;
                            this.mBuffIdx = -1;
                            continue block15;
                        }
                    }
                    this.panic(FAULT);
                    continue block15;
                }
                case 1: {
                    switch (ch) {
                        case '?': {
                            st = 2;
                            continue block15;
                        }
                    }
                    this.bappend(ch);
                    continue block15;
                }
                case 2: {
                    switch (ch) {
                        case '>': {
                            this.pi(str, new String(this.mBuff, 0, this.mBuffIdx + 1));
                            st = -1;
                            continue block15;
                        }
                        case '?': {
                            this.bappend('?');
                            continue block15;
                        }
                    }
                    this.bappend('?');
                    this.bappend(ch);
                    st = 1;
                    continue block15;
                }
            }
            this.panic(FAULT);
        }
    }

    private void cdat() throws Exception {
        this.mBuffIdx = -1;
        int st = 0;
        block16: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    if (ch == '[') {
                        st = 1;
                        continue block16;
                    }
                    this.panic(FAULT);
                    continue block16;
                }
                case 1: {
                    if (this.chtyp(ch) == 'A') {
                        this.bappend(ch);
                        continue block16;
                    }
                    if (!"CDATA".equals(new String(this.mBuff, 0, this.mBuffIdx + 1))) {
                        this.panic(FAULT);
                    }
                    this.bkch();
                    st = 2;
                    continue block16;
                }
                case 2: {
                    if (ch != '[') {
                        this.panic(FAULT);
                    }
                    this.mBuffIdx = -1;
                    st = 3;
                    continue block16;
                }
                case 3: {
                    switch (ch) {
                        case ']': {
                            st = 4;
                            continue block16;
                        }
                        case '\uffff': {
                            this.panic(FAULT);
                        }
                    }
                    this.bappend(ch);
                    continue block16;
                }
                case 4: {
                    if (ch != ']') {
                        this.bappend(']');
                        this.bappend(ch);
                        st = 3;
                        continue block16;
                    }
                    st = 5;
                    continue block16;
                }
                case 5: {
                    switch (ch) {
                        case ']': {
                            this.bappend(']');
                            continue block16;
                        }
                        case '>': {
                            this.bflash_zc();
                            st = -1;
                            continue block16;
                        }
                    }
                    this.bappend(']');
                    this.bappend(']');
                    this.bappend(ch);
                    st = 3;
                    continue block16;
                }
            }
            this.panic(FAULT);
        }
    }

    protected void skipElement(QualifiedName qname) throws Exception {
        if (qname == null) {
            return;
        }
        this.mBuffIdx = -1;
        int index = 0;
        StringBuffer sb = new StringBuffer();
        int st = 0;
        block10: while (st >= 0) {
            char ch = this.getch();
            switch (st) {
                case 0: {
                    switch (ch) {
                        case '<': {
                            st = 1;
                            continue block10;
                        }
                        case '\uffff': {
                            this.mPh = 6;
                            return;
                        }
                    }
                    this.bappend(ch);
                    continue block10;
                }
                case 1: {
                    if (ch != '/') {
                        this.bappend('<');
                        this.bappend(ch);
                        st = 0;
                        continue block10;
                    }
                    st = 2;
                    continue block10;
                }
                case 2: {
                    if (ch == ' ') {
                        this.wsskip();
                        ch = this.getch();
                    }
                    if (ch == qname.name.charAt(index)) {
                        sb.append('<');
                        sb.append('/');
                        sb.append(ch);
                        ++index;
                        st = 3;
                        continue block10;
                    }
                    this.bappend('<');
                    this.bappend('/');
                    this.bappend(ch);
                    st = 0;
                    index = 0;
                    continue block10;
                }
                case 3: {
                    int i;
                    if (index == qname.name.length()) {
                        if (ch == ' ') {
                            this.wsskip();
                            ch = this.getch();
                        }
                        if (ch == '>') {
                            this.bflash();
                            st = -1;
                        } else {
                            for (i = 0; i < sb.length(); ++i) {
                                this.bappend(sb.charAt(i));
                            }
                            sb.delete(0, sb.length());
                            this.bappend(ch);
                            st = 0;
                        }
                        index = 0;
                        continue block10;
                    }
                    if (ch == qname.name.charAt(index++)) {
                        sb.append(ch);
                        continue block10;
                    }
                    for (i = 0; i < sb.length(); ++i) {
                        this.bappend(sb.charAt(i));
                    }
                    sb.delete(0, sb.length());
                    this.bappend(ch);
                    st = 0;
                    index = 0;
                    continue block10;
                }
            }
            this.mPh = 6;
            return;
        }
    }

    protected String name(boolean ns) throws Exception {
        this.mBuffIdx = -1;
        this.bname(ns);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    protected char[] qname(boolean ns) throws Exception {
        this.mBuffIdx = -1;
        this.bname(ns);
        char[] chars = new char[this.mBuffIdx + 1];
        System.arraycopy(this.mBuff, 0, chars, 0, this.mBuffIdx + 1);
        return chars;
    }

    private void pubsys(Input inp) throws Exception {
        Pair pair = this.pubsys(' ');
        inp.pubid = pair.name;
        inp.sysid = pair.value;
        this.del(pair);
    }

    private Pair pubsys(char flag) throws Exception {
        Pair ids = this.pair(null);
        String str = this.name(false);
        if ("PUBLIC".equals(str)) {
            this.bqstr('i');
            ids.name = new String(this.mBuff, 1, this.mBuffIdx);
            switch (this.wsskip()) {
                case '\"': 
                case '\'': {
                    this.bqstr(' ');
                    ids.value = new String(this.mBuff, 1, this.mBuffIdx);
                    break;
                }
                case '\uffff': {
                    this.panic(FAULT);
                }
                default: {
                    if (flag != 'N') {
                        this.panic(FAULT);
                    }
                    ids.value = null;
                }
            }
            return ids;
        }
        if ("SYSTEM".equals(str)) {
            ids.name = null;
            this.bqstr(' ');
            ids.value = new String(this.mBuff, 1, this.mBuffIdx);
            return ids;
        }
        this.panic(FAULT);
        return null;
    }

    protected String eqstr(char flag) throws Exception {
        if (flag == '=') {
            this.wsskip();
            if (this.getch() != '=') {
                this.panic(FAULT);
            }
        }
        this.bqstr(flag == '=' ? (char)'-' : (char)flag);
        return new String(this.mBuff, 1, this.mBuffIdx);
    }

    private String ent(char flag) throws Exception {
        int idx = this.mBuffIdx + 1;
        Input inp = null;
        String str = null;
        this.mESt = (char)256;
        this.bappend('&');
        int st = 0;
        block25: while (st >= 0) {
            char ch = this.getNextCh();
            switch (st) {
                case 0: 
                case 1: {
                    switch (this.chtyp(ch)) {
                        case '-': 
                        case '.': 
                        case 'd': {
                            if (st != 1) {
                                this.panic(FAULT);
                            }
                        }
                        case 'A': 
                        case 'X': 
                        case '_': 
                        case 'a': {
                            this.bappend(ch);
                            this.eappend(ch);
                            st = 1;
                            continue block25;
                        }
                        case ':': {
                            if (this.mIsNSAware) {
                                this.panic(FAULT);
                            }
                            this.bappend(ch);
                            this.eappend(ch);
                            st = 1;
                            continue block25;
                        }
                        case ';': {
                            if (this.mESt < '\u0100') {
                                this.mBuffIdx = idx - 1;
                                this.bappend(this.mESt);
                                st = -1;
                                continue block25;
                            }
                            if (this.mPh == 2) {
                                this.bappend(';');
                                st = -1;
                                continue block25;
                            }
                            str = new String(this.mBuff, idx + 1, this.mBuffIdx - idx);
                            inp = (Input)this.mEnt.get(str);
                            this.mBuffIdx = idx - 1;
                            if (inp != null) {
                                if (inp.chars == null) {
                                    InputSource is = this.resolveEnt(str, inp.pubid, inp.sysid);
                                    if (is != null) {
                                        this.push(new Input(512));
                                        this.setinp(is);
                                        this.mInp.pubid = inp.pubid;
                                        this.mInp.sysid = inp.sysid;
                                        str = null;
                                    } else if (flag != 'x') {
                                        this.panic(FAULT);
                                    }
                                } else {
                                    this.push(inp);
                                    str = null;
                                }
                            } else if (flag != 'x') {
                                this.panic(FAULT);
                            }
                            st = -1;
                            continue block25;
                        }
                        case '#': {
                            if (st != 0) {
                                this.panic(FAULT);
                            }
                            st = 2;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 2: {
                    switch (this.chtyp(ch)) {
                        case 'd': {
                            this.bappend(ch);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int i = Integer.parseInt(new String(this.mBuff, idx + 1, this.mBuffIdx - idx), 10);
                                if (i >= 65535) {
                                    if (flag != 'x') {
                                        this.panic(FAULT);
                                    }
                                    this.mIent = i;
                                    str = UCS4_CHAR;
                                    this.mBuffIdx = idx - 1;
                                    st = -1;
                                    continue block25;
                                }
                                ch = (char)i;
                            }
                            catch (NumberFormatException nfe) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = idx - 1;
                            if (ch == ' ' || this.mInp.next != null) {
                                this.bappend(ch, flag);
                            } else {
                                this.bappend(ch);
                            }
                            st = -1;
                            continue block25;
                        }
                        case 'a': {
                            if (this.mBuffIdx != idx || ch != 'x') break;
                            st = 3;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
                case 3: {
                    switch (this.chtyp(ch)) {
                        case 'A': 
                        case 'a': 
                        case 'd': {
                            this.bappend(ch);
                            continue block25;
                        }
                        case ';': {
                            try {
                                int i = Integer.parseInt(new String(this.mBuff, idx + 1, this.mBuffIdx - idx), 16);
                                if (i >= 65535) {
                                    if (flag != 'x') {
                                        this.panic(FAULT);
                                    }
                                    this.mIent = i;
                                    str = UCS4_CHAR;
                                    this.mBuffIdx = idx - 1;
                                    st = -1;
                                    continue block25;
                                }
                                ch = (char)i;
                            }
                            catch (NumberFormatException nfe) {
                                this.panic(FAULT);
                            }
                            this.mBuffIdx = idx - 1;
                            if (ch == ' ' || this.mInp.next != null) {
                                this.bappend(ch, flag);
                            } else {
                                this.bappend(ch);
                            }
                            st = -1;
                            continue block25;
                        }
                    }
                    this.panic(FAULT);
                    continue block25;
                }
            }
            this.panic(FAULT);
        }
        return str;
    }

    private void pent(char flag) throws Exception {
        int idx = this.mBuffIdx + 1;
        Input inp = null;
        String str = null;
        this.bappend('%');
        if (this.mPh != 2) {
            return;
        }
        this.bname(false);
        str = new String(this.mBuff, idx + 2, this.mBuffIdx - idx - 1);
        if (this.getch() != ';') {
            this.panic(FAULT);
        }
        inp = (Input)this.mPEnt.get(str);
        this.mBuffIdx = idx - 1;
        if (inp != null) {
            if (inp.chars == null) {
                InputSource is = this.resolveEnt(str, inp.pubid, inp.sysid);
                if (is != null) {
                    if (flag != '-') {
                        this.bappend(' ');
                    }
                    this.push(new Input(512));
                    this.setinp(is);
                    this.mInp.pubid = inp.pubid;
                    this.mInp.sysid = inp.sysid;
                } else {
                    this.skippedEnt("%" + str);
                }
            } else {
                if (flag == '-') {
                    inp.chIdx = 1;
                } else {
                    this.bappend(' ');
                    inp.chIdx = 0;
                }
                this.push(inp);
            }
        } else {
            this.skippedEnt("%" + str);
        }
    }

    protected char wsskip() throws Exception {
        char ch;
        while ((ch = this.getNextCh()) < '\u0080' && nmttyp[ch] == 3) {
        }
        this.bkch();
        return ch;
    }

    protected abstract void docType(String var1, String var2, String var3, char[] var4);

    protected abstract void comm(char[] var1, int var2);

    protected abstract void pi(String var1, String var2) throws Exception;

    protected abstract void newPrefix() throws Exception;

    protected abstract void skippedEnt(String var1) throws Exception;

    protected abstract InputSource resolveEnt(String var1, String var2, String var3) throws Exception;

    protected abstract void intparsedEntDecl(String var1, char[] var2) throws Exception;

    protected abstract void extparsedEntDecl(String var1, String var2, String var3) throws Exception;

    protected abstract void notDecl(String var1, String var2, String var3) throws Exception;

    protected abstract void unparsedEntDecl(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract void panic(String var1) throws Exception;

    protected void battrval(Pair attr) {
        attr.value = new String(this.mBuff, 1, this.mBuffIdx);
    }

    protected void bname(boolean ns) throws Exception {
        int bchidx;
        int bqname;
        ++this.mBuffIdx;
        int bcolon = bqname = this.mBuffIdx;
        int bstart = bchidx = bqname + 1;
        int cstart = this.mChIdx;
        int st = ns ? 0 : 2;
        block12: while (true) {
            if (this.mChIdx >= this.mChLen) {
                this.bcopy(cstart, bstart);
                this.getch();
                this.bkch();
                cstart = this.mChIdx;
                bstart = bchidx;
            }
            char ch = this.mChars[this.mChIdx++];
            this.updatePosition(ch);
            char type = '\u0000';
            if (ch < '\u0080') {
                type = (char)nmttyp[ch];
            } else if (ch == '\uffff') {
                this.panic(FAULT);
            }
            switch (st) {
                case 0: 
                case 2: {
                    switch (type) {
                        case '\u0000': {
                            ++bchidx;
                            st = (short)(st + 1);
                            continue block12;
                        }
                        case '\u0001': {
                            if (st != 2) break;
                            this.bkch();
                            st = 3;
                            continue block12;
                        }
                    }
                    this.panic(FAULT);
                    continue block12;
                }
                case 1: 
                case 3: {
                    switch (type) {
                        case '\u0000': 
                        case '\u0002': {
                            ++bchidx;
                            continue block12;
                        }
                        case '\u0001': {
                            ++bchidx;
                            if (!ns) continue block12;
                            if (bcolon != bqname) {
                                this.panic(FAULT);
                            }
                            bcolon = bchidx - 1;
                            if (st != 1) continue block12;
                            st = 2;
                            continue block12;
                        }
                    }
                    this.bkch();
                    this.bcopy(cstart, bstart);
                    this.mBuff[bqname] = (char)(bcolon - bqname);
                    return;
                }
            }
            this.panic(FAULT);
        }
    }

    protected void bntok() throws Exception {
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        block4: while (true) {
            char ch = this.getch();
            switch (this.chtyp(ch)) {
                case '-': 
                case '.': 
                case ':': 
                case 'A': 
                case 'X': 
                case '_': 
                case 'a': 
                case 'd': {
                    this.bappend(ch);
                    continue block4;
                }
                case 'Z': {
                    this.panic(FAULT);
                }
            }
            break;
        }
        this.bkch();
    }

    protected char bkeyword() throws Exception {
        String str = new String(this.mBuff, 1, this.mBuffIdx);
        switch (str.length()) {
            case 2: {
                return "ID".equals(str) ? (char)'i' : '?';
            }
            case 5: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREF".equals(str) ? (char)'r' : '?';
                    }
                    case 'C': {
                        return "CDATA".equals(str) ? (char)'c' : '?';
                    }
                    case 'F': {
                        return "FIXED".equals(str) ? (char)'F' : '?';
                    }
                }
                break;
            }
            case 6: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IDREFS".equals(str) ? (char)'R' : '?';
                    }
                    case 'E': {
                        return "ENTITY".equals(str) ? (char)'n' : '?';
                    }
                }
                break;
            }
            case 7: {
                switch (this.mBuff[1]) {
                    case 'I': {
                        return "IMPLIED".equals(str) ? (char)'I' : '?';
                    }
                    case 'N': {
                        return "NMTOKEN".equals(str) ? (char)'t' : '?';
                    }
                    case 'A': {
                        return "ATTLIST".equals(str) ? (char)'a' : '?';
                    }
                    case 'E': {
                        return "ELEMENT".equals(str) ? (char)'e' : '?';
                    }
                }
                break;
            }
            case 8: {
                switch (this.mBuff[2]) {
                    case 'N': {
                        return "ENTITIES".equals(str) ? (char)'N' : '?';
                    }
                    case 'M': {
                        return "NMTOKENS".equals(str) ? (char)'T' : '?';
                    }
                    case 'O': {
                        return "NOTATION".equals(str) ? (char)'o' : '?';
                    }
                    case 'E': {
                        return "REQUIRED".equals(str) ? (char)'Q' : '?';
                    }
                }
                break;
            }
        }
        return '?';
    }

    protected void bqstr(char flag) throws Exception {
        Input inp = this.mInp;
        this.mBuffIdx = -1;
        this.bappend('\u0000');
        int st = 0;
        block19: while (st >= 0) {
            int ch = this.getNextCh();
            switch (st) {
                case 0: {
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block19;
                        }
                        case 39: {
                            st = 2;
                            continue block19;
                        }
                        case 34: {
                            st = 3;
                            continue block19;
                        }
                    }
                    this.panic(FAULT);
                    continue block19;
                }
                case 2: 
                case 3: {
                    switch (ch) {
                        case 39: {
                            if (st == 2 && this.mInp == inp) {
                                st = -1;
                                continue block19;
                            }
                            this.bappend((char)ch);
                            continue block19;
                        }
                        case 34: {
                            if (st == 3 && this.mInp == inp) {
                                st = -1;
                                continue block19;
                            }
                            this.bappend((char)ch);
                            continue block19;
                        }
                        case 38: {
                            if (flag != 'd') {
                                this.ent(flag);
                                continue block19;
                            }
                            this.bappend((char)ch);
                            continue block19;
                        }
                        case 37: {
                            if (flag == 'd') {
                                this.pent('-');
                                continue block19;
                            }
                            this.bappend((char)ch);
                            continue block19;
                        }
                        case 60: {
                            if (flag == '-' || flag == 'd') {
                                this.bappend((char)ch);
                                continue block19;
                            }
                            this.panic(FAULT);
                            continue block19;
                        }
                        case 65535: {
                            this.panic(FAULT);
                        }
                        case 13: {
                            if (flag != ' ' && this.mInp.next == null) {
                                if (this.getch() != '\n') {
                                    this.bkch();
                                }
                                ch = 10;
                            }
                        }
                        case 9: 
                        case 10: 
                        case 32: {
                            this.bappend((char)ch, flag);
                            continue block19;
                        }
                    }
                    this.bappend();
                    continue block19;
                }
            }
            this.panic(FAULT);
        }
        if (flag == 'i' && this.mBuff[this.mBuffIdx] == ' ') {
            --this.mBuffIdx;
        }
    }

    protected abstract void bflash() throws Exception;

    protected abstract void bflash_zc() throws Exception;

    protected abstract void bflash_ws() throws Exception;

    protected void bappend() throws Exception {
        int cdata = 0;
        this.bkch();
        while (true) {
            char ch = this.getNextCh();
            if (cdata == 1 && ch != ']' || cdata == 2 && ch != '>') {
                cdata = 0;
            }
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case '<': 
                case '\uffff': {
                    this.bkch();
                    return;
                }
                case '>': {
                    if (cdata == 2) {
                        this.panic(FAULT);
                    }
                }
                case ']': {
                    ++cdata;
                }
            }
            ++this.mBuffIdx;
            if (this.mBuffIdx < this.mBuff.length) {
                this.mBuff[this.mBuffIdx] = ch;
                continue;
            }
            --this.mBuffIdx;
            this.bappend(ch);
        }
    }

    protected void bappend(char ch, char mode) {
        block0 : switch (mode) {
            case 'i': {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.mBuffIdx > 0 && this.mBuff[this.mBuffIdx] != ' ') {
                            this.bappend(' ');
                        }
                        return;
                    }
                }
                break;
            }
            case 'c': {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        ch = (char)32;
                        break block0;
                    }
                }
                break;
            }
        }
        ++this.mBuffIdx;
        if (this.mBuffIdx < this.mBuff.length) {
            this.mBuff[this.mBuffIdx] = ch;
        } else {
            --this.mBuffIdx;
            this.bappend(ch);
        }
    }

    protected void bappend(char ch) {
        try {
            this.mBuff[++this.mBuffIdx] = ch;
        }
        catch (Exception exp) {
            char[] buff = new char[this.mBuff.length << 1];
            System.arraycopy(this.mBuff, 0, buff, 0, this.mBuff.length);
            this.mBuff = buff;
            this.mBuff[this.mBuffIdx] = ch;
        }
    }

    protected void bcopy(int cidx, int bidx) {
        int length = this.mChIdx - cidx;
        if (bidx + length + 1 >= this.mBuff.length) {
            char[] buff = new char[this.mBuff.length + length];
            System.arraycopy(this.mBuff, 0, buff, 0, this.mBuff.length);
            this.mBuff = buff;
        }
        System.arraycopy(this.mChars, cidx, this.mBuff, bidx, length);
        this.mBuffIdx += length;
    }

    private void eappend(char ch) {
        block0 : switch (this.mESt) {
            case '\u0100': {
                switch (ch) {
                    case 'l': {
                        this.mESt = (char)257;
                        break block0;
                    }
                    case 'g': {
                        this.mESt = (char)258;
                        break block0;
                    }
                    case 'a': {
                        this.mESt = (char)259;
                        break block0;
                    }
                    case 'q': {
                        this.mESt = (char)263;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0101': {
                this.mESt = (char)(ch == 't' ? 60 : 512);
                break;
            }
            case '\u0102': {
                this.mESt = (char)(ch == 't' ? 62 : 512);
                break;
            }
            case '\u0103': {
                switch (ch) {
                    case 'm': {
                        this.mESt = (char)260;
                        break block0;
                    }
                    case 'p': {
                        this.mESt = (char)261;
                        break block0;
                    }
                }
                this.mESt = (char)512;
                break;
            }
            case '\u0104': {
                this.mESt = (char)(ch == 'p' ? 38 : 512);
                break;
            }
            case '\u0105': {
                this.mESt = (char)(ch == 'o' ? 262 : 512);
                break;
            }
            case '\u0106': {
                this.mESt = (char)(ch == 's' ? 39 : 512);
                break;
            }
            case '\u0107': {
                this.mESt = (char)(ch == 'u' ? 264 : 512);
                break;
            }
            case '\u0108': {
                this.mESt = (char)(ch == 'o' ? 265 : 512);
                break;
            }
            case '\u0109': {
                this.mESt = (char)(ch == 't' ? 34 : 512);
                break;
            }
            case '\"': 
            case '&': 
            case '\'': 
            case '<': 
            case '>': {
                this.mESt = (char)512;
            }
        }
    }

    protected void setinp(InputSource is) throws Exception {
        Reader reader = null;
        this.mChIdx = 0;
        this.mChLen = 0;
        this.mChars = this.mInp.chars;
        this.mInp.src = null;
        if (this.mPh < 0) {
            this.mIsSAlone = false;
        }
        this.mIsSAloneSet = false;
        if (is.getCharacterStream() != null) {
            reader = is.getCharacterStream();
            this.xml(reader);
        } else if (is.getByteStream() != null) {
            if (is.getEncoding() != null) {
                String expenc = is.getEncoding().toUpperCase();
                reader = expenc.equals("UTF-16") ? this.bom(is.getByteStream(), 'U') : this.enc(expenc, is.getByteStream());
                this.xml(reader);
            } else {
                reader = this.bom(is.getByteStream(), ' ');
                if (reader == null) {
                    reader = this.enc("UTF-8", is.getByteStream());
                    String expenc = this.xml(reader);
                    if (expenc.startsWith("UTF-16")) {
                        this.panic(FAULT);
                    }
                    reader = this.enc(expenc, is.getByteStream());
                } else {
                    this.xml(reader);
                }
            }
        } else {
            this.panic(FAULT);
        }
        this.mInp.src = reader;
        this.mInp.pubid = is.getPublicId();
        this.mInp.sysid = is.getSystemId();
    }

    private Reader bom(InputStream is, char hint) throws Exception {
        int val = is.read();
        switch (val) {
            case 239: {
                if (hint == 'U') {
                    this.panic(FAULT);
                }
                if (is.read() != 187) {
                    this.panic(FAULT);
                }
                if (is.read() != 191) {
                    this.panic(FAULT);
                }
                return new ReaderUTF8(is);
            }
            case 254: {
                if (is.read() != 255) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(is, 'b');
            }
            case 255: {
                if (is.read() != 254) {
                    this.panic(FAULT);
                }
                return new ReaderUTF16(is, 'l');
            }
            case -1: {
                this.mChars[this.mChIdx++] = 65535;
                return new ReaderUTF8(is);
            }
        }
        if (hint == 'U') {
            this.panic(FAULT);
        }
        switch (val & 0xF0) {
            case 192: 
            case 208: {
                this.mChars[this.mChIdx++] = (char)((val & 0x1F) << 6 | is.read() & 0x3F);
                break;
            }
            case 224: {
                this.mChars[this.mChIdx++] = (char)((val & 0xF) << 12 | (is.read() & 0x3F) << 6 | is.read() & 0x3F);
                break;
            }
            case 240: {
                throw new UnsupportedEncodingException();
            }
            default: {
                this.mChars[this.mChIdx++] = (char)val;
            }
        }
        return null;
    }

    private String xml(Reader reader) throws Exception {
        int ch;
        String str = null;
        String enc = "UTF-8";
        int st = this.mChIdx != 0 ? (int)((short)(this.mChars[0] == '<' ? 1 : -1)) : 0;
        block38: while (st >= 0 && this.mChIdx < this.mChars.length) {
            int val = reader.read();
            ch = val >= 0 ? (int)val : 65535;
            this.updatePosition((char)ch);
            this.mChars[this.mChIdx++] = ch;
            switch (st) {
                case 0: {
                    switch (ch) {
                        case 60: {
                            st = 1;
                            continue block38;
                        }
                        case 65279: {
                            val = reader.read();
                            this.mChars[this.mChIdx - 1] = ch = val >= 0 ? (int)val : 65535;
                            st = (short)(ch == 60 ? 1 : -1);
                            continue block38;
                        }
                    }
                    st = -1;
                    continue block38;
                }
                case 1: {
                    st = (short)(ch == 63 ? 2 : -1);
                    continue block38;
                }
                case 2: {
                    st = (short)(ch == 120 ? 3 : -1);
                    continue block38;
                }
                case 3: {
                    st = (short)(ch == 109 ? 4 : -1);
                    continue block38;
                }
                case 4: {
                    st = (short)(ch == 108 ? 5 : -1);
                    continue block38;
                }
                case 5: {
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            st = 6;
                            continue block38;
                        }
                    }
                    st = -1;
                    continue block38;
                }
                case 6: {
                    switch (ch) {
                        case 63: {
                            st = 7;
                            continue block38;
                        }
                        case 65535: {
                            st = -2;
                            continue block38;
                        }
                    }
                    continue block38;
                }
                case 7: {
                    switch (ch) {
                        case 62: 
                        case 65535: {
                            st = -2;
                            continue block38;
                        }
                    }
                    st = 6;
                    continue block38;
                }
            }
            this.panic(FAULT);
        }
        this.mChLen = this.mChIdx;
        this.mChIdx = 0;
        if (st == -1) {
            return enc;
        }
        this.x = this.mChIdx = 5;
        st = 0;
        block39: while (st >= 0) {
            ch = this.getch();
            switch (st) {
                case 0: {
                    if (this.chtyp((char)ch) == ' ') continue block39;
                    this.bkch();
                    st = 1;
                    continue block39;
                }
                case 1: 
                case 2: 
                case 3: {
                    switch (this.chtyp((char)ch)) {
                        case 'A': 
                        case '_': 
                        case 'a': {
                            this.bkch();
                            str = this.name(false).toLowerCase();
                            if ("version".equals(str)) {
                                if (st != 1) {
                                    this.panic(FAULT);
                                }
                                if (!"1.0".equals(this.eqstr('='))) {
                                    this.panic(FAULT);
                                }
                                this.mInp.xmlver = (char)256;
                                st = 2;
                                continue block39;
                            }
                            if ("encoding".equals(str)) {
                                if (st != 2) {
                                    this.panic(FAULT);
                                }
                                enc = this.mInp.xmlenc = this.eqstr('=').toUpperCase();
                                st = 3;
                                continue block39;
                            }
                            if ("standalone".equals(str)) {
                                if (st == 1 || this.mPh >= 0) {
                                    this.panic(FAULT);
                                }
                                if ((str = this.eqstr('=').toLowerCase()).equals("yes")) {
                                    this.mIsSAlone = true;
                                } else if (str.equals("no")) {
                                    this.mIsSAlone = false;
                                } else {
                                    this.panic(FAULT);
                                }
                                this.mIsSAloneSet = true;
                                st = 4;
                                continue block39;
                            }
                            this.panic(FAULT);
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                        case '?': {
                            if (st == 1) {
                                this.panic(FAULT);
                            }
                            this.bkch();
                            st = 4;
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
                case 4: {
                    switch (this.chtyp((char)ch)) {
                        case '?': {
                            if (this.getch() != '>') {
                                this.panic(FAULT);
                            }
                            if (this.mPh <= 0) {
                                this.mPh = 1;
                            }
                            st = -1;
                            continue block39;
                        }
                        case ' ': {
                            continue block39;
                        }
                    }
                    this.panic(FAULT);
                    continue block39;
                }
            }
            this.panic(FAULT);
        }
        return enc;
    }

    private Reader enc(String name, InputStream is) throws UnsupportedEncodingException {
        if (name.equals("UTF-8")) {
            return new ReaderUTF8(is);
        }
        if (name.equals("UTF-16LE")) {
            return new ReaderUTF16(is, 'l');
        }
        if (name.equals("UTF-16BE")) {
            return new ReaderUTF16(is, 'b');
        }
        return new InputStreamReader(is, name);
    }

    protected void push(Input inp) {
        this.mInp.chLen = this.mChLen;
        this.mInp.chIdx = this.mChIdx;
        inp.next = this.mInp;
        this.mInp = inp;
        this.mChars = inp.chars;
        this.mChLen = inp.chLen;
        this.mChIdx = inp.chIdx;
    }

    protected void pop() {
        if (this.mInp.src != null) {
            try {
                this.mInp.src.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mInp.src = null;
        }
        this.mInp = this.mInp.next;
        if (this.mInp != null) {
            this.mChars = this.mInp.chars;
            this.mChLen = this.mInp.chLen;
            this.mChIdx = this.mInp.chIdx;
        } else {
            this.mChars = null;
            this.mChLen = 0;
            this.mChIdx = 0;
        }
    }

    protected char chtyp(char ch) {
        if (ch < '\u0080') {
            return (char)asctyp[ch];
        }
        return ch != '\uffff' ? (char)'X' : 'Z';
    }

    protected char getNextCh() throws IOException {
        char ch;
        if (this.mChIdx < this.mChLen) {
            ch = this.mChars[this.mChIdx++];
            this.updatePosition(ch);
        } else {
            ch = this.getch();
        }
        return ch;
    }

    protected char getch() throws IOException {
        if (this.mChIdx >= this.mChLen) {
            if (this.mInp.src == null) {
                this.pop();
                return this.getch();
            }
            int Num = this.mInp.src.read(this.mChars, 0, this.mChars.length);
            if (Num < 0) {
                if (this.mInp != this.mDoc) {
                    this.pop();
                    return this.getch();
                }
                this.mChars[0] = 65535;
                this.mChLen = 1;
            } else {
                this.mChLen = Num;
            }
            this.mChIdx = 0;
        }
        char ch = this.mChars[this.mChIdx++];
        this.updatePosition(ch);
        return ch;
    }

    void updatePosition(char ch) {
        if (ch == '\n' || ch == '\r') {
            ++this.y;
            this.x = 0;
        } else {
            ++this.x;
        }
    }

    protected void bkch() throws Exception {
        if (this.mChIdx <= 0) {
            this.panic(FAULT);
        }
        --this.mChIdx;
        char ch = this.mChars[this.mChIdx];
        if (ch == '\n' || ch == '\r') {
            --this.y;
            this.x = 0;
        } else {
            --this.x;
        }
    }

    protected void setch(char ch) {
        this.mChars[this.mChIdx] = ch;
    }

    protected Pair find(Pair chain, char[] qname) {
        Pair pair = chain;
        while (pair != null) {
            block4: {
                if (pair.chars.length == qname.length) {
                    for (int i = 0; i < qname.length; ++i) {
                        if (pair.chars[i] == qname[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return pair;
                }
            }
            pair = pair.next;
        }
        return null;
    }

    protected Pair pair(Pair next) {
        Pair pair;
        if (this.mDltd != null) {
            pair = this.mDltd;
            this.mDltd = pair.next;
        } else {
            pair = new Pair();
        }
        pair.next = next;
        return pair;
    }

    protected Pair del(Pair pair) {
        Pair next = pair.next;
        pair.name = null;
        pair.ns = null;
        pair.value = null;
        pair.chars = null;
        pair.list = null;
        pair.next = this.mDltd;
        this.mDltd = pair;
        return next;
    }

    private void reportUCS4(int ucs4) throws Exception {
        int tmp = ucs4 - 65536;
        this.bappend((char)(0xD800 | tmp >> 10));
        this.bappend((char)(0xDC00 | tmp & 0x3FF));
        this.bflash();
    }

    public void clearSkippedElements() {
        this.skippedElements.clear();
    }

    public void addSkippedElement(String name, String namespace) {
        this.skippedElements.add(new QualifiedName(name, namespace));
    }

    protected QualifiedName findSkippedElement(String name, String namespace) {
        for (QualifiedName qn : this.skippedElements) {
            if (!qn.name.equals(name) || !qn.namespace.equals(namespace)) continue;
            return qn;
        }
        return null;
    }

    static {
        int i;
        NONS = new char[1];
        Parser.NONS[0] = '\u0000';
        XML = new char[4];
        Parser.XML[0] = 4;
        Parser.XML[1] = 120;
        Parser.XML[2] = 109;
        Parser.XML[3] = 108;
        XMLNS = new char[6];
        Parser.XMLNS[0] = 6;
        Parser.XMLNS[1] = 120;
        Parser.XMLNS[2] = 109;
        Parser.XMLNS[3] = 108;
        Parser.XMLNS[4] = 110;
        Parser.XMLNS[5] = 115;
        XMLSPC = new char[10];
        Parser.XMLSPC[0] = 4;
        Parser.XMLSPC[1] = 120;
        Parser.XMLSPC[2] = 109;
        Parser.XMLSPC[3] = 108;
        Parser.XMLSPC[4] = 58;
        Parser.XMLSPC[5] = 115;
        Parser.XMLSPC[6] = 112;
        Parser.XMLSPC[7] = 97;
        Parser.XMLSPC[8] = 99;
        Parser.XMLSPC[9] = 101;
        XMLID = new char[7];
        Parser.XMLID[0] = 4;
        Parser.XMLID[1] = 120;
        Parser.XMLID[2] = 109;
        Parser.XMLID[3] = 108;
        Parser.XMLID[4] = 58;
        Parser.XMLID[5] = 105;
        Parser.XMLID[6] = 100;
        asctyp = new byte[128];
        for (i = 0; i < 32; i = (int)((short)(i + 1))) {
            int n = i;
            Parser.asctyp[n] = 122;
        }
        Parser.asctyp[9] = 32;
        Parser.asctyp[13] = 32;
        Parser.asctyp[10] = 32;
        while (i < 48) {
            int n = i;
            int n2 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n2;
        }
        while (i <= 57) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 100;
        }
        while (i < 65) {
            int n = i;
            int n3 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n3;
        }
        while (i <= 90) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 65;
        }
        while (i < 97) {
            int n = i;
            int n4 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n4;
        }
        while (i <= 122) {
            int n = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = 97;
        }
        while (i < 128) {
            int n = i;
            int n5 = i;
            i = (short)(i + 1);
            Parser.asctyp[n] = (byte)n5;
        }
        nmttyp = new byte[128];
        for (i = 0; i < 48; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        while (i <= 57) {
            int n = i;
            i = (short)(i + 1);
            Parser.nmttyp[n] = 2;
        }
        while (i < 65) {
            int n = i;
            i = (short)(i + 1);
            Parser.nmttyp[n] = -1;
        }
        for (i = 91; i < 97; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        for (i = 123; i < 128; i = (int)((short)(i + 1))) {
            Parser.nmttyp[i] = -1;
        }
        Parser.nmttyp[95] = 0;
        Parser.nmttyp[58] = 1;
        Parser.nmttyp[46] = 2;
        Parser.nmttyp[45] = 2;
        Parser.nmttyp[32] = 3;
        Parser.nmttyp[9] = 3;
        Parser.nmttyp[13] = 3;
        Parser.nmttyp[10] = 3;
    }

    protected static class QualifiedName {
        private final String name;
        private final String namespace;

        private QualifiedName(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public boolean equals(Object other) {
            if (other instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)other;
                return this.name.equals(qn.name) && this.namespace.equals(qn.namespace);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + 13 * this.namespace.hashCode();
        }
    }
}

