/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.data.pull.ukit.xml;

import com.sun.javafx.data.pull.impl.StreamException;
import com.sun.javafx.data.pull.impl.StreamReader;
import com.sun.javafx.data.pull.ukit.xml.ParserStAX;
import java.io.InputStream;
import java.io.Reader;

public class XMLInputFactoryImp {
    public static final String IS_COALESCING = "javax.xml.stream.isCoalescing";
    public static final String IS_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
    public static final String IS_REPLACING_ENTITY_REFERENCES = "javax.xml.stream.isReplacingEntityReferences";
    public static final String IS_SUPPORTING_EXTERNAL_ENTITIES = "javax.xml.stream.isSupportingExternalEntities";
    public static final String IS_VALIDATING = "javax.xml.stream.isValidating";
    public static final String RESOLVER = "javax.xml.stream.resolver";
    public static final String SUPPORT_DTD = "javax.xml.stream.supportDTD";
    boolean mIsNSAware = true;
    boolean mIsExtEnt;

    public StreamReader createStreamReader(Reader reader) throws StreamException {
        ParserStAX parser = new ParserStAX(reader);
        parser.mIsNSAware = this.mIsNSAware;
        return parser;
    }

    public StreamReader createStreamReader(InputStream stream) throws StreamException {
        ParserStAX parser = new ParserStAX(stream, null);
        parser.mIsNSAware = this.mIsNSAware;
        return parser;
    }

    public StreamReader createStreamReader(InputStream stream, String encoding) throws StreamException {
        if (encoding == null) {
            throw new NullPointerException("");
        }
        ParserStAX parser = new ParserStAX(stream, encoding);
        parser.mIsNSAware = this.mIsNSAware;
        return parser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (IS_VALIDATING.equals(name)) {
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) return;
            throw new IllegalArgumentException(name);
        }
        if (IS_NAMESPACE_AWARE.equals(name)) {
            if (!(value instanceof Boolean)) throw new IllegalArgumentException(name);
            this.mIsNSAware = (Boolean)value;
            return;
        } else {
            if (IS_COALESCING.equals(name)) {
                if (value instanceof Boolean && !((Boolean)value).booleanValue()) return;
                throw new IllegalArgumentException(name);
            }
            if (IS_REPLACING_ENTITY_REFERENCES.equals(name)) {
                if (value instanceof Boolean && ((Boolean)value).booleanValue()) return;
                throw new IllegalArgumentException(name);
            }
            if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(name)) {
                if (!(value instanceof Boolean)) throw new IllegalArgumentException(name);
                this.mIsExtEnt = (Boolean)value;
                return;
            } else {
                if (!SUPPORT_DTD.equals(name)) throw new IllegalArgumentException(name);
                if (value instanceof Boolean && ((Boolean)value).booleanValue()) return;
                throw new IllegalArgumentException(name);
            }
        }
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (IS_VALIDATING.equals(name)) {
            return Boolean.FALSE;
        }
        if (IS_NAMESPACE_AWARE.equals(name)) {
            return this.mIsNSAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (IS_COALESCING.equals(name)) {
            return Boolean.FALSE;
        }
        if (IS_REPLACING_ENTITY_REFERENCES.equals(name)) {
            return Boolean.TRUE;
        }
        if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(name)) {
            return this.mIsExtEnt ? Boolean.TRUE : Boolean.FALSE;
        }
        if (SUPPORT_DTD.equals(name)) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(name);
    }

    public boolean isPropertySupported(String name) {
        if (IS_VALIDATING.equals(name)) {
            return true;
        }
        if (IS_NAMESPACE_AWARE.equals(name)) {
            return true;
        }
        if (IS_COALESCING.equals(name)) {
            return true;
        }
        if (IS_REPLACING_ENTITY_REFERENCES.equals(name)) {
            return true;
        }
        if (IS_SUPPORTING_EXTERNAL_ENTITIES.equals(name)) {
            return true;
        }
        if (SUPPORT_DTD.equals(name)) {
            return true;
        }
        return RESOLVER.equals(name);
    }
}

