/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import com.sun.javafx.io.http.impl.WaitingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class BufferingInputStream
extends InputStream {
    private final WaitingOutputStream wos;
    private final InputStream is;
    private InputStream bis;

    public BufferingInputStream(InputStream in, int totalSize) {
        this.wos = new WaitingOutputStream(null, totalSize);
        this.is = in;
        this.bis = null;
    }

    public InputStream transfer(BaseTask status, long toread) throws IOException {
        if (status.isCancelled()) {
            throw new InterruptedIOException("Cancelled");
        }
        int bufferSize = status.optimalChunkSize(toread);
        status.notifyProgress(true, true, toread);
        byte[] buffer = new byte[bufferSize];
        int total = 0;
        int nread = 0;
        while ((nread = this.is.read(buffer)) > 0) {
            if (status.isCancelled()) {
                throw new InterruptedIOException("Cancelled");
            }
            this.wos.write(buffer, 0, nread);
            status.notifyProgress(true, false, total += nread);
        }
        this.bis = this.wos.getInputStream();
        return this.bis;
    }

    public int read() throws IOException {
        return this.bis == null ? -1 : this.bis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.bis == null ? -1 : this.bis.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis == null ? -1 : this.bis.read(b, off, len);
    }

    public int available() throws IOException {
        return this.bis == null ? 0 : this.bis.available();
    }

    public void close() throws IOException {
        super.close();
        this.wos.close();
        this.is.close();
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
    }

    public boolean markSupported() {
        return this.bis == null ? false : this.bis.markSupported();
    }

    public void mark(int readlimit) {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        this.bis.mark(readlimit);
    }

    public void reset() throws IOException {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        this.bis.reset();
    }

    public long skip(long n) throws IOException {
        if (this.bis == null) {
            throw new IllegalStateException("operation not supported until transfer is complete");
        }
        return this.bis.skip(n);
    }
}

