/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import com.sun.javafx.io.http.impl.BaseTask;
import com.sun.javafx.io.http.impl.BufferingInputStream;
import com.sun.javafx.io.http.impl.Connection;
import com.sun.javafx.io.http.impl.HttpProgress;
import com.sun.javafx.io.http.impl.Profile;
import com.sun.javafx.io.http.impl.Progress;
import com.sun.javafx.io.http.impl.Request;
import com.sun.javafx.io.http.impl.WaitingInputStream;
import com.sun.javafx.io.http.impl.WaitingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTask
extends BaseTask {
    private static final String CANCELLED_TEXT = "Cancelled";
    private Connection connection = null;

    public HttpTask(int id, Request request, Progress progress, Profile profile) {
        super(id, request, progress, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.notifyStart();
        try {
            this.tryRun();
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                this.setException((Exception)t);
            } else {
                boolean error = t instanceof Error;
                String msg = error ? "encountered Error, rethrowing: " : "encountered Throwable: ";
                this.setException(new Exception(msg + t.toString()));
                if (error) {
                    throw (Error)t;
                }
            }
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private boolean canWrite() {
        String method = this.request.getMethod();
        return !"GET".equals(method) && !"HEAD".equals(method) && !"DELETE".equals(method);
    }

    @Override
    public OutputStream getOutputStream(Map<String, String> map) throws IOException {
        if (this.canWrite()) {
            return this.connection == null ? null : new WaitingOutputStream(this.connection.getOutputStream(), this.calculateDefaultStreamSize(this.getContentLength(map)));
        }
        return null;
    }

    private boolean canRead() {
        String method = this.request.getMethod();
        return !"HEAD".equals(method) && !"DELETE".equals(method);
    }

    @Override
    public InputStream getInputStream(Map<String, String> map) throws IOException {
        if (this.canRead()) {
            return this.connection == null ? null : new BufferingInputStream(this.connection.getInputStream(), this.calculateDefaultStreamSize(this.getContentLength(map)));
        }
        return null;
    }

    private int calculateDefaultStreamSize(long contentLength) {
        if (contentLength < 0L) {
            return this.profile.getMaxChunkSize();
        }
        if (contentLength < (long)this.profile.getMinChunkSize()) {
            return this.profile.getMinChunkSize();
        }
        return (int)contentLength;
    }

    private long getContentLength(Map<String, String> map) {
        String contentLength;
        long length = -1L;
        if (map != null && (contentLength = map.get("content-length")) instanceof String) {
            try {
                length = Long.parseLong(contentLength);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(InputStream is, OutputStream os, boolean readOperation, long totalToTransfer) throws IOException {
        try {
            int bytesRead;
            if (this.isCancelled()) {
                throw new InterruptedIOException(CANCELLED_TEXT);
            }
            byte[] buffer = new byte[this.optimalChunkSize(totalToTransfer)];
            long totalWritten = 0L;
            this.notifyProgress(readOperation, true, totalToTransfer);
            while ((bytesRead = is.read(buffer)) != -1) {
                if (this.isCancelled()) {
                    throw new InterruptedIOException(CANCELLED_TEXT);
                }
                os.write(buffer, 0, bytesRead);
                os.flush();
                this.notifyProgress(readOperation, false, totalWritten += (long)bytesRead);
            }
        }
        finally {
            try {
                os.close();
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRun() throws IOException, InterruptedException {
        InputStream errorStream;
        String responseMessage;
        this.connection = this.profile.newConnection();
        this.connection.open(this.request.getLocation());
        this.connection.setMethod(this.request.getMethod());
        if (this.request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : this.request.getHeaders().entrySet()) {
                this.connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        this.notifyConnect(true);
        this.connection.connect();
        this.notifyConnect(false);
        InputStream source = this.request.getSource();
        if (source != null && this.canWrite()) {
            this.notifyWrite(true);
            this.transfer(source, this.connection.getOutputStream(), false, this.getContentLength(this.request.getHeaders()));
            this.notifyWrite(false);
        } else {
            OutputStream os = this.getOutputStream(this.request.getHeaders());
            if (os != null) {
                this.notifyWrite(true);
                try {
                    this.notifyOutput(os);
                    if (os instanceof WaitingOutputStream) {
                        WaitingOutputStream wos = (WaitingOutputStream)os;
                        wos.waitUntilClosed();
                        wos.transfer(this, this.getContentLength(this.request.getHeaders()));
                    }
                }
                finally {
                    os.close();
                }
                this.notifyWrite(false);
            }
        }
        this.notifyHeaders(true);
        int responseCode = this.connection.getResponseCode();
        if (responseCode != 0) {
            this.notifyResponseCode(responseCode);
        }
        if ((responseMessage = this.connection.getResponseMessage()) != null) {
            this.notifyResponseMessage(responseMessage);
        }
        if ((errorStream = this.connection.getErrorStream()) != null) {
            this.notifyError(errorStream);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String key = this.connection.getHeaderFieldKey(i);
            String value = this.connection.getHeaderField(i);
            if (key == null && value == null) break;
            map.put(key == null ? null : key.toLowerCase(), value);
        }
        this.notifyResponseHeaders(map);
        this.notifyHeaders(false);
        long length = this.getContentLength(map);
        OutputStream sink = this.request.getSink();
        if (sink != null && this.canRead()) {
            this.notifyRead(true);
            this.transfer(this.connection.getInputStream(), sink, true, length);
            this.notifyRead(false);
        } else {
            InputStream is = this.getInputStream(map);
            if (is != null) {
                this.notifyRead(true);
                try {
                    if (is instanceof BufferingInputStream) {
                        BufferingInputStream bis = (BufferingInputStream)is;
                        WaitingInputStream wis = new WaitingInputStream(bis.transfer(this, length));
                        if (bis.available() > 0) {
                            this.notifyInput(wis);
                            wis.waitUntilClosed();
                        }
                    } else {
                        this.notifyInput(is);
                    }
                }
                finally {
                    is.close();
                }
                this.notifyRead(false);
            }
        }
    }

    protected void notifyError(InputStream error) {
        this.profile.deferTask(new ErrorNotifier(this.progress, error));
    }

    protected void notifyResponseCode(int code) {
        this.profile.deferTask(new ResponseCodeNotifier(this.progress, code));
    }

    protected void notifyResponseMessage(String message) {
        this.profile.deferTask(new ResponseMessageNotifier(this.progress, message));
    }

    protected void notifyResponseHeaders(Map<String, String> headers) {
        this.profile.deferTask(new ResponseHeadersNotifier(this.progress, headers));
    }

    public static String encodeURL(String params, boolean encodeAsterisk, boolean encodeSpaceAsPercent) throws UnsupportedEncodingException {
        if (params == null) {
            return null;
        }
        byte[] buf = params.getBytes("utf-8");
        StringBuffer sbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            byte ch = buf[i];
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 45 || ch == 95 || ch == 46 || ch == 126 || ch == 42 && !encodeAsterisk) {
                sbuf.append((char)ch);
                continue;
            }
            if (ch == 32 && !encodeSpaceAsPercent) {
                sbuf.append('+');
                continue;
            }
            sbuf.append('%');
            String digit = Integer.toHexString(ch & 0xFF).toUpperCase();
            if (digit.length() == 1) {
                sbuf.append("0");
            }
            sbuf.append(digit);
        }
        return sbuf.toString();
    }

    static final class ErrorNotifier
    extends BaseTask.Notifier {
        private final InputStream is;

        ErrorNotifier(Progress progress, InputStream is) {
            super(progress);
            this.is = is;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http error stream to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setError(this.is);
        }
    }

    static final class ResponseCodeNotifier
    extends BaseTask.Notifier {
        private final int code;

        ResponseCodeNotifier(Progress progress, int code) {
            super(progress);
            this.code = code;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response code to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setResponseCode(this.code);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ResponseHeadersNotifier
    extends BaseTask.Notifier {
        private final Map<String, String> headers;

        ResponseHeadersNotifier(Progress progress, Map<String, String> headers) {
            super(progress);
            this.headers = headers;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response headers to non-http progress");
            }
        }

        @Override
        public void run() {
            ((HttpProgress)this.progress).setResponseHeaders(this.headers);
        }
    }

    static final class ResponseMessageNotifier
    extends BaseTask.Notifier {
        private final String message;

        ResponseMessageNotifier(Progress progress, String message) {
            super(progress);
            this.message = message;
            if (!(progress instanceof HttpProgress)) {
                throw new IllegalArgumentException("cannot report http response message to non-http progress");
            }
        }

        public void run() {
            ((HttpProgress)this.progress).setResponseMessage(this.message);
        }
    }
}

