/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.http.impl;

import java.io.IOException;
import java.io.InputStream;

class WaitingInputStream
extends InputStream {
    private final InputStream is;
    private volatile boolean closed;

    WaitingInputStream(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("\"InputStream in\" has illegal value: null");
        }
        this.is = in;
        this.closed = false;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        WaitingInputStream waitingInputStream = this;
        synchronized (waitingInputStream) {
            if (!this.closed) {
                this.is.close();
                this.closed = true;
            }
            this.notifyAll();
        }
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilClosed() throws InterruptedException {
        WaitingInputStream waitingInputStream = this;
        synchronized (waitingInputStream) {
            while (!this.closed) {
                this.wait();
            }
        }
    }
}

