/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwako.anzeige.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.sportdata.setppwako.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppwako.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppwako.anzeige.utils.FehlerFenster;
import org.sportdata.setppwako.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setppwako.anzeige.utils.License;
import org.sportdata.setppwako.anzeige.version.Version;

public class SettingsBreak
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private JPanel b;
    private JButton c;
    private JTextField d;

    public SettingsBreak() {
        this.setTitle(Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 750) / 2, (screenSize.height - 300) / 2, 750, 300);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SettingsBreak.this.setVisible(false);
                SettingsBreak.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(1, 1));
        JPanel jpwarnpeep = new JPanel();
        jpwarnpeep.setLayout(new GridLayout(1, 1));
        jpwarnpeep.setBorder(new TitledBorder(null, AnzeigeResource.getResourceString("general.break"), 0, 0, new Font("Dialog", 1, 10)));
        this.d = new JTextField(10);
        this.d.setText("");
        JLabel lsecondstext = new JLabel(AnzeigeResource.getResourceString("fight.time.seconds"));
        JButton bsettime = new JButton(AnzeigeResource.getResourceString("general.set"));
        bsettime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    int seconds = Integer.parseInt(SettingsBreak.this.d.getText().trim());
                    if (seconds > 0) {
                        AnzeigePropertiesHelper.setPpwakobreaktime("" + seconds);
                        AnzeigePropertiesHelper.saveAnzeigeProps();
                    } else {
                        new FehlerFenster(AnzeigeResource.getResourceString("break.custom.time.error"));
                    }
                }
                catch (Exception e) {
                    new FehlerFenster(AnzeigeResource.getResourceString("break.custom.time.error"));
                }
            }
        });
        JButton bwarnpeepreset = new JButton(AnzeigeResource.getResourceString("general.reset"));
        bwarnpeepreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AnzeigePropertiesHelper.setPpwakobreaktime("");
                    AnzeigePropertiesHelper.saveAnzeigeProps();
                    SettingsBreak.this.d.setText("60");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        JPanel penchosentime = new JPanel();
        penchosentime.add(lsecondstext);
        penchosentime.add(this.d);
        penchosentime.add(bsettime);
        penchosentime.add(bwarnpeepreset);
        jpwarnpeep.add(penchosentime);
        this.a.add(jpwarnpeep);
        this.a();
        this.b = new JPanel();
        this.c = new JButton(AnzeigeResource.getResourceString("general.close"));
        this.c.addActionListener(this);
        this.b.add(this.c);
        this.add((Component)this.b, "South");
        this.add(this.a);
    }

    private void a() {
        if (!AnzeigePropertiesHelper.getPpwakobreaktime().equals("")) {
            this.d.setText(AnzeigePropertiesHelper.getPpwakobreaktime());
        } else {
            this.d.setText("60");
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

