/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppjudo.anzeigeIS.md5;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.sportdata.setppjudo.anzeigeIS.md5.MD5;

public class MD5InputStream
extends FilterInputStream {
    private MD5 a = new MD5();

    public MD5InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        if ((c & 0xFFFFFF00) != 0) {
            System.out.println("MD5InputStream.read() got character with (c & ~0xff) != 0)!");
        } else {
            this.a.Update(c);
        }
        return c;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int r = this.in.read(bytes, offset, length);
        if (r == -1) {
            return r;
        }
        this.a.Update(bytes, offset, r);
        return r;
    }

    public byte[] hash() {
        return this.a.Final();
    }

    public MD5 getMD5() {
        return this.a;
    }

    public static void main(String[] arg) {
        try {
            String filename = arg[arg.length - 1];
            boolean use_default_md5 = false;
            boolean use_native_lib = true;
            int i = 0;
            while (i < arg.length - 1) {
                if (arg[i].equals("--use-default-md5")) {
                    use_default_md5 = true;
                } else if (arg[i].equals("--no-native-lib")) {
                    use_native_lib = false;
                }
                ++i;
            }
            byte[] buf = new byte[65536];
            if (use_default_md5) {
                int num_read;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
                MessageDigest digest = MessageDigest.getInstance("MD5");
                while ((num_read = ((InputStream)in).read(buf)) != -1) {
                    digest.update(buf, 0, num_read);
                }
                System.out.println(MD5.asHex(digest.digest()) + "  " + filename);
                ((InputStream)in).close();
            } else {
                int num_read;
                if (!use_native_lib) {
                    MD5.initNativeLibrary(true);
                }
                MD5InputStream in = new MD5InputStream(new BufferedInputStream(new FileInputStream(filename)));
                while ((num_read = in.read(buf)) != -1) {
                }
                System.out.println(MD5.asHex(in.hash()) + "  " + filename);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

